/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.trace.api.datastreams.Backlog;
import ddtrot.dd.trace.api.datastreams.StatsPoint;
import ddtrot.dd.trace.core.datastreams.StatsGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatsBucket {
    private final long startTimeNanos;
    private final long bucketDurationNanos;
    private final Map<Long, StatsGroup> hashToGroup = new HashMap<Long, StatsGroup>();
    private final Map<List<String>, Long> backlogs = new HashMap<List<String>, Long>();

    public StatsBucket(long startTimeNanos, long bucketDurationNanos) {
        this.startTimeNanos = startTimeNanos;
        this.bucketDurationNanos = bucketDurationNanos;
    }

    public void addPoint(StatsPoint statsPoint) {
        this.hashToGroup.computeIfAbsent(statsPoint.getAggregationHash(), hash -> new StatsGroup(statsPoint.getEdgeTags(), statsPoint.getHash(), statsPoint.getParentHash())).add(statsPoint.getPathwayLatencyNano(), statsPoint.getEdgeLatencyNano(), statsPoint.getPayloadSizeBytes());
    }

    public void addBacklog(Backlog backlog) {
        this.backlogs.compute(backlog.getSortedTags(), (k, v) -> v == null ? backlog.getValue() : Math.max(v, backlog.getValue()));
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getBucketDurationNanos() {
        return this.bucketDurationNanos;
    }

    public Collection<StatsGroup> getGroups() {
        return this.hashToGroup.values();
    }

    public Collection<Map.Entry<List<String>, Long>> getBacklogs() {
        return this.backlogs.entrySet();
    }
}

