/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.environment;

import javax.annotation.Nullable;

public final class SystemProperties {
    private SystemProperties() {
    }

    @Nullable
    public static String get(String property) {
        return SystemProperties.getOrDefault(property, null);
    }

    public static String getOrDefault(String property, String defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        try {
            return System.getProperty(property, defaultValue);
        }
        catch (SecurityException ignored) {
            return defaultValue;
        }
    }

    public static boolean set(String property, String value) {
        if (property == null || value == null) {
            return false;
        }
        try {
            System.setProperty(property, value);
            return true;
        }
        catch (SecurityException ignored) {
            return false;
        }
    }

    @Nullable
    public static String clear(String property) {
        if (property == null) {
            return null;
        }
        try {
            return System.clearProperty(property);
        }
        catch (SecurityException ignored) {
            return null;
        }
    }
}

