/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.http;

import ddtrot.dd.appsec.api.blocking.BlockingException;
import ddtrot.dd.trace.api.gateway.BlockResponseFunction;
import ddtrot.dd.trace.api.gateway.Flow;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.http.StoredBodySupplier;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredCharBody
implements StoredBodySupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoredCharBody.class);
    private static final int MIN_BUFFER_SIZE = 128;
    private static final int MAX_BUFFER_SIZE = 131072;
    private static final int GROW_FACTOR = 4;
    private static final CharBuffer EMPTY_CHAR_BUFFER = CharBuffer.allocate(0);
    private final RequestContext httpContext;
    private final BiFunction<RequestContext, StoredBodySupplier, Void> startCb;
    private final BiFunction<RequestContext, StoredBodySupplier, Flow<Void>> endCb;
    private final StoredBodySupplier supplierInNotifications;
    private boolean listenerNotified;
    private char[] storedBody;
    private int storedBodyLen;
    private boolean bodyReadStarted = false;

    public StoredCharBody(RequestContext httpContext, BiFunction<RequestContext, StoredBodySupplier, Void> startCb, BiFunction<RequestContext, StoredBodySupplier, Flow<Void>> endCb, int lengthHint) {
        this(httpContext, startCb, endCb, lengthHint, null);
    }

    StoredCharBody(RequestContext httpContext, BiFunction<RequestContext, StoredBodySupplier, Void> startCb, BiFunction<RequestContext, StoredBodySupplier, Flow<Void>> endCb, int lengthHint, StoredBodySupplier supplierInNotifications) {
        this.httpContext = httpContext;
        this.startCb = startCb;
        this.endCb = endCb;
        if (lengthHint != 0) {
            int initialSize = Math.max(128, Math.min(lengthHint, 131072));
            this.storedBody = new char[initialSize];
        }
        this.supplierInNotifications = supplierInNotifications != null ? supplierInNotifications : this;
    }

    public synchronized void appendData(char[] chars, int start, int end) {
        try {
            int newDataLen = end - start;
            if (newDataLen <= 0) {
                return;
            }
            if (!this.maybeExtendStorage(newDataLen)) {
                return;
            }
            int lenToCopy = Math.min(newDataLen, this.capacityLeft());
            System.arraycopy(chars, start, this.storedBody, this.storedBodyLen, lenToCopy);
            this.storedBodyLen += lenToCopy;
        }
        catch (Throwable e) {
            LOGGER.debug("Error appending char array chunk", e);
        }
        this.maybeNotifyStart();
    }

    public synchronized void appendData(CharBuffer buffer) {
        try {
            int inputLen = buffer.remaining();
            if (inputLen == 0) {
                return;
            }
            if (!this.maybeExtendStorage(inputLen)) {
                return;
            }
            int lenToCopy = Math.min(inputLen, this.capacityLeft());
            buffer.get(this.storedBody, this.storedBodyLen, lenToCopy);
            this.storedBodyLen += lenToCopy;
        }
        catch (Throwable e) {
            LOGGER.debug("Error appending char buffer", e);
        }
        this.maybeNotifyStart();
    }

    private boolean maybeExtendStorage(int newDataLen) {
        if (this.storedBody == null) {
            int initialSize = Math.max(Math.min(newDataLen, 131072), 128);
            this.storedBody = new char[initialSize];
        } else {
            if (this.storedBodyLen == 131072) {
                return false;
            }
            if (this.capacityLeft() < newDataLen) {
                int newSize = Math.min(Math.max(this.storedBodyLen + newDataLen, this.storedBodyLen * 4), 131072);
                this.storedBody = Arrays.copyOf(this.storedBody, newSize);
            }
        }
        return true;
    }

    public synchronized void appendData(String s) {
        try {
            int newDataLen = s.length();
            if (!this.maybeExtendStorage(newDataLen)) {
                return;
            }
            int lenToCopy = Math.min(newDataLen, this.capacityLeft());
            s.getChars(0, lenToCopy, this.storedBody, this.storedBodyLen);
            this.storedBodyLen += lenToCopy;
        }
        catch (Throwable e) {
            LOGGER.debug("Error appending string", e);
        }
        this.maybeNotifyStart();
    }

    private int capacityLeft() {
        return this.storedBody.length - this.storedBodyLen;
    }

    public synchronized void appendData(int utf16CodeUnit) {
        try {
            if (utf16CodeUnit < 0) {
                return;
            }
            if (!this.maybeExtendStorage(1)) {
                return;
            }
            this.storedBody[this.storedBodyLen] = (char)utf16CodeUnit;
            ++this.storedBodyLen;
        }
        catch (Throwable e) {
            LOGGER.debug("Error appending code unit", e);
        }
        this.maybeNotifyStart();
    }

    void maybeNotifyStart() {
        if (!this.bodyReadStarted) {
            this.bodyReadStarted = true;
            this.startCb.apply(this.httpContext, this.supplierInNotifications);
        }
    }

    public synchronized Flow<Void> maybeNotify() {
        if (!this.listenerNotified) {
            this.listenerNotified = true;
            if (!this.bodyReadStarted) {
                this.startCb.apply(this.httpContext, this.supplierInNotifications);
            }
            return this.endCb.apply(this.httpContext, this.supplierInNotifications);
        }
        return Flow.ResultFlow.empty();
    }

    public synchronized void maybeNotifyAndBlock() {
        Flow<Void> flow = this.maybeNotify();
        Flow.Action action = flow.getAction();
        if (action instanceof Flow.Action.RequestBlockingAction) {
            Flow.Action.RequestBlockingAction rba = (Flow.Action.RequestBlockingAction)action;
            BlockResponseFunction blockResponseFunction = this.httpContext.getBlockResponseFunction();
            if (blockResponseFunction != null) {
                blockResponseFunction.tryCommitBlockingResponse(this.httpContext.getTraceSegment(), rba.getStatusCode(), rba.getBlockingContentType(), rba.getExtraHeaders());
            }
            throw new BlockingException("Blocked request (for request body stream read)");
        }
    }

    @Override
    public synchronized CharBuffer get() {
        if (this.storedBodyLen == 0) {
            return EMPTY_CHAR_BUFFER;
        }
        return CharBuffer.wrap(this.storedBody, 0, this.storedBodyLen);
    }

    synchronized boolean isLimitReached() {
        return this.storedBodyLen == 131072;
    }

    synchronized void dropData() {
        this.storedBodyLen = 0;
    }
}

