/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import ddtrot.dd.environment.EnvironmentVariables;
import ddtrot.dd.environment.SystemProperties;
import ddtrot.dd.trace.bootstrap.config.provider.StableConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfig.Rule;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfig.Selector;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfig.StableConfig;
import ddtrot.dd.yaml.YamlParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableConfigParser {
    private static final Logger log = LoggerFactory.getLogger(StableConfigParser.class);
    private static final String ENVIRONMENT_VARIABLES_PREFIX = "environment_variables['";
    private static final String PROCESS_ARGUMENTS_PREFIX = "process_arguments['";
    static final int MAX_FILE_SIZE_BYTES = 262144;
    private static final String UNDEFINED_VALUE = "";

    public static StableConfigSource.StableConfig parse(String filePath) throws IOException {
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (Files.size(path) > 262144L) {
                log.warn("Configuration file {} exceeds max size {} bytes; dropping.", (Object)filePath, (Object)262144);
                return StableConfigSource.StableConfig.EMPTY;
            }
            String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            String processedContent = StableConfigParser.processTemplate(content);
            Object parsedYaml = YamlParser.parse(processedContent);
            StableConfig data = new StableConfig(parsedYaml);
            String configId = data.getConfigId();
            Map<String, Object> configMap = data.getApmConfigurationDefault();
            List<Rule> rules = data.getApmConfigurationRules();
            if (!rules.isEmpty()) {
                for (Rule rule : rules) {
                    if (!StableConfigParser.doesRuleMatch(rule)) continue;
                    LinkedHashMap<String, Object> mergedConfigMap = new LinkedHashMap<String, Object>(configMap);
                    mergedConfigMap.putAll(rule.getConfiguration());
                    return new StableConfigSource.StableConfig(configId, mergedConfigMap);
                }
            }
            if (!configMap.isEmpty()) {
                return new StableConfigSource.StableConfig(configId, configMap);
            }
            if (configId != null) {
                return new StableConfigSource.StableConfig(configId, Collections.emptyMap());
            }
        }
        catch (IOException e) {
            log.debug("Failed to read the stable configuration file: {}", (Object)filePath, (Object)e);
        }
        return StableConfigSource.StableConfig.EMPTY;
    }

    private static boolean doesRuleMatch(Rule rule) {
        for (Selector selector : rule.getSelectors()) {
            if (StableConfigParser.selectorMatch(selector.getOrigin(), selector.getMatches(), selector.getOperator(), selector.getKey())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchOperator(String value, String operator, List<String> matches) {
        if (value == null || operator == null) {
            return false;
        }
        if ("exists".equals(operator)) {
            return true;
        }
        if (matches == null || matches.isEmpty()) {
            return false;
        }
        value = value.toLowerCase(Locale.ROOT);
        for (String match : matches) {
            if (match == null) continue;
            match = match.toLowerCase(Locale.ROOT);
            switch (operator) {
                case "equals": {
                    return value.equals(match);
                }
                case "starts_with": {
                    return value.startsWith(match);
                }
                case "ends_with": {
                    return value.endsWith(match);
                }
                case "contains": {
                    return value.contains(match);
                }
            }
            return false;
        }
        return false;
    }

    static boolean selectorMatch(String origin, List<String> matches, String operator, String key) {
        if (operator == null) {
            return false;
        }
        operator = operator.toLowerCase(Locale.ROOT);
        switch (origin.toLowerCase(Locale.ROOT)) {
            case "language": {
                if ("exists".equals(operator)) {
                    return false;
                }
                return StableConfigParser.matchOperator("java", operator, matches);
            }
            case "environment_variables": {
                if (key == null) {
                    return false;
                }
                String envValue = EnvironmentVariables.get(key.toUpperCase(Locale.ROOT));
                return StableConfigParser.matchOperator(envValue, operator, matches);
            }
            case "process_arguments": {
                if (key == null) {
                    return false;
                }
                if (!key.startsWith("-D")) {
                    log.warn("Ignoring unsupported process_arguments entry in selector match, '{}'. Only system properties specified with the '-D' prefix are supported.", (Object)key);
                    return false;
                }
                String argValue = SystemProperties.get(key.substring(2));
                return StableConfigParser.matchOperator(argValue, operator, matches);
            }
            case "tags": {
                return false;
            }
        }
        return false;
    }

    static String processTemplate(String content) throws IOException {
        int closeIndex;
        int openIndex = content.indexOf("{{");
        if (openIndex == -1) {
            return content;
        }
        StringBuilder result = new StringBuilder(content.length());
        result.append(content, 0, openIndex);
        while (true) {
            if ((closeIndex = content.indexOf("}}", openIndex)) == -1) {
                throw new IOException("Unterminated template in config");
            }
            String templateVar = content.substring(openIndex + 2, closeIndex).trim();
            String value = StableConfigParser.processTemplateVar(templateVar);
            result.append(value);
            openIndex = content.indexOf("{{", closeIndex);
            if (openIndex == -1) break;
            result.append(content, closeIndex + 2, openIndex);
        }
        result.append(content, closeIndex + 2, content.length());
        return result.toString();
    }

    private static String processTemplateVar(String templateVar) throws IOException {
        if (templateVar.startsWith(ENVIRONMENT_VARIABLES_PREFIX) && templateVar.endsWith("']")) {
            String envVar = templateVar.substring(ENVIRONMENT_VARIABLES_PREFIX.length(), templateVar.length() - 2).trim();
            if (envVar.isEmpty()) {
                throw new IOException("Empty environment variable name in template");
            }
            String value = EnvironmentVariables.get(envVar.toUpperCase(Locale.ROOT));
            if (value == null || value.isEmpty()) {
                return UNDEFINED_VALUE;
            }
            return value;
        }
        if (templateVar.startsWith(PROCESS_ARGUMENTS_PREFIX) && templateVar.endsWith("']")) {
            String processArg = templateVar.substring(PROCESS_ARGUMENTS_PREFIX.length(), templateVar.length() - 2).trim();
            if (processArg.isEmpty()) {
                throw new IOException("Empty process argument in template");
            }
            if (!processArg.startsWith("-D")) {
                log.warn("Ignoring unsupported process_arguments entry in template variable, '{}'. Only system properties specified with the '-D' prefix are supported.", (Object)processArg);
                return UNDEFINED_VALUE;
            }
            String value = SystemProperties.get(processArg.substring(2));
            if (value == null || value.isEmpty()) {
                return UNDEFINED_VALUE;
            }
            return value;
        }
        return UNDEFINED_VALUE;
    }
}

