/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import ddtrot.dd.context.Context;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ScopeContinuation
implements AgentScope.Continuation {
    private static final AtomicIntegerFieldUpdater<ScopeContinuation> COUNT = AtomicIntegerFieldUpdater.newUpdater(ScopeContinuation.class, "count");
    private static final int CANCELLED = -1073741824;
    private static final int HELD = 0x40000000;
    final ContinuableScopeManager scopeManager;
    final Context context;
    final byte source;
    final AgentTraceCollector traceCollector;
    private volatile int count = 0;

    ScopeContinuation(ContinuableScopeManager scopeManager, Context context, byte source, AgentTraceCollector traceCollector) {
        this.scopeManager = scopeManager;
        this.context = context;
        this.source = source;
        this.traceCollector = traceCollector;
    }

    ScopeContinuation register() {
        this.traceCollector.registerContinuation(this);
        this.scopeManager.healthMetrics.onCaptureContinuation();
        return this;
    }

    @Override
    public AgentScope.Continuation hold() {
        COUNT.compareAndSet(this, 0, 0x40000000);
        return this;
    }

    @Override
    public AgentScope activate() {
        if (COUNT.incrementAndGet(this) > 0) {
            return this.scopeManager.continueSpan(this, this.context, this.source);
        }
        COUNT.decrementAndGet(this);
        return AgentTracer.noopScope();
    }

    public void cancel() {
        int current = this.count;
        while (current >= 0x40000000) {
            COUNT.compareAndSet(this, current, current - 0x40000000);
            current = this.count;
        }
        while (current == 0) {
            if (COUNT.compareAndSet(this, current, -1073741824)) {
                this.traceCollector.removeContinuation(this);
                this.scopeManager.healthMetrics.onFinishContinuation();
                return;
            }
            current = this.count;
        }
        this.scopeManager.healthMetrics.onCancelContinuation();
    }

    void cancelFromContinuedScopeClose() {
        if (COUNT.compareAndSet(this, 1, -1073741824)) {
            this.traceCollector.removeContinuation(this);
            this.scopeManager.healthMetrics.onFinishContinuation();
        } else if (COUNT.decrementAndGet(this) == 0) {
            this.cancel();
        }
    }

    @Override
    public AgentSpan span() {
        return AgentSpan.fromContext(this.context);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.context;
    }
}

