/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.TagMap;
import ddtrot.dd.trace.api.function.TriConsumer;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class OptimizedTagMap
implements TagMap {
    static final OptimizedTagMap EMPTY = new OptimizedTagMap(new Object[1], 0);
    private final Object[] buckets;
    private int size;
    private boolean frozen;

    public OptimizedTagMap() {
        this.buckets = new Object[16];
        this.size = 0;
        this.frozen = false;
    }

    private OptimizedTagMap(Object[] buckets, int size) {
        this.buckets = buckets;
        this.size = size;
        this.frozen = true;
    }

    @Override
    public final boolean isOptimized() {
        return true;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @Deprecated
    public final Object get(Object tag) {
        if (!(tag instanceof String)) {
            return null;
        }
        return this.getObject((String)tag);
    }

    @Override
    public final Object getObject(String tag) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? null : entry.objectValue();
    }

    @Override
    public final String getString(String tag) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? null : entry.stringValue();
    }

    @Override
    public final boolean getBoolean(String tag) {
        return this.getBooleanOrDefault(tag, false);
    }

    @Override
    public final boolean getBooleanOrDefault(String tag, boolean defaultValue) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? defaultValue : entry.booleanValue();
    }

    @Override
    public final int getInt(String tag) {
        return this.getIntOrDefault(tag, 0);
    }

    @Override
    public final int getIntOrDefault(String tag, int defaultValue) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? defaultValue : entry.intValue();
    }

    @Override
    public final long getLong(String tag) {
        return this.getLongOrDefault(tag, 0L);
    }

    @Override
    public final long getLongOrDefault(String tag, long defaultValue) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? defaultValue : entry.longValue();
    }

    @Override
    public final float getFloat(String tag) {
        return this.getFloatOrDefault(tag, 0.0f);
    }

    @Override
    public final float getFloatOrDefault(String tag, float defaultValue) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? defaultValue : entry.floatValue();
    }

    @Override
    public final double getDouble(String tag) {
        return this.getDoubleOrDefault(tag, 0.0);
    }

    @Override
    public final double getDoubleOrDefault(String tag, double defaultValue) {
        TagMap.Entry entry = this.getEntry(tag);
        return entry == null ? defaultValue : entry.doubleValue();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.getEntry((String)key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (TagMap.Entry entry : this) {
            if (!entry.objectValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        return new Keys(this);
    }

    @Override
    public Collection<Object> values() {
        return new Values(this);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new Entries(this);
    }

    @Override
    public final TagMap.Entry getEntry(String tag) {
        BucketGroup lastGroup;
        TagMap.Entry tagEntry;
        Object[] thisBuckets = this.buckets;
        int hash = TagMap.Entry._hash(tag);
        int bucketIndex = hash & thisBuckets.length - 1;
        Object bucket = thisBuckets[bucketIndex];
        if (bucket == null) {
            return null;
        }
        if (bucket instanceof TagMap.Entry) {
            TagMap.Entry tagEntry2 = (TagMap.Entry)bucket;
            if (tagEntry2.matches(tag)) {
                return tagEntry2;
            }
        } else if (bucket instanceof BucketGroup && (tagEntry = (lastGroup = (BucketGroup)bucket).findInChain(hash, tag)) != null) {
            return tagEntry;
        }
        return null;
    }

    @Override
    @Deprecated
    public final Object put(String tag, Object value) {
        TagMap.Entry entry = this.getAndSet(TagMap.Entry.newAnyEntry(tag, value));
        return entry == null ? null : entry.objectValue();
    }

    @Override
    public final void set(TagMap.Entry newEntry) {
        this.getAndSet(newEntry);
    }

    @Override
    public final void set(String tag, Object value) {
        this.getAndSet(TagMap.Entry.newAnyEntry(tag, value));
    }

    @Override
    public final void set(String tag, CharSequence value) {
        this.getAndSet(TagMap.Entry.newObjectEntry(tag, value));
    }

    @Override
    public final void set(String tag, boolean value) {
        this.getAndSet(TagMap.Entry.newBooleanEntry(tag, value));
    }

    @Override
    public final void set(String tag, int value) {
        this.getAndSet(TagMap.Entry.newIntEntry(tag, value));
    }

    @Override
    public final void set(String tag, long value) {
        this.getAndSet(TagMap.Entry.newLongEntry(tag, value));
    }

    @Override
    public final void set(String tag, float value) {
        this.getAndSet(TagMap.Entry.newFloatEntry(tag, value));
    }

    @Override
    public final void set(String tag, double value) {
        this.getAndSet(TagMap.Entry.newDoubleEntry(tag, value));
    }

    @Override
    public final TagMap.Entry getAndSet(TagMap.Entry newEntry) {
        this.checkWriteAccess();
        Object[] thisBuckets = this.buckets;
        int newHash = newEntry.hash();
        int bucketIndex = newHash & thisBuckets.length - 1;
        Object bucket = thisBuckets[bucketIndex];
        if (bucket == null) {
            thisBuckets[bucketIndex] = newEntry;
            ++this.size;
            return null;
        }
        if (bucket instanceof TagMap.Entry) {
            TagMap.Entry existingEntry = (TagMap.Entry)bucket;
            if (existingEntry.matches(newEntry.tag)) {
                thisBuckets[bucketIndex] = newEntry;
                return existingEntry;
            }
            thisBuckets[bucketIndex] = new BucketGroup(existingEntry.hash(), existingEntry, newHash, newEntry);
            ++this.size;
            return null;
        }
        if (bucket instanceof BucketGroup) {
            BucketGroup lastGroup = (BucketGroup)bucket;
            BucketGroup containingGroup = lastGroup.findContainingGroupInChain(newHash, newEntry.tag);
            if (containingGroup != null) {
                return containingGroup._replace(newHash, newEntry);
            }
            if (!lastGroup.insertInChain(newHash, newEntry)) {
                thisBuckets[bucketIndex] = new BucketGroup(newHash, newEntry, lastGroup);
            }
            ++this.size;
            return null;
        }
        return null;
    }

    @Override
    public TagMap.Entry getAndSet(String tag, Object value) {
        return this.getAndSet(TagMap.Entry.newAnyEntry(tag, value));
    }

    @Override
    public TagMap.Entry getAndSet(String tag, CharSequence value) {
        return this.getAndSet(TagMap.Entry.newObjectEntry(tag, value));
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, boolean value) {
        return this.getAndSet(TagMap.Entry.newBooleanEntry(tag, value));
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, int value) {
        return this.getAndSet(TagMap.Entry.newIntEntry(tag, value));
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, long value) {
        return this.getAndSet(TagMap.Entry.newLongEntry(tag, value));
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, float value) {
        return this.getAndSet(TagMap.Entry.newFloatEntry(tag, value));
    }

    @Override
    public final TagMap.Entry getAndSet(String tag, double value) {
        return this.getAndSet(TagMap.Entry.newDoubleEntry(tag, value));
    }

    @Override
    public final void putAll(Map<? extends String, ? extends Object> map) {
        this.checkWriteAccess();
        if (map instanceof OptimizedTagMap) {
            this.putAllOptimizedMap((OptimizedTagMap)map);
        } else {
            this.putAllUnoptimizedMap(map);
        }
    }

    private final void putAllUnoptimizedMap(Map<? extends String, ? extends Object> that) {
        for (Map.Entry<? extends String, ? extends Object> entry : that.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final void putAll(TagMap that) {
        this.checkWriteAccess();
        if (that instanceof OptimizedTagMap) {
            this.putAllOptimizedMap((OptimizedTagMap)that);
        } else {
            this.putAllUnoptimizedMap(that);
        }
    }

    private final void putAllOptimizedMap(OptimizedTagMap that) {
        if (this.size == 0) {
            this.putAllIntoEmptyMap(that);
        } else {
            this.putAllMerge(that);
        }
    }

    private final void putAllMerge(OptimizedTagMap that) {
        Object[] thisBuckets = this.buckets;
        Object[] thatBuckets = that.buckets;
        for (int i = 0; i < thisBuckets.length && i < thatBuckets.length; ++i) {
            int thisNewGroupSize;
            Object thatBucket = thatBuckets[i];
            if (thatBucket == null) continue;
            Object thisBucket = thisBuckets[i];
            if (thisBucket == null) {
                if (thatBucket instanceof TagMap.Entry) {
                    thisBuckets[i] = thatBucket;
                    ++this.size;
                    continue;
                }
                if (!(thatBucket instanceof BucketGroup)) continue;
                BucketGroup thatGroup = (BucketGroup)thatBucket;
                BucketGroup thisNewGroup = thatGroup.cloneChain();
                thisBuckets[i] = thisNewGroup;
                this.size += thisNewGroup.sizeInChain();
                continue;
            }
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                int thisHash = thisEntry.hash();
                if (thatBucket instanceof TagMap.Entry) {
                    TagMap.Entry thatEntry = (TagMap.Entry)thatBucket;
                    int thatHash = thatEntry.hash();
                    if (thisHash == thatHash && thisEntry.matches(thatEntry.tag())) {
                        thisBuckets[i] = thatEntry;
                        continue;
                    }
                    thisBuckets[i] = new BucketGroup(thisHash, thisEntry, thatHash, thatEntry);
                    ++this.size;
                    continue;
                }
                if (!(thatBucket instanceof BucketGroup)) continue;
                BucketGroup thatGroup = (BucketGroup)thatBucket;
                BucketGroup thisNewGroup = thatGroup.cloneChain();
                thisNewGroupSize = thisNewGroup.sizeInChain();
                TagMap.Entry incomingEntry = thisNewGroup.findInChain(thisHash, thisEntry.tag());
                if (incomingEntry != null) {
                    thisBuckets[i] = thisNewGroup;
                    this.size += thisNewGroupSize - 1;
                    continue;
                }
                if (thisNewGroup.insertInChain(thisHash, thisEntry)) {
                    thisBuckets[i] = thisNewGroup;
                    this.size += thisNewGroupSize;
                    continue;
                }
                thisBuckets[i] = new BucketGroup(thisHash, thisEntry, thisNewGroup);
                this.size += thisNewGroupSize;
                continue;
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup thisGroup = (BucketGroup)thisBucket;
            if (thatBucket instanceof TagMap.Entry) {
                TagMap.Entry thatEntry = (TagMap.Entry)thatBucket;
                int thatHash = thatEntry.hash();
                if (thisGroup.replaceInChain(thatHash, thatEntry) != null) continue;
                if (thisGroup.insertInChain(thatHash, thatEntry)) {
                    ++this.size;
                    continue;
                }
                thisBuckets[i] = new BucketGroup(thatHash, thatEntry, thisGroup);
                ++this.size;
                continue;
            }
            if (!(thatBucket instanceof BucketGroup)) continue;
            BucketGroup thatGroup = (BucketGroup)thatBucket;
            int thisPrevGroupSize = thisGroup.sizeInChain();
            BucketGroup thisNewGroup = thisGroup.replaceOrInsertAllInChain(thatGroup);
            thisNewGroupSize = thisNewGroup.sizeInChain();
            thisBuckets[i] = thisNewGroup;
            this.size += thisNewGroupSize - thisPrevGroupSize;
        }
    }

    private final void putAllIntoEmptyMap(OptimizedTagMap that) {
        Object[] thisBuckets = this.buckets;
        Object[] thatBuckets = that.buckets;
        for (int i = 0; i < thisBuckets.length && i < thatBuckets.length; ++i) {
            Object thatBucket = thatBuckets[i];
            if (thatBucket == null) continue;
            if (thatBucket instanceof BucketGroup) {
                BucketGroup thatGroup = (BucketGroup)thatBucket;
                thisBuckets[i] = thatGroup.cloneChain();
                continue;
            }
            thisBuckets[i] = thatBucket;
        }
        this.size = that.size;
    }

    @Override
    public final void fillMap(Map<? super String, Object> map) {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            Object thisBucket = thisBuckets[i];
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                map.put(thisEntry.tag, thisEntry.objectValue());
                continue;
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup thisGroup = (BucketGroup)thisBucket;
            thisGroup.fillMapFromChain(map);
        }
    }

    @Override
    public final void fillStringMap(Map<? super String, ? super String> stringMap) {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            Object thisBucket = thisBuckets[i];
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                stringMap.put(thisEntry.tag, thisEntry.stringValue());
                continue;
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup thisGroup = (BucketGroup)thisBucket;
            thisGroup.fillStringMapFromChain(stringMap);
        }
    }

    @Override
    public final Object remove(Object tag) {
        if (!(tag instanceof String)) {
            return null;
        }
        TagMap.Entry entry = this.getAndRemove((String)tag);
        return entry == null ? null : entry.objectValue();
    }

    @Override
    public final boolean remove(String tag) {
        return this.getAndRemove(tag) != null;
    }

    @Override
    public final TagMap.Entry getAndRemove(String tag) {
        this.checkWriteAccess();
        Object[] thisBuckets = this.buckets;
        int hash = TagMap.Entry._hash(tag);
        int bucketIndex = hash & thisBuckets.length - 1;
        Object bucket = thisBuckets[bucketIndex];
        if (bucket instanceof TagMap.Entry) {
            TagMap.Entry existingEntry = (TagMap.Entry)bucket;
            if (existingEntry.matches(tag)) {
                thisBuckets[bucketIndex] = null;
                --this.size;
                return existingEntry;
            }
            return null;
        }
        if (bucket instanceof BucketGroup) {
            BucketGroup lastGroup = (BucketGroup)bucket;
            BucketGroup containingGroup = lastGroup.findContainingGroupInChain(hash, tag);
            if (containingGroup == null) {
                return null;
            }
            TagMap.Entry existingEntry = containingGroup._remove(hash, tag);
            if (containingGroup._isEmpty()) {
                this.buckets[bucketIndex] = lastGroup.removeGroupInChain(containingGroup);
            }
            --this.size;
            return existingEntry;
        }
        return null;
    }

    @Override
    public final TagMap copy() {
        OptimizedTagMap copy = new OptimizedTagMap();
        copy.putAllIntoEmptyMap(this);
        return copy;
    }

    @Override
    public final TagMap immutableCopy() {
        if (this.frozen) {
            return this;
        }
        return this.copy().freeze();
    }

    @Override
    public final Iterator<TagMap.Entry> iterator() {
        return new EntryIterator(this);
    }

    @Override
    public final Stream<TagMap.Entry> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public final void forEach(Consumer<? super TagMap.Entry> consumer) {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            Object thisBucket = thisBuckets[i];
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                consumer.accept(thisEntry);
                continue;
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup thisGroup = (BucketGroup)thisBucket;
            thisGroup.forEachInChain(consumer);
        }
    }

    @Override
    public final <T> void forEach(T thisObj, BiConsumer<T, ? super TagMap.Entry> consumer) {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            Object thisBucket = thisBuckets[i];
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                consumer.accept(thisObj, thisEntry);
                continue;
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup thisGroup = (BucketGroup)thisBucket;
            thisGroup.forEachInChain(thisObj, consumer);
        }
    }

    @Override
    public final <T, U> void forEach(T thisObj, U otherObj, TriConsumer<T, U, ? super TagMap.Entry> consumer) {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            Object thisBucket = thisBuckets[i];
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                consumer.accept((U)thisObj, (TagMap.Entry)otherObj, (TagMap.Entry)((TagMap.Entry)thisEntry));
                continue;
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup thisGroup = (BucketGroup)thisBucket;
            thisGroup.forEachInChain(thisObj, otherObj, consumer);
        }
    }

    @Override
    public final void clear() {
        this.checkWriteAccess();
        Arrays.fill(this.buckets, null);
        this.size = 0;
    }

    @Override
    public final OptimizedTagMap freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public final void checkWriteAccess() {
        if (this.frozen) {
            throw new IllegalStateException("TagMap frozen");
        }
    }

    final void checkIntegrity() {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            BucketGroup thisGroup;
            Object thisBucket = thisBuckets[i];
            if (thisBucket instanceof TagMap.Entry) {
                TagMap.Entry thisEntry = (TagMap.Entry)thisBucket;
                int thisHash = thisEntry.hash();
                int expectedBucket = thisHash & thisBuckets.length - 1;
                if (expectedBucket == i) continue;
                throw new IllegalStateException("incorrect bucket");
            }
            if (!(thisBucket instanceof BucketGroup)) continue;
            BucketGroup curGroup = thisGroup = (BucketGroup)thisBucket;
            while (curGroup != null) {
                for (int j = 0; j < 4; ++j) {
                    TagMap.Entry thisEntry = curGroup._entryAt(i);
                    if (thisEntry == null) continue;
                    int thisHash = thisEntry.hash();
                    assert (curGroup._hashAt(i) == thisHash);
                    int expectedBucket = thisHash & thisBuckets.length - 1;
                    if (expectedBucket == i) continue;
                    throw new IllegalStateException("incorrect bucket");
                }
                curGroup = curGroup.prev;
            }
        }
        if (this.size != this.computeSize()) {
            throw new IllegalStateException("incorrect size");
        }
        if (this.isEmpty() != this.checkIfEmpty()) {
            throw new IllegalStateException("incorrect empty status");
        }
    }

    final int computeSize() {
        Object[] thisBuckets = this.buckets;
        int size = 0;
        for (int i = 0; i < thisBuckets.length; ++i) {
            Object curBucket = thisBuckets[i];
            if (curBucket instanceof TagMap.Entry) {
                ++size;
                continue;
            }
            if (!(curBucket instanceof BucketGroup)) continue;
            BucketGroup curGroup = (BucketGroup)curBucket;
            size += curGroup.sizeInChain();
        }
        return size;
    }

    final boolean checkIfEmpty() {
        Object[] thisBuckets = this.buckets;
        for (int i = 0; i < thisBuckets.length; ++i) {
            BucketGroup curGroup;
            Object curBucket = thisBuckets[i];
            if (curBucket instanceof TagMap.Entry) {
                return false;
            }
            if (!(curBucket instanceof BucketGroup) || (curGroup = (BucketGroup)curBucket).isEmptyChain()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        this.checkWriteAccess();
        return TagMap.super.compute(key, remappingFunction);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ? extends Object> mappingFunction) {
        this.checkWriteAccess();
        return TagMap.super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ? extends Object> remappingFunction) {
        this.checkWriteAccess();
        return TagMap.super.computeIfPresent(key, remappingFunction);
    }

    public final String toString() {
        return this.toPrettyString();
    }

    final String toPrettyString() {
        boolean first = true;
        StringBuilder ledger = new StringBuilder(128);
        ledger.append('{');
        for (TagMap.Entry entry : this) {
            if (first) {
                first = false;
            } else {
                ledger.append(", ");
            }
            ledger.append(entry.tag).append('=').append(entry.stringValue());
        }
        ledger.append('}');
        return ledger.toString();
    }

    final String toInternalString() {
        Object[] thisBuckets = this.buckets;
        StringBuilder ledger = new StringBuilder(128);
        for (int i = 0; i < thisBuckets.length; ++i) {
            ledger.append('[').append(i).append("] = ");
            Object thisBucket = thisBuckets[i];
            if (thisBucket == null) {
                ledger.append("null");
            } else if (thisBucket instanceof TagMap.Entry) {
                ledger.append('{').append(thisBucket).append('}');
            } else if (thisBucket instanceof BucketGroup) {
                BucketGroup curGroup = (BucketGroup)thisBucket;
                while (curGroup != null) {
                    ledger.append(curGroup).append(" -> ");
                    curGroup = curGroup.prev;
                }
            }
            ledger.append('\n');
        }
        return ledger.toString();
    }

    static final class ValuesIterator
    extends MapIterator<Object> {
        ValuesIterator(OptimizedTagMap map) {
            super(map);
        }

        @Override
        public Object next() {
            return this.nextEntry().objectValue();
        }
    }

    static final class Values
    extends AbstractCollection<Object> {
        final OptimizedTagMap map;

        Values(OptimizedTagMap map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.computeSize();
        }

        @Override
        public boolean isEmpty() {
            return this.map.checkIfEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValuesIterator(this.map);
        }
    }

    static final class KeysIterator
    extends MapIterator<String> {
        KeysIterator(OptimizedTagMap map) {
            super(map);
        }

        @Override
        public String next() {
            return this.nextEntry().tag();
        }
    }

    static final class Keys
    extends AbstractSet<String> {
        final OptimizedTagMap map;

        Keys(OptimizedTagMap map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.computeSize();
        }

        @Override
        public boolean isEmpty() {
            return this.map.checkIfEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public Iterator<String> iterator() {
            return new KeysIterator(this.map);
        }
    }

    static final class Entries
    extends AbstractSet<Map.Entry<String, Object>> {
        private final OptimizedTagMap map;

        Entries(OptimizedTagMap map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.computeSize();
        }

        @Override
        public boolean isEmpty() {
            return this.map.checkIfEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            Iterator<Map.Entry<String, Object>> iter2 = this.map.iterator();
            return iter2;
        }
    }

    static final class BucketGroup {
        static final int LEN = 4;
        int hash0 = 0;
        int hash1 = 0;
        int hash2 = 0;
        int hash3 = 0;
        TagMap.Entry entry0 = null;
        TagMap.Entry entry1 = null;
        TagMap.Entry entry2 = null;
        TagMap.Entry entry3 = null;
        BucketGroup prev = null;

        BucketGroup() {
        }

        BucketGroup(int hash0, TagMap.Entry entry0, BucketGroup prev) {
            this.hash0 = hash0;
            this.entry0 = entry0;
            this.prev = prev;
        }

        BucketGroup(int hash0, TagMap.Entry entry0, int hash1, TagMap.Entry entry1) {
            this.hash0 = hash0;
            this.entry0 = entry0;
            this.hash1 = hash1;
            this.entry1 = entry1;
        }

        BucketGroup(int hash0, TagMap.Entry entry0, int hash1, TagMap.Entry entry1, int hash2, TagMap.Entry entry2, int hash3, TagMap.Entry entry3) {
            this.hash0 = hash0;
            this.entry0 = entry0;
            this.hash1 = hash1;
            this.entry1 = entry1;
            this.hash2 = hash2;
            this.entry2 = entry2;
            this.hash3 = hash3;
            this.entry3 = entry3;
        }

        TagMap.Entry _entryAt(int index) {
            switch (index) {
                case 0: {
                    return this.entry0;
                }
                case 1: {
                    return this.entry1;
                }
                case 2: {
                    return this.entry2;
                }
                case 3: {
                    return this.entry3;
                }
            }
            return null;
        }

        int _hashAt(int index) {
            switch (index) {
                case 0: {
                    return this.hash0;
                }
                case 1: {
                    return this.hash1;
                }
                case 2: {
                    return this.hash2;
                }
                case 3: {
                    return this.hash3;
                }
            }
            return 0;
        }

        int sizeInChain() {
            int size = 0;
            BucketGroup curGroup = this;
            while (curGroup != null) {
                size += curGroup._size();
                curGroup = curGroup.prev;
            }
            return size;
        }

        int _size() {
            return (this.hash0 == 0 ? 0 : 1) + (this.hash1 == 0 ? 0 : 1) + (this.hash2 == 0 ? 0 : 1) + (this.hash3 == 0 ? 0 : 1);
        }

        boolean isEmptyChain() {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                if (!curGroup._isEmpty()) {
                    return false;
                }
                curGroup = curGroup.prev;
            }
            return true;
        }

        boolean _isEmpty() {
            return (this.hash0 | this.hash1 | this.hash2 | this.hash3) == 0;
        }

        BucketGroup findContainingGroupInChain(int hash, String tag) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                if (curGroup._find(hash, tag) != null) {
                    return curGroup;
                }
                curGroup = curGroup.prev;
            }
            return null;
        }

        TagMap.Entry findInChain(int hash, String tag) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                TagMap.Entry curEntry = curGroup._find(hash, tag);
                if (curEntry != null) {
                    return curEntry;
                }
                curGroup = curGroup.prev;
            }
            return null;
        }

        TagMap.Entry _find(int hash, String tag) {
            if (this.hash0 == hash && this.entry0.matches(tag)) {
                return this.entry0;
            }
            if (this.hash1 == hash && this.entry1.matches(tag)) {
                return this.entry1;
            }
            if (this.hash2 == hash && this.entry2.matches(tag)) {
                return this.entry2;
            }
            if (this.hash3 == hash && this.entry3.matches(tag)) {
                return this.entry3;
            }
            return null;
        }

        BucketGroup replaceOrInsertAllInChain(BucketGroup thatHeadGroup) {
            BucketGroup thisOrigHeadGroup;
            BucketGroup thisNewestHeadGroup = thisOrigHeadGroup = this;
            BucketGroup thatCurGroup = thatHeadGroup;
            while (thatCurGroup != null) {
                boolean handled3;
                boolean handled0 = thatCurGroup.hash0 == 0 || thisOrigHeadGroup.replaceInChain(thatCurGroup.hash0, thatCurGroup.entry0) != null || thisNewestHeadGroup.insertInChain(thatCurGroup.hash0, thatCurGroup.entry0);
                boolean handled1 = thatCurGroup.hash1 == 0 || thisOrigHeadGroup.replaceInChain(thatCurGroup.hash1, thatCurGroup.entry1) != null || thisNewestHeadGroup.insertInChain(thatCurGroup.hash1, thatCurGroup.entry1);
                boolean handled2 = thatCurGroup.hash2 == 0 || thisOrigHeadGroup.replaceInChain(thatCurGroup.hash2, thatCurGroup.entry2) != null || thisNewestHeadGroup.insertInChain(thatCurGroup.hash2, thatCurGroup.entry2);
                boolean bl = handled3 = thatCurGroup.hash3 == 0 || thisOrigHeadGroup.replaceInChain(thatCurGroup.hash3, thatCurGroup.entry3) != null || thisNewestHeadGroup.insertInChain(thatCurGroup.hash3, thatCurGroup.entry3);
                if (!(handled0 && handled1 && handled2 && handled3)) {
                    BucketGroup thisNewHashGroup = new BucketGroup();
                    if (!handled0) {
                        thisNewHashGroup.hash0 = thatCurGroup.hash0;
                        thisNewHashGroup.entry0 = thatCurGroup.entry0;
                    }
                    if (!handled1) {
                        thisNewHashGroup.hash1 = thatCurGroup.hash1;
                        thisNewHashGroup.entry1 = thatCurGroup.entry1;
                    }
                    if (!handled2) {
                        thisNewHashGroup.hash2 = thatCurGroup.hash2;
                        thisNewHashGroup.entry2 = thatCurGroup.entry2;
                    }
                    if (!handled3) {
                        thisNewHashGroup.hash3 = thatCurGroup.hash3;
                        thisNewHashGroup.entry3 = thatCurGroup.entry3;
                    }
                    thisNewHashGroup.prev = thisNewestHeadGroup;
                    thisNewestHeadGroup = thisNewHashGroup;
                }
                thatCurGroup = thatCurGroup.prev;
            }
            return thisNewestHeadGroup;
        }

        TagMap.Entry replaceInChain(int hash, TagMap.Entry entry) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                TagMap.Entry prevEntry = curGroup._replace(hash, entry);
                if (prevEntry != null) {
                    return prevEntry;
                }
                curGroup = curGroup.prev;
            }
            return null;
        }

        TagMap.Entry _replace(int hash, TagMap.Entry entry) {
            TagMap.Entry prevEntry = null;
            if (this.hash0 == hash && this.entry0.matches(entry.tag)) {
                prevEntry = this.entry0;
                this.entry0 = entry;
            } else if (this.hash1 == hash && this.entry1.matches(entry.tag)) {
                prevEntry = this.entry1;
                this.entry1 = entry;
            } else if (this.hash2 == hash && this.entry2.matches(entry.tag)) {
                prevEntry = this.entry2;
                this.entry2 = entry;
            } else if (this.hash3 == hash && this.entry3.matches(entry.tag)) {
                prevEntry = this.entry3;
                this.entry3 = entry;
            }
            return prevEntry;
        }

        boolean insertInChain(int hash, TagMap.Entry entry) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                if (curGroup._insert(hash, entry)) {
                    return true;
                }
                curGroup = curGroup.prev;
            }
            return false;
        }

        boolean _insert(int hash, TagMap.Entry entry) {
            boolean inserted = false;
            if (this.hash0 == 0) {
                this.hash0 = hash;
                this.entry0 = entry;
                inserted = true;
            } else if (this.hash1 == 0) {
                this.hash1 = hash;
                this.entry1 = entry;
                inserted = true;
            } else if (this.hash2 == 0) {
                this.hash2 = hash;
                this.entry2 = entry;
                inserted = true;
            } else if (this.hash3 == 0) {
                this.hash3 = hash;
                this.entry3 = entry;
                inserted = true;
            }
            return inserted;
        }

        BucketGroup removeGroupInChain(BucketGroup removeGroup) {
            BucketGroup firstGroup = this;
            if (firstGroup == removeGroup) {
                return firstGroup.prev;
            }
            BucketGroup priorGroup = firstGroup;
            BucketGroup curGroup = priorGroup.prev;
            while (curGroup != null) {
                if (curGroup == removeGroup) {
                    priorGroup.prev = curGroup.prev;
                }
                priorGroup = curGroup;
                curGroup = priorGroup.prev;
            }
            return firstGroup;
        }

        TagMap.Entry _remove(int hash, String tag) {
            TagMap.Entry existingEntry = null;
            if (this.hash0 == hash && this.entry0.matches(tag)) {
                existingEntry = this.entry0;
                this.hash0 = 0;
                this.entry0 = null;
            } else if (this.hash1 == hash && this.entry1.matches(tag)) {
                existingEntry = this.entry1;
                this.hash1 = 0;
                this.entry1 = null;
            } else if (this.hash2 == hash && this.entry2.matches(tag)) {
                existingEntry = this.entry2;
                this.hash2 = 0;
                this.entry2 = null;
            } else if (this.hash3 == hash && this.entry3.matches(tag)) {
                existingEntry = this.entry3;
                this.hash3 = 0;
                this.entry3 = null;
            }
            return existingEntry;
        }

        void forEachInChain(Consumer<? super TagMap.Entry> consumer) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                curGroup._forEach(consumer);
                curGroup = curGroup.prev;
            }
        }

        void _forEach(Consumer<? super TagMap.Entry> consumer) {
            if (this.entry0 != null) {
                consumer.accept(this.entry0);
            }
            if (this.entry1 != null) {
                consumer.accept(this.entry1);
            }
            if (this.entry2 != null) {
                consumer.accept(this.entry2);
            }
            if (this.entry3 != null) {
                consumer.accept(this.entry3);
            }
        }

        <T> void forEachInChain(T thisObj, BiConsumer<T, ? super TagMap.Entry> consumer) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                curGroup._forEach(thisObj, consumer);
                curGroup = curGroup.prev;
            }
        }

        <T> void _forEach(T thisObj, BiConsumer<T, ? super TagMap.Entry> consumer) {
            if (this.entry0 != null) {
                consumer.accept(thisObj, this.entry0);
            }
            if (this.entry1 != null) {
                consumer.accept(thisObj, this.entry1);
            }
            if (this.entry2 != null) {
                consumer.accept(thisObj, this.entry2);
            }
            if (this.entry3 != null) {
                consumer.accept(thisObj, this.entry3);
            }
        }

        <T, U> void forEachInChain(T thisObj, U otherObj, TriConsumer<T, U, ? super TagMap.Entry> consumer) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                curGroup._forEach(thisObj, otherObj, consumer);
                curGroup = curGroup.prev;
            }
        }

        <T, U> void _forEach(T thisObj, U otherObj, TriConsumer<T, U, ? super TagMap.Entry> consumer) {
            if (this.entry0 != null) {
                consumer.accept((TagMap.Entry)thisObj, (TagMap.Entry)otherObj, (TagMap.Entry)((TagMap.Entry)this.entry0));
            }
            if (this.entry1 != null) {
                consumer.accept((TagMap.Entry)thisObj, (TagMap.Entry)otherObj, (TagMap.Entry)((TagMap.Entry)this.entry1));
            }
            if (this.entry2 != null) {
                consumer.accept((TagMap.Entry)thisObj, (TagMap.Entry)otherObj, (TagMap.Entry)((TagMap.Entry)this.entry2));
            }
            if (this.entry3 != null) {
                consumer.accept((TagMap.Entry)thisObj, (TagMap.Entry)otherObj, (TagMap.Entry)((TagMap.Entry)this.entry3));
            }
        }

        void fillMapFromChain(Map<? super String, ? super Object> map) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                curGroup._fillMap(map);
                curGroup = curGroup.prev;
            }
        }

        void _fillMap(Map<? super String, ? super Object> map) {
            TagMap.Entry entry3;
            TagMap.Entry entry2;
            TagMap.Entry entry1;
            TagMap.Entry entry0 = this.entry0;
            if (entry0 != null) {
                map.put(entry0.tag, entry0.objectValue());
            }
            if ((entry1 = this.entry1) != null) {
                map.put(entry1.tag, entry1.objectValue());
            }
            if ((entry2 = this.entry2) != null) {
                map.put(entry2.tag, entry2.objectValue());
            }
            if ((entry3 = this.entry3) != null) {
                map.put(entry3.tag, entry3.objectValue());
            }
        }

        void fillStringMapFromChain(Map<? super String, ? super String> map) {
            BucketGroup curGroup = this;
            while (curGroup != null) {
                curGroup._fillStringMap(map);
                curGroup = curGroup.prev;
            }
        }

        void _fillStringMap(Map<? super String, ? super String> map) {
            TagMap.Entry entry3;
            TagMap.Entry entry2;
            TagMap.Entry entry1;
            TagMap.Entry entry0 = this.entry0;
            if (entry0 != null) {
                map.put(entry0.tag, entry0.stringValue());
            }
            if ((entry1 = this.entry1) != null) {
                map.put(entry1.tag, entry1.stringValue());
            }
            if ((entry2 = this.entry2) != null) {
                map.put(entry2.tag, entry2.stringValue());
            }
            if ((entry3 = this.entry3) != null) {
                map.put(entry3.tag, entry3.stringValue());
            }
        }

        BucketGroup cloneChain() {
            BucketGroup thisClone;
            BucketGroup thisPriorClone = thisClone = this._cloneEntries();
            BucketGroup curGroup = this.prev;
            while (curGroup != null) {
                BucketGroup newClone;
                thisPriorClone.prev = newClone = curGroup._cloneEntries();
                thisPriorClone = newClone;
                curGroup = curGroup.prev;
            }
            return thisClone;
        }

        BucketGroup _cloneEntries() {
            return new BucketGroup(this.hash0, this.entry0, this.hash1, this.entry1, this.hash2, this.entry2, this.hash3, this.entry3);
        }

        public String toString() {
            StringBuilder ledger = new StringBuilder(32);
            ledger.append('[');
            for (int i = 0; i < 4; ++i) {
                if (i != 0) {
                    ledger.append(", ");
                }
                ledger.append(this._entryAt(i));
            }
            ledger.append(']');
            return ledger.toString();
        }
    }

    static final class EntryIterator
    extends MapIterator<TagMap.Entry> {
        EntryIterator(OptimizedTagMap map) {
            super(map);
        }

        @Override
        public TagMap.Entry next() {
            return this.nextEntry();
        }
    }

    static abstract class MapIterator<T>
    implements Iterator<T> {
        private final Object[] buckets;
        private TagMap.Entry nextEntry;
        private int bucketIndex = -1;
        private BucketGroup group = null;
        private int groupIndex = 0;

        MapIterator(OptimizedTagMap map) {
            this.buckets = map.buckets;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            while (this.bucketIndex < this.buckets.length) {
                this.nextEntry = this.advance();
                if (this.nextEntry == null) continue;
                return true;
            }
            return false;
        }

        TagMap.Entry nextEntry() {
            if (this.nextEntry != null) {
                TagMap.Entry nextEntry = this.nextEntry;
                this.nextEntry = null;
                return nextEntry;
            }
            if (this.hasNext()) {
                return this.nextEntry;
            }
            throw new NoSuchElementException();
        }

        private final TagMap.Entry advance() {
            block0: while (this.bucketIndex < this.buckets.length) {
                if (this.group != null) {
                    ++this.groupIndex;
                    while (this.groupIndex < 4) {
                        TagMap.Entry tagEntry = this.group._entryAt(this.groupIndex);
                        if (tagEntry != null) {
                            return tagEntry;
                        }
                        ++this.groupIndex;
                    }
                    this.group = this.group.prev;
                    this.groupIndex = -1;
                }
                if (this.group != null) continue;
                ++this.bucketIndex;
                while (this.bucketIndex < this.buckets.length) {
                    Object bucket = this.buckets[this.bucketIndex];
                    if (bucket instanceof TagMap.Entry) {
                        return (TagMap.Entry)bucket;
                    }
                    if (bucket instanceof BucketGroup) {
                        this.group = (BucketGroup)bucket;
                        this.groupIndex = -1;
                        continue block0;
                    }
                    ++this.bucketIndex;
                }
            }
            return null;
        }
    }
}

