/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.common.socket;

import datadog.trace.api.Config;
import ddtrot.dd.common.socket.TunnelingJdkSocket;
import ddtrot.dd.common.socket.TunnelingUnixSocket;
import ddtrot.dd.environment.JavaVirtualMachine;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import jnr.unixsocket.UnixSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnixDomainSocketFactory
extends SocketFactory {
    private static final Logger log = LoggerFactory.getLogger(UnixDomainSocketFactory.class);
    private static final boolean JDK_SUPPORTS_UDS = JavaVirtualMachine.isJavaVersionAtLeast(16);
    private final RatelimitedLogger rlLog = new RatelimitedLogger(log, 5, TimeUnit.MINUTES);
    private final File path;

    public UnixDomainSocketFactory(File path) {
        this.path = path;
    }

    @Override
    public Socket createSocket() throws IOException {
        try {
            if (JDK_SUPPORTS_UDS && Config.get().isJdkSocketEnabled()) {
                try {
                    return new TunnelingJdkSocket(this.path.toPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new TunnelingUnixSocket(this.path, UnixSocketChannel.open());
        }
        catch (Throwable e) {
            if (Config.get().isAgentConfiguredUsingDefault()) {
                if (log.isDebugEnabled()) {
                    this.rlLog.warn("Problem opening {}, using port instead", this.path, e);
                } else {
                    this.rlLog.warn("Problem opening {}, using port instead: " + e, this.path);
                }
                return UnixDomainSocketFactory.getDefault().createSocket();
            }
            throw e;
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket result = this.createSocket();
        result.connect(new InetSocketAddress(host, port));
        return result;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket result = this.createSocket();
        result.connect(new InetSocketAddress(host, port));
        return result;
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createSocket(host, port);
    }
}

