/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import ddtrot.dd.trace.api.datastreams.DataStreamsContext;
import ddtrot.dd.trace.api.datastreams.PathwayContext;
import ddtrot.dd.trace.api.datastreams.StatsPoint;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.datastreams.DataStreamsMonitoring;
import ddtrot.dd.trace.core.datastreams.DefaultPathwayContext;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DataStreamsPropagator
implements Propagator {
    private final DataStreamsMonitoring dataStreamsMonitoring;
    private final TimeSource timeSource;
    private final long hashOfKnownTags;
    private final ThreadLocal<String> serviceNameOverride;

    public DataStreamsPropagator(DataStreamsMonitoring dataStreamsMonitoring, TimeSource timeSource, long hashOfKnownTags, ThreadLocal<String> serviceNameOverride) {
        this.dataStreamsMonitoring = dataStreamsMonitoring;
        this.timeSource = timeSource;
        this.hashOfKnownTags = hashOfKnownTags;
        this.serviceNameOverride = serviceNameOverride;
    }

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
        DataStreamsContext dsmContext;
        PathwayContext pathwayContext;
        AgentSpan span = AgentSpan.fromContext(context);
        if (span == null || (pathwayContext = span.context().getPathwayContext()) == null || (dsmContext = DataStreamsContext.fromContext(context)) == null || !AgentTracer.traceConfig().isDataStreamsEnabled()) {
            return;
        }
        Consumer<StatsPoint> pointConsumer = dsmContext.sendCheckpoint() ? this.dataStreamsMonitoring::add : pathwayContext::saveStats;
        pathwayContext.setCheckpoint(dsmContext, pointConsumer);
        boolean injected = this.injectPathwayContext(pathwayContext, carrier, setter);
        if (injected && pathwayContext.getHash() != 0L) {
            span.setTag("pathway.hash", Long.toUnsignedString(pathwayContext.getHash()));
        }
    }

    private <C> boolean injectPathwayContext(PathwayContext pathwayContext, C carrier, CarrierSetter<C> setter) {
        try {
            String encodedContext = pathwayContext.encode();
            if (encodedContext != null) {
                setter.set(carrier, "dd-pathway-ctx-base64", encodedContext);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        PathwayContext pathwayContext;
        if (AgentTracer.traceConfig().isDataStreamsEnabled() && (pathwayContext = this.extractDsmPathwayContext(carrier, visitor)) != null) {
            TagContext spanContext = this.getSpanContextOrNull(context);
            if (spanContext == null) {
                spanContext = new TagContext();
                AgentSpan span = AgentSpan.fromSpanContext(spanContext);
                context = Context.root().with(span);
            }
            spanContext.withPathwayContext(pathwayContext);
        }
        return context;
    }

    private TagContext getSpanContextOrNull(Context context) {
        AgentSpanContext extractedSpanContext;
        AgentSpan extractedSpan = AgentSpan.fromContext(context);
        if (extractedSpan != null && (extractedSpanContext = extractedSpan.context()) instanceof TagContext) {
            return (TagContext)extractedSpanContext;
        }
        return null;
    }

    private <C> PathwayContext extractDsmPathwayContext(C carrier, CarrierVisitor<C> visitor) {
        return DefaultPathwayContext.extract(carrier, visitor, this.timeSource, this.hashOfKnownTags, this.serviceNameOverride.get());
    }
}

