/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.monitor;

import datadog.trace.api.StatsDClient;
import ddtrot.dd.trace.api.cache.RadixTreeCache;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.org.jctools.counters.CountersFactory;
import ddtrot.org.jctools.counters.FixedSizeStripedLongCounter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import org.slf4j.Logger;

public class TracerHealthMetrics
extends HealthMetrics
implements AutoCloseable {
    private static final Logger log;
    private static final IntFunction<String[]> STATUS_TAGS;
    private static final String[] NO_TAGS;
    private static final String[] STATUS_OK_TAGS;
    private final RadixTreeCache<String[]> statusTagsCache = new RadixTreeCache<String[]>(16, 32, STATUS_TAGS, 200, 400);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile AgentTaskScheduler.Scheduled<TracerHealthMetrics> cancellation;
    private final FixedSizeStripedLongCounter apiRequests = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter apiErrors = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter apiResponsesOK = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userDropEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userKeepEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerDropEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerKeepEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter unsetPriorityEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userDropDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userKeepDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerDropDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerKeepDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter serialFailedDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter unsetPriorityDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userDropDroppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userKeepDroppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerDropDroppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerKeepDroppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter serialFailedDroppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter unsetPriorityDroppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter enqueuedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter enqueuedBytes = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter createdTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter createdSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter finishedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter flushedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter flushedBytes = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter partialTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter partialBytes = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter clientSpansWithoutContext = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter singleSpanSampled = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter singleSpanUnsampled = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter capturedContinuations = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter cancelledContinuations = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter finishedContinuations = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter activatedScopes = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter closedScopes = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter scopeStackOverflow = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter scopeCloseErrors = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userScopeCloseErrors = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter longRunningTracesWrite = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter longRunningTracesDropped = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter longRunningTracesExpired = CountersFactory.createFixedSizeStripedCounter(8);
    private final StatsDClient statsd;
    private final long interval;
    private final TimeUnit units;

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.cancellation = AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(new Flush(), this, this.interval, this.interval, this.units);
        }
    }

    public TracerHealthMetrics(StatsDClient statsd) {
        this(statsd, 30L, TimeUnit.SECONDS);
    }

    public TracerHealthMetrics(StatsDClient statsd, long interval, TimeUnit units) {
        this.statsd = statsd;
        this.interval = interval;
        this.units = units;
    }

    @Override
    public void onStart(int queueCapacity) {
        this.statsd.gauge("queue.max_length", queueCapacity, NO_TAGS);
    }

    @Override
    public void onShutdown(boolean flushSuccess) {
    }

    @Override
    public void onPublish(List<DDSpan> trace, int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                this.userDropEnqueuedTraces.inc();
                break;
            }
            case 2: {
                this.userKeepEnqueuedTraces.inc();
                break;
            }
            case 0: {
                this.samplerDropEnqueuedTraces.inc();
                break;
            }
            case 1: {
                this.samplerKeepEnqueuedTraces.inc();
                break;
            }
            default: {
                this.unsetPriorityEnqueuedTraces.inc();
            }
        }
        this.enqueuedSpans.inc(trace.size());
        this.checkForClientSpansWithoutContext(trace);
    }

    private void checkForClientSpansWithoutContext(List<DDSpan> trace) {
        for (DDSpan span : trace) {
            String spanKind;
            if (span == null || span.getParentId() != 0L || !"client".equals(spanKind = span.getTag("span.kind", "undefined"))) continue;
            this.clientSpansWithoutContext.inc();
        }
    }

    @Override
    public void onFailedPublish(int samplingPriority, int spanCount) {
        switch (samplingPriority) {
            case -1: {
                this.userDropDroppedSpans.inc(spanCount);
                this.userDropDroppedTraces.inc();
                break;
            }
            case 2: {
                this.userKeepDroppedSpans.inc(spanCount);
                this.userKeepDroppedTraces.inc();
                break;
            }
            case 0: {
                this.samplerDropDroppedSpans.inc(spanCount);
                this.samplerDropDroppedTraces.inc();
                break;
            }
            case 1: {
                this.samplerKeepDroppedSpans.inc(spanCount);
                this.samplerKeepDroppedTraces.inc();
                break;
            }
            default: {
                this.unsetPriorityDroppedSpans.inc(spanCount);
                this.unsetPriorityDroppedTraces.inc();
            }
        }
    }

    @Override
    public void onPartialPublish(int numberOfDroppedSpans) {
        this.partialTraces.inc();
        this.samplerDropDroppedSpans.inc(numberOfDroppedSpans);
    }

    @Override
    public void onScheduleFlush(boolean previousIncomplete) {
    }

    @Override
    public void onFlush(boolean early) {
    }

    @Override
    public void onPartialFlush(int sizeInBytes) {
        this.partialBytes.inc(sizeInBytes);
    }

    @Override
    public void onSingleSpanSample() {
        this.singleSpanSampled.inc();
    }

    @Override
    public void onSingleSpanUnsampled() {
        this.singleSpanUnsampled.inc();
    }

    @Override
    public void onSerialize(int serializedSizeInBytes) {
        this.enqueuedBytes.inc(serializedSizeInBytes);
    }

    @Override
    public void onFailedSerialize(List<DDSpan> trace, Throwable optionalCause) {
        if (trace != null) {
            this.serialFailedDroppedTraces.inc();
            this.serialFailedDroppedSpans.inc(trace.size());
        }
    }

    @Override
    public void onCreateSpan() {
        this.createdSpans.inc();
    }

    @Override
    public void onFinishSpan() {
        this.finishedSpans.inc();
    }

    @Override
    public void onCreateTrace() {
        this.createdTraces.inc();
    }

    @Override
    public void onScopeCloseError(boolean manual) {
        this.scopeCloseErrors.inc();
        if (manual) {
            this.userScopeCloseErrors.inc();
        }
    }

    @Override
    public void onCaptureContinuation() {
        this.capturedContinuations.inc();
    }

    @Override
    public void onCancelContinuation() {
        this.cancelledContinuations.inc();
    }

    @Override
    public void onFinishContinuation() {
        this.finishedContinuations.inc();
    }

    @Override
    public void onActivateScope() {
        this.activatedScopes.inc();
    }

    @Override
    public void onCloseScope() {
        this.closedScopes.inc();
    }

    @Override
    public void onScopeStackOverflow() {
        this.scopeStackOverflow.inc();
    }

    @Override
    public void onSend(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    @Override
    public void onFailedSend(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    @Override
    public void onLongRunningUpdate(int dropped, int write, int expired) {
        this.longRunningTracesWrite.inc(write);
        this.longRunningTracesDropped.inc(dropped);
        this.longRunningTracesExpired.inc(expired);
    }

    private void onSendAttempt(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        Integer status;
        this.apiRequests.inc();
        this.flushedTraces.inc(traceCount);
        this.flushedBytes.inc(sizeInBytes);
        if (response.exception() != null) {
            this.apiErrors.inc();
        }
        if ((status = response.status()) != null) {
            if (200 == status) {
                this.apiResponsesOK.inc();
            } else {
                this.statsd.incrementCounter("api.responses.total", this.statusTagsCache.get(status));
            }
        }
    }

    @Override
    public void close() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
    }

    @Override
    public String summary() {
        return "apiRequests=" + this.apiRequests.get() + "\napiErrors=" + this.apiErrors.get() + "\napiResponsesOK=" + this.apiResponsesOK.get() + "\n\nuserDropEnqueuedTraces=" + this.userDropEnqueuedTraces.get() + "\nuserKeepEnqueuedTraces=" + this.userKeepEnqueuedTraces.get() + "\nsamplerDropEnqueuedTraces=" + this.samplerDropEnqueuedTraces.get() + "\nsamplerKeepEnqueuedTraces=" + this.samplerKeepEnqueuedTraces.get() + "\nunsetPriorityEnqueuedTraces=" + this.unsetPriorityEnqueuedTraces.get() + "\n\nuserDropDroppedTraces=" + this.userDropDroppedTraces.get() + "\nuserKeepDroppedTraces=" + this.userKeepDroppedTraces.get() + "\nsamplerDropDroppedTraces=" + this.samplerDropDroppedTraces.get() + "\nsamplerKeepDroppedTraces=" + this.samplerKeepDroppedTraces.get() + "\nserialFailedDroppedTraces=" + this.serialFailedDroppedTraces.get() + "\nunsetPriorityDroppedTraces=" + this.unsetPriorityDroppedTraces.get() + "\n\nuserDropDroppedSpans=" + this.userDropDroppedSpans.get() + "\nuserKeepDroppedSpans=" + this.userKeepDroppedSpans.get() + "\nsamplerDropDroppedSpans=" + this.samplerDropDroppedSpans.get() + "\nsamplerKeepDroppedSpans=" + this.samplerKeepDroppedSpans.get() + "\nserialFailedDroppedSpans=" + this.serialFailedDroppedSpans.get() + "\nunsetPriorityDroppedSpans=" + this.unsetPriorityDroppedSpans.get() + "\n\nenqueuedSpans=" + this.enqueuedSpans.get() + "\nenqueuedBytes=" + this.enqueuedBytes.get() + "\ncreatedTraces=" + this.createdTraces.get() + "\ncreatedSpans=" + this.createdSpans.get() + "\nfinishedSpans=" + this.finishedSpans.get() + "\nflushedTraces=" + this.flushedTraces.get() + "\nflushedBytes=" + this.flushedBytes.get() + "\npartialTraces=" + this.partialTraces.get() + "\npartialBytes=" + this.partialBytes.get() + "\n\nclientSpansWithoutContext=" + this.clientSpansWithoutContext.get() + "\n\nsingleSpanSampled=" + this.singleSpanSampled.get() + "\nsingleSpanUnsampled=" + this.singleSpanUnsampled.get() + "\n\ncapturedContinuations=" + this.capturedContinuations.get() + "\ncancelledContinuations=" + this.cancelledContinuations.get() + "\nfinishedContinuations=" + this.finishedContinuations.get() + "\n\nactivatedScopes=" + this.activatedScopes.get() + "\nclosedScopes=" + this.closedScopes.get() + "\nscopeStackOverflow=" + this.scopeStackOverflow.get() + "\nscopeCloseErrors=" + this.scopeCloseErrors.get() + "\nuserScopeCloseErrors=" + this.userScopeCloseErrors.get() + "\n\nlongRunningTracesWrite=" + this.longRunningTracesWrite.get() + "\nlongRunningTracesDropped=" + this.longRunningTracesDropped.get() + "\nlongRunningTracesExpired=" + this.longRunningTracesExpired.get();
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class Flush
    implements AgentTaskScheduler.Task<TracerHealthMetrics> {
        private static final String[] USER_DROP_TAG = new String[]{"priority:user_drop"};
        private static final String[] USER_KEEP_TAG = new String[]{"priority:user_keep"};
        private static final String[] SAMPLER_DROP_TAG = new String[]{"priority:sampler_drop"};
        private static final String[] SAMPLER_KEEP_TAG = new String[]{"priority:sampler_keep"};
        private static final String[] SERIAL_FAILED_TAG = new String[]{"failure:serial"};
        private static final String[] UNSET_TAG = new String[]{"priority:unset"};
        private static final String[] SINGLE_SPAN_SAMPLER = new String[]{"sampler:single-span"};
        private final long[] previousCounts = new long[43];
        private int countIndex;

        private Flush() {
        }

        @Override
        public void run(TracerHealthMetrics target) {
            this.countIndex = -1;
            try {
                this.reportIfChanged(target.statsd, "api.requests.total", target.apiRequests, NO_TAGS);
                this.reportIfChanged(target.statsd, "api.errors.total", target.apiErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "api.responses.total", target.apiResponsesOK, STATUS_OK_TAGS);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userDropEnqueuedTraces, USER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userKeepEnqueuedTraces, USER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerDropEnqueuedTraces, SAMPLER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerKeepEnqueuedTraces, SAMPLER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.unsetPriorityEnqueuedTraces, UNSET_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userDropDroppedTraces, USER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userKeepDroppedTraces, USER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerDropDroppedTraces, SAMPLER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerKeepDroppedTraces, SAMPLER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.serialFailedDroppedTraces, SERIAL_FAILED_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.traces", target.unsetPriorityDroppedTraces, UNSET_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.userDropDroppedSpans, USER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.userKeepDroppedSpans, USER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.samplerDropDroppedSpans, SAMPLER_DROP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.samplerKeepDroppedSpans, SAMPLER_KEEP_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.serialFailedDroppedSpans, SERIAL_FAILED_TAG);
                this.reportIfChanged(target.statsd, "queue.dropped.spans", target.unsetPriorityDroppedSpans, UNSET_TAG);
                this.reportIfChanged(target.statsd, "queue.enqueued.spans", target.enqueuedSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "queue.enqueued.bytes", target.enqueuedBytes, NO_TAGS);
                this.reportIfChanged(target.statsd, "trace.pending.created", target.createdTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.pending.created", target.createdSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.pending.finished", target.finishedSpans, NO_TAGS);
                this.reportIfChanged(target.statsd, "flush.traces.total", target.flushedTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "flush.bytes.total", target.flushedBytes, NO_TAGS);
                this.reportIfChanged(target.statsd, "queue.partial.traces", target.partialTraces, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.flushed.partial", target.partialBytes, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.client.no-context", target.clientSpansWithoutContext, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.sampling.sampled", target.singleSpanSampled, SINGLE_SPAN_SAMPLER);
                this.reportIfChanged(target.statsd, "span.sampling.unsampled", target.singleSpanUnsampled, SINGLE_SPAN_SAMPLER);
                this.reportIfChanged(target.statsd, "span.continuations.captured", target.capturedContinuations, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.continuations.canceled", target.cancelledContinuations, NO_TAGS);
                this.reportIfChanged(target.statsd, "span.continuations.finished", target.finishedContinuations, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.activate.count", target.activatedScopes, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.close.count", target.closedScopes, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.error.stack-overflow", target.scopeStackOverflow, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.close.error", target.scopeCloseErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "scope.user.close.error", target.userScopeCloseErrors, NO_TAGS);
                this.reportIfChanged(target.statsd, "long-running.write", target.longRunningTracesWrite, NO_TAGS);
                this.reportIfChanged(target.statsd, "long-running.dropped", target.longRunningTracesDropped, NO_TAGS);
                this.reportIfChanged(target.statsd, "long-running.expired", target.longRunningTracesExpired, NO_TAGS);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.warn("previousCounts array needs resizing to at least {}, was {}", (Object)(this.countIndex + 1), (Object)this.previousCounts.length);
            }
        }

        private void reportIfChanged(StatsDClient statsDClient, String aspect, FixedSizeStripedLongCounter counter, String[] tags) {
            long count = counter.get();
            long delta = count - this.previousCounts[++this.countIndex];
            if (delta > 0L) {
                statsDClient.count(aspect, delta, tags);
                this.previousCounts[this.countIndex] = count;
            }
        }
    }
}

