/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import datadog.trace.api.Config;
import datadog.trace.api.Stateful;
import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextManager;
import ddtrot.dd.context.ContextScope;
import ddtrot.dd.trace.api.scopemanager.ExtendedScopeListener;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilerContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.core.scopemanager.ContinuableScope;
import ddtrot.dd.trace.core.scopemanager.ContinuingScope;
import ddtrot.dd.trace.core.scopemanager.ScopeContext;
import ddtrot.dd.trace.core.scopemanager.ScopeContinuation;
import ddtrot.dd.trace.core.scopemanager.ScopeStack;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContinuableScopeManager
implements ContextManager {
    static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    static final RatelimitedLogger ratelimitedLog = new RatelimitedLogger(log, 1, TimeUnit.MINUTES);
    static final long iterationKeepAlive = TimeUnit.SECONDS.toMillis(Config.get().getScopeIterationKeepAlive());
    volatile ConcurrentMap<ScopeStack, ContinuableScope> rootIterationScopes;
    final List<ScopeListener> scopeListeners;
    final List<ExtendedScopeListener> extendedScopeListeners;
    final boolean strictMode;
    private final ScopeStackThreadLocal tlsScopeStack;
    private final int depthLimit;
    final HealthMetrics healthMetrics;
    private final ProfilingContextIntegration profilingContextIntegration;

    public ContinuableScopeManager(int depthLimit, boolean strictMode) {
        this(depthLimit, strictMode, ProfilingContextIntegration.NoOp.INSTANCE, HealthMetrics.NO_OP);
    }

    public ContinuableScopeManager(int depthLimit, boolean strictMode, ProfilingContextIntegration profilingContextIntegration, HealthMetrics healthMetrics) {
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.strictMode = strictMode;
        this.scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
        this.extendedScopeListeners = new CopyOnWriteArrayList<ExtendedScopeListener>();
        this.healthMetrics = healthMetrics;
        this.tlsScopeStack = new ScopeStackThreadLocal(profilingContextIntegration);
        this.profilingContextIntegration = profilingContextIntegration;
        ContextManager.register(this);
    }

    public AgentScope activateSpan(AgentSpan span) {
        return this.activate(span, (byte)0, true, true);
    }

    public AgentScope activateManualSpan(AgentSpan span) {
        return this.activate(span, (byte)1, false, false);
    }

    public AgentScope.Continuation captureActiveSpan() {
        AgentSpan span;
        ContinuableScope activeScope = this.scopeStack().active();
        if (null != activeScope && activeScope.isAsyncPropagating() && (span = activeScope.span()) != null) {
            return this.captureSpan(activeScope.context, activeScope.source(), span);
        }
        return AgentTracer.noopContinuation();
    }

    public AgentScope.Continuation captureSpan(AgentSpan span) {
        ContinuableScope top = this.scopeStack().top;
        AgentSpan context = top != null ? top.context.with(span) : span;
        return this.captureSpan(context, (byte)0, span);
    }

    private AgentScope.Continuation captureSpan(Context context, byte source, AgentSpan span) {
        AgentTraceCollector traceCollector = span.context().getTraceCollector();
        return new ScopeContinuation(this, context, source, traceCollector).register();
    }

    private AgentScope activate(AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && span.equals(top.span())) {
            top.incrementReferences();
            return top;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.noopScope();
        }
        assert (span != null);
        boolean asyncPropagation = overrideAsyncPropagation ? isAsyncPropagating : (top != null ? top.isAsyncPropagating() : true);
        AgentSpan context = top != null ? top.context.with(span) : span;
        ContinuableScope scope = new ContinuableScope(this, context, source, asyncPropagation, this.createScopeState(context));
        scopeStack.push(scope);
        this.healthMetrics.onActivateScope();
        return scope;
    }

    private AgentScope activate(Context context) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.context.equals(context)) {
            top.incrementReferences();
            return top;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.noopScope();
        }
        assert (context != null);
        boolean asyncPropagation = top != null ? top.isAsyncPropagating() : true;
        ContinuableScope scope = new ContinuableScope(this, context, 3, asyncPropagation, this.createScopeState(context));
        scopeStack.push(scope);
        this.healthMetrics.onActivateScope();
        return scope;
    }

    ContinuableScope continueSpan(ScopeContinuation continuation, Context context, byte source) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.context.equals(context)) {
            top.incrementReferences();
            if (continuation != null) {
                continuation.cancelFromContinuedScopeClose();
            }
            return top;
        }
        Stateful scopeState = this.createScopeState(context);
        ContinuableScope scope = continuation != null ? new ContinuingScope(this, context, source, true, continuation, scopeState) : new ContinuableScope(this, context, source, true, scopeState);
        scopeStack.push(scope);
        return scope;
    }

    public boolean isAsyncPropagationEnabled() {
        ContinuableScope activeScope = this.scopeStack().active();
        return activeScope != null && activeScope.isAsyncPropagating();
    }

    public void setAsyncPropagationEnabled(boolean asyncPropagationEnabled) {
        ContinuableScope activeScope = this.scopeStack().active();
        if (activeScope != null) {
            activeScope.setAsyncPropagation(asyncPropagationEnabled);
        }
    }

    public void closePrevious(boolean finishSpan) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.source() == 2) {
            if (iterationKeepAlive > 0L) {
                this.cancelRootIterationScopeCleanup(scopeStack, top);
            }
            top.close();
            scopeStack.cleanup();
            AgentSpan span = top.span();
            if (finishSpan && span != null) {
                span.finishWithEndToEnd();
            }
        }
    }

    public AgentScope activateNext(AgentSpan span) {
        ScopeStack scopeStack = this.scopeStack();
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            this.healthMetrics.onScopeStackOverflow();
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.noopScope();
        }
        assert (span != null);
        ContinuableScope top = scopeStack.top;
        boolean asyncPropagation = top != null ? top.isAsyncPropagating() : true;
        ContinuableScope scope = new ContinuableScope(this, span, 2, asyncPropagation, this.createScopeState(span));
        if (iterationKeepAlive > 0L && currentDepth == 0) {
            this.scheduleRootIterationScopeCleanup(scopeStack, scope);
        }
        scopeStack.push(scope);
        return scope;
    }

    public AgentScope active() {
        return this.scopeStack().active();
    }

    public void checkpointActiveForRollback() {
        ContinuableScope active = this.scopeStack().active();
        if (active != null) {
            active.checkpoint();
        }
    }

    public void rollbackActiveToCheckpoint() {
        ContinuableScope active;
        while ((active = this.scopeStack().active()) != null && active.rollback()) {
            active.close();
        }
    }

    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().active();
        return active == null ? null : active.span();
    }

    public void addScopeListener(ScopeListener listener) {
        if (listener instanceof ExtendedScopeListener) {
            this.addExtendedScopeListener((ExtendedScopeListener)listener);
        } else {
            this.scopeListeners.add(listener);
            log.debug("Added scope listener {}", (Object)listener);
            AgentSpan activeSpan = this.activeSpan();
            if (activeSpan != null) {
                listener.afterScopeActivated();
            }
        }
    }

    private void addExtendedScopeListener(ExtendedScopeListener listener) {
        this.extendedScopeListeners.add(listener);
        log.debug("Added scope listener {}", (Object)listener);
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan != null && activeSpan != AgentTracer.noopSpan()) {
            listener.afterScopeActivated(activeSpan.getTraceId(), activeSpan.getSpanId());
        }
    }

    private Stateful createScopeState(Context context) {
        AgentSpan span = AgentSpan.fromContext(context);
        if (span != null && span.context() instanceof ProfilerContext) {
            return this.profilingContextIntegration.newScopeState((ProfilerContext)((Object)span.context()));
        }
        return Stateful.DEFAULT;
    }

    ScopeStack scopeStack() {
        return (ScopeStack)this.tlsScopeStack.get();
    }

    @Override
    public Context current() {
        ContinuableScope active = this.scopeStack().active();
        return active == null ? Context.root() : active.context;
    }

    @Override
    public ContextScope attach(Context context) {
        return this.activate(context);
    }

    @Override
    public Context swap(Context context) {
        ContinuableScope newScope;
        ScopeStack newStack;
        ScopeStack oldStack = (ScopeStack)this.tlsScopeStack.get();
        ContinuableScope oldScope = oldStack.top;
        if (context instanceof ScopeContext) {
            newStack = ((ScopeContext)context).scopeStack;
            newScope = newStack.top;
        } else if (context != Context.root()) {
            newStack = new ScopeStack(this.profilingContextIntegration);
            newStack.top = newScope = new ContinuableScope(this, context, 3, true, this.createScopeState(context));
        } else {
            newStack = new ScopeStack(this.profilingContextIntegration);
            newScope = null;
        }
        this.tlsScopeStack.set(newStack);
        if (oldScope != newScope && newScope != null) {
            newScope.beforeActivated();
            newScope.afterActivated();
        }
        return new ScopeContext(oldStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes == null) {
            ContinuableScopeManager continuableScopeManager = this;
            synchronized (continuableScopeManager) {
                if (this.rootIterationScopes == null) {
                    this.rootIterationScopes = new ConcurrentHashMap<ScopeStack, ContinuableScope>();
                    RootIterationCleaner.scheduleFor(this.rootIterationScopes);
                }
            }
        }
        this.rootIterationScopes.put(scopeStack, scope);
    }

    private void cancelRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes != null) {
            this.rootIterationScopes.remove(scopeStack, scope);
        }
    }

    private static final class RootIterationCleaner
    implements AgentTaskScheduler.Task<Map<ScopeStack, ContinuableScope>> {
        private static final RootIterationCleaner CLEANER = new RootIterationCleaner();

        private RootIterationCleaner() {
        }

        public static void scheduleFor(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            long period = Math.min(iterationKeepAlive, 10000L);
            AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(CLEANER, rootIterationScopes, iterationKeepAlive, period, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            Iterator<Map.Entry<ScopeStack, ContinuableScope>> itr = rootIterationScopes.entrySet().iterator();
            long cutOff = System.currentTimeMillis() - iterationKeepAlive;
            while (itr.hasNext()) {
                Map.Entry<ScopeStack, ContinuableScope> entry = itr.next();
                ScopeStack scopeStack = entry.getKey();
                ContinuableScope rootScope = entry.getValue();
                if (!rootScope.alive()) {
                    itr.remove();
                    continue;
                }
                AgentSpan span = rootScope.span();
                if (span == null || TimeUnit.NANOSECONDS.toMillis(span.getStartTime()) >= cutOff) continue;
                scopeStack.overdueRootScope = rootScope;
                span.finishWithEndToEnd();
                itr.remove();
            }
        }
    }

    static final class ScopeStackThreadLocal
    extends ThreadLocal<ScopeStack> {
        private final ProfilingContextIntegration profilingContextIntegration;

        ScopeStackThreadLocal(ProfilingContextIntegration profilingContextIntegration) {
            this.profilingContextIntegration = profilingContextIntegration;
        }

        @Override
        protected ScopeStack initialValue() {
            return new ScopeStack(this.profilingContextIntegration);
        }
    }
}

