/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.TagMap;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanAttributes;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanLink;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import ddtrot.dd.trace.util.Strings;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanPointersProcessor
extends TagsPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SpanPointersProcessor.class);
    public static final String DOWN_DIRECTION = "d";
    public static final String DYNAMODB_PTR_KIND = "aws.dynamodb.item";
    public static final String S3_PTR_KIND = "aws.s3.object";
    public static final String LINK_KIND = "span-pointer";

    @Override
    public void processTags(TagMap unsafeTags, DDSpanContext spanContext, List<AgentSpanLink> spanLinks) {
        AgentSpanLink dynamoDbLink;
        AgentSpanLink s3Link = SpanPointersProcessor.handleS3SpanPointer(unsafeTags);
        if (s3Link != null) {
            spanLinks.add(s3Link);
        }
        if ((dynamoDbLink = SpanPointersProcessor.handleDynamoDbSpanPointer(unsafeTags)) != null) {
            spanLinks.add(dynamoDbLink);
        }
    }

    private static AgentSpanLink handleS3SpanPointer(Map<String, Object> unsafeTags) {
        String eTag = SpanPointersProcessor.asString(unsafeTags.remove("s3.eTag"));
        if (eTag == null) {
            return null;
        }
        String bucket = SpanPointersProcessor.asString(unsafeTags.get("aws.bucket.name"));
        String key = SpanPointersProcessor.asString(unsafeTags.get("aws.object.key"));
        if (bucket == null || key == null) {
            return null;
        }
        if (!eTag.isEmpty() && eTag.charAt(0) == '\"' && eTag.charAt(eTag.length() - 1) == '\"') {
            eTag = eTag.substring(1, eTag.length() - 1);
        }
        String[] components = new String[]{bucket, key, eTag};
        try {
            String hash = SpanPointersProcessor.generatePointerHash(components);
            return SpanPointersProcessor.buildSpanPointer(hash, S3_PTR_KIND);
        }
        catch (Exception e) {
            LOG.debug("Failed to add span pointer: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static AgentSpanLink handleDynamoDbSpanPointer(Map<String, Object> unsafeTags) {
        String tableName = SpanPointersProcessor.asString(unsafeTags.get("aws.table.name"));
        if (tableName == null) {
            return null;
        }
        String primaryKey1Name = SpanPointersProcessor.asString(unsafeTags.remove("dynamodb.primary_key_1"));
        String primaryKey1Value = SpanPointersProcessor.asString(unsafeTags.remove("dynamodb.primary_key_1_value"));
        if (primaryKey1Name == null || primaryKey1Value == null) {
            return null;
        }
        String primaryKey2Name = SpanPointersProcessor.asString(unsafeTags.remove("dynamodb.primary_key_2"));
        String primaryKey2Value = SpanPointersProcessor.asString(unsafeTags.remove("dynamodb.primary_key_2_value"));
        if (primaryKey2Name == null) {
            primaryKey2Name = "";
        }
        if (primaryKey2Value == null) {
            primaryKey2Value = "";
        }
        String[] components = new String[]{tableName, primaryKey1Name, primaryKey1Value, primaryKey2Name, primaryKey2Value};
        try {
            String hash = SpanPointersProcessor.generatePointerHash(components);
            return SpanPointersProcessor.buildSpanPointer(hash, DYNAMODB_PTR_KIND);
        }
        catch (Exception e) {
            LOG.debug("Failed to add span pointer: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String asString(Object o) {
        return o == null ? null : o.toString();
    }

    private static String generatePointerHash(String[] components) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        boolean first = true;
        for (String component : components) {
            if (!first) {
                messageDigest.update((byte)124);
            } else {
                first = false;
            }
            messageDigest.update(component.getBytes(StandardCharsets.UTF_8));
        }
        byte[] fullHash = messageDigest.digest();
        byte[] truncatedHash = Arrays.copyOf(fullHash, 16);
        return Strings.toHexString(truncatedHash);
    }

    private static AgentSpanLink buildSpanPointer(String hash, String ptrKind) {
        SpanAttributes attributes = SpanAttributes.builder().put("ptr.kind", ptrKind).put("ptr.dir", DOWN_DIRECTION).put("ptr.hash", hash).put("link.kind", LINK_KIND).build();
        return SpanLink.from(AgentTracer.noopSpanContext(), (byte)0, "", attributes);
    }
}

