/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CgroupReader {
    private static final Path CGROUP_PATH = Paths.get("/proc/self/cgroup", new String[0]);
    private static final Path DEFAULT_CGROUP_MOUNT_PATH = Paths.get("/sys/fs/cgroup", new String[0]);
    private static final Path CGROUP_NS_PATH = Paths.get("/proc/self/ns/cgroup", new String[0]);
    private static final String CONTAINER_SOURCE = "[0-9a-f]{64}";
    private static final String TASK_SOURCE = "[0-9a-f]{32}-\\d+";
    private static final Pattern LINE_RE = Pattern.compile("^\\d+:[^:]*:(.+)$", 9);
    private static final Pattern CONTAINER_RE = Pattern.compile("([0-9a-f]{64}|[0-9a-f]{32}-\\d+)(?:.scope)?$");
    private static final String CGROUPV1_BASE_CONTROLLER = "memory";
    private static final String CGROUPV2_BASE_CONTROLLER = "";
    private static final long HOST_CGROUP_NAMESPACE_INODE = 0xEFFFFFFBL;
    private boolean readOnce = false;
    public String containerID;

    CgroupReader() {
    }

    public String getContainerID() throws IOException {
        if (this.readOnce) {
            return this.containerID;
        }
        String cgroupContent = this.read(CGROUP_PATH);
        if (cgroupContent == null || cgroupContent.isEmpty()) {
            return null;
        }
        this.containerID = CgroupReader.parse(cgroupContent);
        if ((this.containerID == null || this.containerID.equals(CGROUPV2_BASE_CONTROLLER)) && !CgroupReader.isHostCgroupNamespace(CGROUP_NS_PATH)) {
            this.containerID = CgroupReader.getCgroupInode(DEFAULT_CGROUP_MOUNT_PATH, cgroupContent);
        }
        return this.containerID;
    }

    private String read(Path path) throws IOException {
        this.readOnce = true;
        if (!Files.isReadable(path)) {
            return null;
        }
        return new String(Files.readAllBytes(path));
    }

    public static String parse(String cgroupsContent) {
        Matcher lines = LINE_RE.matcher(cgroupsContent);
        while (lines.find()) {
            String path = lines.group(1);
            Matcher matcher = CONTAINER_RE.matcher(path);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isHostCgroupNamespace(Path path) {
        long hostCgroupInode = CgroupReader.inodeForPath(path);
        return hostCgroupInode == 0xEFFFFFFBL;
    }

    private static long inodeForPath(Path path) {
        try {
            long inode = (Long)Files.getAttribute(path, "unix:ino", new LinkOption[0]);
            return inode;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static String getCgroupInode(Path cgroupMountPath, String cgroupContent) throws IOException {
        Map<String, String> cgroupControllersPaths = CgroupReader.parseCgroupNodePath(cgroupContent);
        if (cgroupControllersPaths == null) {
            return null;
        }
        List<String> controllers = Arrays.asList(CGROUPV1_BASE_CONTROLLER, CGROUPV2_BASE_CONTROLLER);
        for (String controller : controllers) {
            String cgroupNodePath = cgroupControllersPaths.get(controller);
            if (cgroupNodePath == null) continue;
            Path path = Paths.get(cgroupMountPath.toString(), controller, cgroupNodePath);
            long inode = CgroupReader.inodeForPath(path);
            if (inode <= 2L) continue;
            return "in-" + inode;
        }
        return null;
    }

    public static Map<String, String> parseCgroupNodePath(String cgroupContent) throws IOException {
        String line;
        HashMap<String, String> res = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new StringReader(cgroupContent));
        while ((line = br.readLine()) != null) {
            String[] tokens = line.split(":");
            if (tokens.length != 3 || !CGROUPV1_BASE_CONTROLLER.equals(tokens[1]) && !CGROUPV2_BASE_CONTROLLER.equals(tokens[1])) continue;
            res.put(tokens[1], tokens[2]);
        }
        br.close();
        return res;
    }
}

