/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.relocate.api.IOLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalInt;
import org.slf4j.Logger;

public abstract class RemoteApi {
    protected final IOLogger ioLogger = new IOLogger(this.getLogger());
    protected long totalTraces = 0L;
    protected long receivedTraces = 0L;
    protected long sentTraces = 0L;
    protected long failedTraces = 0L;
    private final boolean compressionEnabled;

    protected RemoteApi(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    protected void countAndLogSuccessfulSend(int traceCount, int sizeInBytes) {
        this.sentTraces += (long)traceCount;
        this.ioLogger.success(this.createSendLogMessage(traceCount, sizeInBytes, "Success"), new Object[0]);
    }

    protected void countAndLogFailedSend(int traceCount, int sizeInBytes, ddtrot.okhttp3.Response response, IOException outer) {
        this.failedTraces += (long)traceCount;
        String responseBody = RemoteApi.getResponseBody(response);
        String sendErrorString = this.createSendLogMessage(traceCount, sizeInBytes, responseBody.isEmpty() ? "Error" : responseBody);
        this.ioLogger.error(sendErrorString, RemoteApi.toLoggerResponse(response, responseBody), outer);
    }

    protected static IOLogger.Response toLoggerResponse(ddtrot.okhttp3.Response response, String body) {
        if (response == null) {
            return null;
        }
        return new IOLogger.Response(response.code(), response.message(), body);
    }

    protected String createSendLogMessage(int traceCount, int sizeInBytes, String prefix) {
        String sizeString = sizeInBytes > 1024 ? sizeInBytes / 1024 + "KB" : sizeInBytes + "B";
        return prefix + " while sending " + traceCount + " (size=" + sizeString + ") traces. Total: " + this.totalTraces + ", Received: " + this.receivedTraces + ", Sent: " + this.sentTraces + ", Failed: " + this.failedTraces + ".";
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    protected static String getResponseBody(ddtrot.okhttp3.Response response) {
        if (response != null) {
            try {
                return response.body().string().trim();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return "";
    }

    protected abstract Response sendSerializedTraces(Payload var1);

    protected abstract Logger getLogger();

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;
        private final String response;

        public static Response success(int status) {
            return new Response(true, status, null, null);
        }

        public static Response success(int status, String response) {
            return new Response(true, status, null, response);
        }

        public static Response success(int status, Throwable exception) {
            return new Response(true, status, exception, null);
        }

        public static Response failed(int status) {
            return new Response(false, status, null, null);
        }

        public static Response failed(Throwable exception) {
            return new Response(false, null, exception, null);
        }

        private Response(boolean success, Integer status, Throwable exception, String response) {
            this.success = success;
            this.status = status;
            this.exception = exception;
            this.response = response;
        }

        public boolean success() {
            return this.success;
        }

        public OptionalInt status() {
            return this.status == null ? OptionalInt.empty() : OptionalInt.of(this.status);
        }

        public Optional<Throwable> exception() {
            return Optional.ofNullable(this.exception);
        }

        public String response() {
            return this.response;
        }
    }
}

