/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddagent;

import ddtrot.dd.communication.serialization.EncodingCache;
import ddtrot.dd.trace.common.writer.ddagent.Caching;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="stat updates are deliberately racy - sync is only used to prevent simultaneous bulk updates")
public final class GenerationalUtf8Cache
implements EncodingCache {
    static final int MAX_EDEN_CAPACITY = 512;
    static final int MAX_TENURED_CAPACITY = 1024;
    private static final int MAX_EDEN_PROBES = 4;
    private static final int MAX_TENURED_PROBES = 8;
    private static final int MIN_PROMOTION_TRESHOLD = 2;
    private static final int INITIAL_PROMOTION_THRESHOLD = 16;
    private static final double SCORE_DECAY = 0.5;
    private static final double PURGE_THRESHOLD = 0.25;
    private static final double PROMOTION_THRESHOLD_ADJ_FACTOR = 1.5;
    private static final double EDEN_PROPORTION = 0.3333333333333333;
    private static final double TENURED_PROPORTION = 0.6666666666666667;
    static final int MAX_ENTRY_LEN = 256;
    private final CacheEntry[] edenEntries;
    private final int[] edenMarkers;
    private final CacheEntry[] tenuredEntries;
    private long accessTimeMs = System.currentTimeMillis();
    private double promotionThreshold = 16.0;
    int edenHits = 0;
    int tenuredHits = 0;
    int earlyPromotions = 0;
    int promotions = 0;
    int edenEvictions = 0;
    int tenuredEvictions = 0;

    public GenerationalUtf8Cache(int capacity) {
        int edenCapacity = (int)((double)capacity * 0.3333333333333333);
        int edenSize = Caching.cacheSizeFor(Math.min(edenCapacity, 512));
        this.edenEntries = new CacheEntry[edenSize];
        this.edenMarkers = new int[edenSize];
        int tenuredCapacity = (int)((double)capacity * 0.6666666666666667);
        int tenuredSize = Caching.cacheSizeFor(Math.min(tenuredCapacity, 1024));
        this.tenuredEntries = new CacheEntry[tenuredSize];
    }

    public GenerationalUtf8Cache(int edenCapacity, int tenuredCapacity) {
        int edenSize = Caching.cacheSizeFor(Math.min(tenuredCapacity, 512));
        this.edenEntries = new CacheEntry[edenSize];
        this.edenMarkers = new int[edenSize];
        int tenuredSize = Caching.cacheSizeFor(Math.min(tenuredCapacity, 1024));
        this.tenuredEntries = new CacheEntry[tenuredSize];
    }

    public int edenCapacity() {
        return this.edenEntries.length;
    }

    public int tenuredCapacity() {
        return this.tenuredEntries.length;
    }

    public void updateAccessTime(long accessTimeMs) {
        this.accessTimeMs = accessTimeMs;
    }

    public void refreshAcessTime() {
        this.updateAccessTime(System.currentTimeMillis());
    }

    public synchronized void recalibrate() {
        this.recalibrate(System.currentTimeMillis());
    }

    public synchronized void recalibrate(long accessTimeMs) {
        this.accessTimeMs = accessTimeMs;
        GenerationalUtf8Cache.recalibrate(this.edenEntries);
        Caching.reset(this.edenMarkers);
        GenerationalUtf8Cache.recalibrate(this.tenuredEntries);
        int totalPromotions = this.promotions + this.earlyPromotions;
        if (totalPromotions == 0 && this.promotionThreshold >= 2.0) {
            this.promotionThreshold /= 1.5;
        } else if (totalPromotions > this.tenuredEvictions / 2) {
            this.promotionThreshold *= 1.5;
        }
        this.edenHits = 0;
        this.tenuredHits = 0;
        this.earlyPromotions = 0;
        this.promotions = 0;
        this.edenEvictions = 0;
        this.tenuredEvictions = 0;
    }

    static final void recalibrate(CacheEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            boolean purge;
            CacheEntry entry = entries[i];
            if (entry == null || !(purge = entry.decay())) continue;
            entries[i] = null;
        }
    }

    @Override
    public byte[] encode(CharSequence charSeq) {
        if (charSeq instanceof String) {
            String str = (String)charSeq;
            return this.getUtf8(str);
        }
        return null;
    }

    public final byte[] getUtf8(String value) {
        return this.getUtf8(value, this.accessTimeMs);
    }

    public final byte[] getUtf8(String value, long accessTimeMs) {
        if (value.length() > 256) {
            return CacheEntry.utf8(value);
        }
        int adjHash = Caching.adjHash(value);
        long lookupTimeMs = this.accessTimeMs;
        CacheEntry[] tenuredEntries = this.tenuredEntries;
        int matchingTenuredIndex = GenerationalUtf8Cache.lookupEntryIndex(tenuredEntries, 8, adjHash, value);
        if (matchingTenuredIndex != -1) {
            CacheEntry tenuredEntry = tenuredEntries[matchingTenuredIndex];
            tenuredEntry.hit(lookupTimeMs);
            ++this.tenuredHits;
            return tenuredEntry.utf8();
        }
        CacheEntry[] edenEntries = this.edenEntries;
        int matchingEdenIndex = GenerationalUtf8Cache.lookupEntryIndex(edenEntries, 4, adjHash, value);
        if (matchingEdenIndex != -1) {
            CacheEntry edenEntry = edenEntries[matchingEdenIndex];
            double hits = edenEntry.hit(lookupTimeMs);
            if (hits > this.promotionThreshold) {
                ++this.promotions;
                boolean evicted = GenerationalUtf8Cache.lruInsert(this.tenuredEntries, 8, edenEntry);
                if (evicted) {
                    ++this.tenuredEvictions;
                }
                edenEntries[matchingEdenIndex] = null;
            }
            ++this.edenHits;
            return edenEntry.utf8();
        }
        boolean wasMarked = Caching.mark(this.edenMarkers, adjHash);
        if (!wasMarked) {
            return CacheEntry.utf8(value);
        }
        CacheEntry newEntry = new CacheEntry(adjHash, value);
        newEntry.hit(lookupTimeMs);
        newEntry.hit(lookupTimeMs);
        int edenMfuIndex = GenerationalUtf8Cache.findFirstAvailableOrMfuIndex(edenEntries, 4, adjHash);
        CacheEntry edenMfuEntry = edenEntries[edenMfuIndex];
        if (edenMfuEntry == null) {
            edenEntries[edenMfuIndex] = newEntry;
            return newEntry.utf8();
        }
        int tenuredAvailableIndex = GenerationalUtf8Cache.findAvailableIndex(tenuredEntries, 8, edenMfuEntry.adjHash());
        if (tenuredAvailableIndex != -1) {
            tenuredEntries[tenuredAvailableIndex] = edenMfuEntry;
            ++this.earlyPromotions;
            edenEntries[edenMfuIndex] = newEntry;
            return newEntry.utf8();
        }
        boolean evicted = GenerationalUtf8Cache.lfuInsert(edenEntries, 4, newEntry);
        if (evicted) {
            ++this.edenEvictions;
        }
        return newEntry.utf8();
    }

    static final int findAvailableIndex(CacheEntry[] entries, int numProbes, int newAdjHash) {
        int initialBucketIndex = Caching.bucketIndex(entries, newAdjHash);
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < numProbes) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) == null || entry.isPurgeable()) {
                return index;
            }
            ++probe;
            ++index;
        }
        return -1;
    }

    static final int findFirstAvailableOrMfuIndex(CacheEntry[] entries, int numProbes, int newAdjHash) {
        double mfuScore = Double.MIN_VALUE;
        int mfuIndex = -1;
        int initialBucketIndex = Caching.bucketIndex(entries, newAdjHash);
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < numProbes) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) == null) {
                return index;
            }
            double score = entry.score();
            if (score > mfuScore) {
                mfuScore = score;
                mfuIndex = index;
            }
            ++probe;
            ++index;
        }
        return mfuIndex;
    }

    static final boolean lfuInsert(CacheEntry[] entries, int numProbes, CacheEntry newEntry) {
        int initialBucketIndex = Caching.bucketIndex(entries, newEntry.adjHash());
        double lowestScore = Double.MAX_VALUE;
        int lfuIndex = -1;
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < numProbes) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) == null || entry.isPurgeable()) {
                entries[index] = newEntry;
                return false;
            }
            double score = entry.score();
            if (score < lowestScore) {
                lowestScore = score;
                lfuIndex = index;
            }
            ++probe;
            ++index;
        }
        entries[lfuIndex] = newEntry;
        return true;
    }

    static final boolean lruInsert(CacheEntry[] entries, int numProbes, CacheEntry newEntry) {
        int initialBucketIndex = Caching.bucketIndex(entries, newEntry.adjHash());
        long lowestUsedMs = Long.MAX_VALUE;
        int lruIndex = -1;
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < numProbes) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) == null || entry.matches(newEntry)) {
                entries[index] = newEntry;
                return false;
            }
            long lastUsedMs = entry.lastUsedMs();
            if (lastUsedMs < lowestUsedMs) {
                lowestUsedMs = lastUsedMs;
                lruIndex = index;
            }
            ++probe;
            ++index;
        }
        entries[lruIndex] = newEntry;
        return true;
    }

    static final int lookupEntryIndex(CacheEntry[] entries, int numProbes, int adjHash, String value) {
        int initialBucketIndex = Caching.bucketIndex(entries, adjHash);
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < numProbes) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) != null && entry.matches(adjHash, value)) {
                return index;
            }
            ++probe;
            ++index;
        }
        return -1;
    }

    static final class CacheEntry {
        final int adjHash;
        final String value;
        final byte[] valueUtf8;
        boolean promoted = false;
        long lastUsedMs = 0L;
        double score = 0.0;

        public CacheEntry(int adjHash, String value) {
            this.adjHash = adjHash;
            this.value = value;
            this.valueUtf8 = CacheEntry.utf8(value);
        }

        boolean matches(CacheEntry thatEntry) {
            return this == thatEntry || this.matches(thatEntry.adjHash, thatEntry.value);
        }

        boolean matches(int adjHash, String value) {
            return this.adjHash == adjHash && value.equals(this.value);
        }

        int adjHash() {
            return this.adjHash;
        }

        double score() {
            return this.score;
        }

        long lastUsedMs() {
            return this.lastUsedMs;
        }

        byte[] utf8() {
            return this.valueUtf8;
        }

        double hit(long lastUsedMs) {
            this.lastUsedMs = lastUsedMs;
            this.score += 1.0;
            return this.score;
        }

        boolean decay() {
            this.score *= 0.5;
            return this.isPurgeable();
        }

        boolean isPurgeable() {
            return this.score < 0.25;
        }

        static final byte[] utf8(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        public String toString() {
            return this.value + " - score: " + this.score + " used (ms): " + this.lastUsedMs;
        }
    }
}

