/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.http;

import datadog.trace.api.Config;
import ddtrot.dd.common.container.ContainerInfo;
import ddtrot.dd.common.socket.NamedPipeSocketFactory;
import ddtrot.dd.common.socket.SocketUtils;
import ddtrot.dd.common.socket.UnixDomainSocketFactory;
import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.communication.http.RejectingExecutorService;
import ddtrot.dd.environment.SystemProperties;
import ddtrot.dd.trace.util.AgentProxySelector;
import ddtrot.okhttp3.ConnectionPool;
import ddtrot.okhttp3.ConnectionSpec;
import ddtrot.okhttp3.Credentials;
import ddtrot.okhttp3.Dispatcher;
import ddtrot.okhttp3.EventListener;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.MediaType;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.RequestBody;
import ddtrot.okhttp3.Response;
import ddtrot.okio.BufferedSink;
import ddtrot.okio.GzipSink;
import ddtrot.okio.Okio;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    public static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String DATADOG_ENTITY_ID = "Datadog-Entity-ID";
    public static final String DATADOG_CONTAINER_TAGS_HASH = "Datadog-Container-Tags-Hash";
    private static final String DD_API_KEY = "DD-API-KEY";
    private static final String JAVA_VERSION = SystemProperties.getOrDefault("java.version", "unknown");
    private static final String JAVA_VM_NAME = SystemProperties.getOrDefault("java.vm.name", "unknown");
    private static final String JAVA_VM_VENDOR = SystemProperties.getOrDefault("java.vm.vendor", "unknown");

    public static OkHttpClient buildHttpClient(HttpUrl url, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(OkHttpUtils.isPlainHttp(url), null, null, timeoutMillis);
    }

    public static OkHttpClient buildHttpClient(boolean isHttp, String unixDomainSocketPath, String namedPipe, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(unixDomainSocketPath, namedPipe, null, isHttp, null, null, null, null, null, null, timeoutMillis);
    }

    public static OkHttpClient buildHttpClient(Config config, Dispatcher dispatcher, HttpUrl url, Boolean retryOnConnectionFailure, Integer maxRunningRequests, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(SocketUtils.discoverApmSocket(config), config.getAgentNamedPipe(), dispatcher, OkHttpUtils.isPlainHttp(url), retryOnConnectionFailure, maxRunningRequests, proxyHost, proxyPort, proxyUsername, proxyPassword, timeoutMillis);
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath, String namedPipe, Dispatcher dispatcher, boolean isHttp, Boolean retryOnConnectionFailure, Integer maxRunningRequests, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, long timeoutMillis) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        try {
            builder.eventListenerFactory(call -> {
                Request request = call.request();
                CustomListener listener = request.tag(CustomListener.class);
                return listener != null ? listener : EventListener.NONE;
            });
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        builder.connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).proxySelector(AgentProxySelector.INSTANCE).dispatcher(dispatcher != null ? dispatcher : new Dispatcher(RejectingExecutorService.INSTANCE));
        if (unixDomainSocketPath != null) {
            builder.socketFactory(new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
            log.debug("Using UnixDomainSocket as http transport");
        } else if (namedPipe != null) {
            builder.socketFactory(new NamedPipeSocketFactory(namedPipe));
            log.debug("Using NamedPipe as http transport");
        }
        if (isHttp) {
            builder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
        }
        if (retryOnConnectionFailure != null) {
            builder.retryOnConnectionFailure(retryOnConnectionFailure);
        }
        if (maxRunningRequests != null) {
            builder.connectionPool(new ConnectionPool(maxRunningRequests, 1L, TimeUnit.SECONDS));
        }
        if (proxyHost != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort)));
            if (proxyUsername != null) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic(proxyUsername, proxyPassword == null ? "" : proxyPassword);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        OkHttpClient client = builder.build();
        if (maxRunningRequests != null) {
            client.dispatcher().setMaxRequests(maxRunningRequests);
            client.dispatcher().setMaxRequestsPerHost(maxRunningRequests);
        }
        return client;
    }

    public static Request.Builder prepareRequest(HttpUrl url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, JAVA_VM_VENDOR);
        String containerId = ContainerInfo.get().getContainerId();
        String entityId = ContainerInfo.getEntityId();
        if (containerId != null) {
            builder.addHeader(DATADOG_CONTAINER_ID, containerId);
        }
        if (entityId != null) {
            builder.addHeader(DATADOG_ENTITY_ID, entityId);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            builder.addHeader(e.getKey(), e.getValue());
        }
        return builder;
    }

    public static Request.Builder prepareRequest(HttpUrl url, Map<String, String> headers, Config config, boolean agentless) {
        Request.Builder builder = OkHttpUtils.prepareRequest(url, headers);
        String apiKey = config.getApiKey();
        if (agentless && apiKey != null) {
            builder = builder.addHeader(DD_API_KEY, apiKey);
        }
        return builder;
    }

    public static RequestBody msgpackRequestBodyOf(List<ByteBuffer> buffers) {
        return new ByteBufferRequestBody(buffers);
    }

    public static RequestBody gzippedMsgpackRequestBodyOf(List<ByteBuffer> buffers) {
        return new GZipByteBufferRequestBody(buffers);
    }

    public static RequestBody gzippedRequestBodyOf(RequestBody delegate) {
        return new GZipRequestBodyDecorator(delegate);
    }

    public static RequestBody jsonRequestBodyOf(byte[] json) {
        return new JsonRequestBody(json);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response sendWithRetries(OkHttpClient httpClient, HttpRetryPolicy.Factory retryPolicyFactory, Request request) throws IOException {
        retryPolicy = retryPolicyFactory.create();
        var4_4 = null;
        while (true) {
            block19: {
                block20: {
                    block18: {
                        try {
                            response = httpClient.newCall(request).execute();
                            if (response.isSuccessful()) {
                                var6_8 = response;
                                if (retryPolicy == null) return var6_8;
                                if (var4_4 == null) break block18;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception ex) {
                            if (!retryPolicy.shouldRetry(ex)) {
                                throw ex;
                            }
                            break block19;
                        }
                        catch (Throwable var5_7) {
                            var4_4 = var5_7;
                            throw var5_7;
                        }
                        catch (Throwable var8_12) {
                            if (retryPolicy == null) throw var8_12;
                            if (var4_4 == null) {
                                retryPolicy.close();
                                throw var8_12;
                            }
                            try {
                                retryPolicy.close();
                                throw var8_12;
                            }
                            catch (Throwable var9_13) {
                                var4_4.addSuppressed(var9_13);
                                throw var8_12;
                            }
                        }
                        try {
                            retryPolicy.close();
                            return var6_8;
                        }
                        catch (Throwable var7_10) {
                            var4_4.addSuppressed(var7_10);
                            return var6_8;
                        }
                    }
                    retryPolicy.close();
                    return var6_8;
lbl-1000:
                    // 1 sources

                    {
                        if (retryPolicy.shouldRetry(response)) ** GOTO lbl-1000
                        var6_9 = response;
                        if (retryPolicy == null) return var6_9;
                        if (var4_4 == null) break block20;
                    }
                    try {
                        retryPolicy.close();
                        return var6_9;
                    }
                    catch (Throwable var7_11) {
                        var4_4.addSuppressed(var7_11);
                        return var6_9;
                    }
                }
                retryPolicy.close();
                return var6_9;
lbl-1000:
                // 1 sources

                {
                    OkHttpUtils.closeQuietly(response);
                }
            }
            retryPolicy.backoff();
        }
    }

    private static void closeQuietly(Response response) {
        try {
            response.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isPlainHttp(HttpUrl url) {
        return url != null && "http".equalsIgnoreCase(url.scheme());
    }

    private static final class GZipRequestBodyDecorator
    extends RequestBody {
        private final RequestBody delegate;

        private GZipRequestBodyDecorator(RequestBody delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public MediaType contentType() {
            return this.delegate.contentType();
        }

        @Override
        public long contentLength() {
            return -1L;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            BufferedSink gzipSink = Okio.buffer(new GzipSink(sink));
            this.delegate.writeTo(gzipSink);
            gzipSink.close();
        }
    }

    private static final class GZipByteBufferRequestBody
    extends ByteBufferRequestBody {
        private GZipByteBufferRequestBody(List<ByteBuffer> buffers) {
            super(buffers);
        }

        @Override
        public long contentLength() {
            return -1L;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            BufferedSink gzipSink = Okio.buffer(new GzipSink(sink));
            super.writeTo(gzipSink);
            gzipSink.close();
        }
    }

    private static class ByteBufferRequestBody
    extends RequestBody {
        private static final MediaType MSGPACK = MediaType.get("application/msgpack");
        private final List<ByteBuffer> buffers;

        private ByteBufferRequestBody(List<ByteBuffer> buffers) {
            this.buffers = buffers;
        }

        @Override
        public long contentLength() {
            long length = 0L;
            for (ByteBuffer buffer : this.buffers) {
                length += (long)buffer.remaining();
            }
            return length;
        }

        @Override
        public MediaType contentType() {
            return MSGPACK;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            for (ByteBuffer buffer : this.buffers) {
                while (buffer.hasRemaining()) {
                    sink.write(buffer);
                }
            }
        }
    }

    private static class JsonRequestBody
    extends RequestBody {
        private static final MediaType JSON = MediaType.get("application/json");
        private final byte[] json;

        private JsonRequestBody(byte[] json) {
            this.json = json;
        }

        @Override
        public long contentLength() {
            return this.json.length;
        }

        @Override
        public MediaType contentType() {
            return JSON;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(this.json);
        }
    }

    public static abstract class CustomListener
    extends EventListener {
    }
}

