/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.civisibility.writer.ddintake;

import datadog.trace.api.DDTraceId;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.GrowableBuffer;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.json.JsonMapper;
import ddtrot.dd.trace.api.civisibility.CiVisibilityWellKnownTags;
import ddtrot.dd.trace.api.civisibility.InstrumentationBridge;
import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityDistributionMetric;
import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityMetricCollector;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Endpoint;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CiTestCycleMapperV1
implements RemoteMapper {
    private static final byte[] VERSION = "version".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA = "metadata".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA_ASTERISK = "*".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENTS = "events".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ENV = "env".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CONTENT = "content".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEST_SESSION_ID = "test_session_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEST_MODULE_ID = "test_module_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEST_SUITE_ID = "test_suite_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TEST_IS_USER_PROVIDED_SERVICE = "_dd.test.is_user_provided_service".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ITR_CORRELATION_ID = "itr_correlation_id".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RUNTIME_NAME = "runtime.name".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RUNTIME_VENDOR = "runtime.vendor".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RUNTIME_VERSION = "runtime.version".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OS_ARCHITECTURE = "os.architecture".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OS_PLATFORM = "os.platform".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OS_VERSION = "os.version".getBytes(StandardCharsets.UTF_8);
    private static final UTF8BytesString SPAN_TYPE = UTF8BytesString.create("span");
    private static final Collection<String> DEFAULT_TOP_LEVEL_TAGS = Arrays.asList("test_session_id", "test_module_id", "test_suite_id", "itr_correlation_id");
    private final CiVisibilityWellKnownTags wellKnownTags;
    private final int size;
    private final GrowableBuffer headerBuffer;
    private final MsgPackWriter headerWriter;
    private final boolean compressionEnabled;
    private int eventCount;
    private int serializationTimeMillis;
    private final MetaWriter metaWriter = new MetaWriter();

    public CiTestCycleMapperV1(CiVisibilityWellKnownTags wellKnownTags, boolean compressionEnabled) {
        this.wellKnownTags = wellKnownTags;
        this.size = 0x500000;
        this.compressionEnabled = compressionEnabled;
        this.headerBuffer = new GrowableBuffer(16);
        this.headerWriter = new MsgPackWriter(this.headerBuffer);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        long serializationStartTimestamp = System.currentTimeMillis();
        for (CoreSpan<?> span : trace) {
            int version;
            Long parentId;
            Long spanId;
            Long traceId;
            UTF8BytesString type;
            CharSequence spanType;
            DDTraceId testSessionId = (DDTraceId)span.getTag("test_session_id");
            span.removeTag("test_session_id");
            Number testModuleId = (Number)span.getTag("test_module_id");
            span.removeTag("test_module_id");
            Number testSuiteId = (Number)span.getTag("test_suite_id");
            span.removeTag("test_suite_id");
            String itrCorrelationId = (String)span.getTag("itr_correlation_id");
            span.removeTag("itr_correlation_id");
            int topLevelTagsCount = 0;
            if (testSessionId != null) {
                ++topLevelTagsCount;
            }
            if (testModuleId != null) {
                ++topLevelTagsCount;
            }
            if (testSuiteId != null) {
                ++topLevelTagsCount;
            }
            if (itrCorrelationId != null) {
                ++topLevelTagsCount;
            }
            if (CiTestCycleMapperV1.equals(InternalSpanTypes.TEST, spanType = span.getType())) {
                type = InternalSpanTypes.TEST;
                traceId = span.getTraceId().toLong();
                spanId = span.getSpanId();
                parentId = span.getParentId();
                version = topLevelTagsCount > 0 ? 2 : 1;
            } else if (CiTestCycleMapperV1.equals(InternalSpanTypes.TEST_SUITE_END, spanType)) {
                type = InternalSpanTypes.TEST_SUITE_END;
                traceId = null;
                spanId = null;
                parentId = null;
                version = 1;
            } else if (CiTestCycleMapperV1.equals(InternalSpanTypes.TEST_MODULE_END, spanType)) {
                type = InternalSpanTypes.TEST_MODULE_END;
                traceId = null;
                spanId = null;
                parentId = null;
                version = 1;
            } else if (CiTestCycleMapperV1.equals(InternalSpanTypes.TEST_SESSION_END, spanType)) {
                type = InternalSpanTypes.TEST_SESSION_END;
                traceId = null;
                spanId = null;
                parentId = null;
                version = 1;
            } else {
                type = SPAN_TYPE;
                traceId = span.getTraceId().toLong();
                spanId = span.getSpanId();
                parentId = span.getParentId();
                version = 1;
            }
            int contentChildrenCount = 8 + (traceId != null ? 1 : 0) + (spanId != null ? 1 : 0) + (parentId != null ? 1 : 0) + topLevelTagsCount;
            writable.startMap(3);
            writable.writeUTF8(TYPE);
            writable.writeUTF8(type);
            writable.writeUTF8(VERSION);
            writable.writeInt(version);
            writable.writeUTF8(CONTENT);
            writable.startMap(contentChildrenCount);
            if (traceId != null) {
                writable.writeUTF8(TRACE_ID);
                writable.writeUnsignedLong(traceId);
            }
            if (spanId != null) {
                writable.writeUTF8(SPAN_ID);
                writable.writeUnsignedLong(spanId);
            }
            if (parentId != null) {
                writable.writeUTF8(PARENT_ID);
                writable.writeUnsignedLong(parentId);
            }
            if (testSessionId != null) {
                writable.writeUTF8(TEST_SESSION_ID);
                writable.writeObject(testSessionId.toLong(), null);
            }
            if (testModuleId != null) {
                writable.writeUTF8(TEST_MODULE_ID);
                writable.writeObject(testModuleId, null);
            }
            if (testSuiteId != null) {
                writable.writeUTF8(TEST_SUITE_ID);
                writable.writeObject(testSuiteId, null);
            }
            if (itrCorrelationId != null) {
                writable.writeUTF8(ITR_CORRELATION_ID);
                writable.writeObjectString(itrCorrelationId, null);
            }
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
        this.eventCount += trace.size();
        this.serializationTimeMillis += (int)(System.currentTimeMillis() - serializationStartTimestamp);
    }

    private static boolean equals(CharSequence a, CharSequence b) {
        return a == null && b == null || a != null && b != null && Objects.equals(a.toString(), b.toString());
    }

    private void writeHeader() {
        this.headerWriter.startMap(3);
        this.headerWriter.writeUTF8(VERSION);
        this.headerWriter.writeInt(1);
        this.headerWriter.writeUTF8(METADATA);
        this.headerWriter.startMap(1);
        this.headerWriter.writeUTF8(METADATA_ASTERISK);
        this.headerWriter.startMap(10);
        this.headerWriter.writeUTF8(ENV);
        this.headerWriter.writeUTF8(this.wellKnownTags.getEnv());
        this.headerWriter.writeUTF8(RUNTIME_ID);
        this.headerWriter.writeUTF8(this.wellKnownTags.getRuntimeId());
        this.headerWriter.writeUTF8(LANGUAGE);
        this.headerWriter.writeUTF8(this.wellKnownTags.getLanguage());
        this.headerWriter.writeUTF8(RUNTIME_NAME);
        this.headerWriter.writeUTF8(this.wellKnownTags.getRuntimeName());
        this.headerWriter.writeUTF8(RUNTIME_VENDOR);
        this.headerWriter.writeUTF8(this.wellKnownTags.getRuntimeVendor());
        this.headerWriter.writeUTF8(RUNTIME_VERSION);
        this.headerWriter.writeUTF8(this.wellKnownTags.getRuntimeVersion());
        this.headerWriter.writeUTF8(OS_ARCHITECTURE);
        this.headerWriter.writeUTF8(this.wellKnownTags.getOsArch());
        this.headerWriter.writeUTF8(OS_PLATFORM);
        this.headerWriter.writeUTF8(this.wellKnownTags.getOsPlatform());
        this.headerWriter.writeUTF8(OS_VERSION);
        this.headerWriter.writeUTF8(this.wellKnownTags.getOsVersion());
        this.headerWriter.writeUTF8(TEST_IS_USER_PROVIDED_SERVICE);
        this.headerWriter.writeUTF8(this.wellKnownTags.getIsUserProvidedService());
        this.headerWriter.writeUTF8(EVENTS);
        this.headerWriter.startArray(this.eventCount);
    }

    @Override
    public Payload newPayload() {
        this.writeHeader();
        CiVisibilityMetricCollector metricCollector = InstrumentationBridge.getMetricCollector();
        metricCollector.add(CiVisibilityDistributionMetric.ENDPOINT_PAYLOAD_EVENTS_COUNT, this.eventCount, Endpoint.TEST_CYCLE);
        metricCollector.add(CiVisibilityDistributionMetric.ENDPOINT_PAYLOAD_EVENTS_SERIALIZATION_MS, this.serializationTimeMillis, Endpoint.TEST_CYCLE);
        return new PayloadV1(this.compressionEnabled).withHeader(this.headerBuffer.slice());
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
        this.eventCount = 0;
        this.serializationTimeMillis = 0;
    }

    @Override
    public String endpoint() {
        return "citestcycle/v1";
    }

    private static class PayloadV1
    extends Payload {
        private final boolean compressionEnabled;
        ByteBuffer header = null;

        private PayloadV1(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
        }

        PayloadV1 withHeader(ByteBuffer header) {
            this.header = header;
            return this;
        }

        @Override
        public int sizeInBytes() {
            if (this.traceCount() == 0) {
                return this.msgpackMapHeaderSize(0);
            }
            int size = this.body.remaining();
            if (this.header != null) {
                size += this.header.remaining();
            }
            return size;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            if (this.traceCount() == 0) {
                ByteBuffer emptyDict = this.msgpackMapHeader(0);
                while (emptyDict.hasRemaining()) {
                    channel.write(emptyDict);
                }
            } else {
                if (this.header != null) {
                    while (this.header.hasRemaining()) {
                        channel.write(this.header);
                    }
                }
                while (this.body.hasRemaining()) {
                    channel.write(this.body);
                }
            }
        }

        @Override
        public RequestBody toRequest() {
            List<ByteBuffer> buffers = this.traceCount() == 0 ? Collections.singletonList(this.msgpackMapHeader(0)) : (this.header != null ? Arrays.asList(this.header, this.body) : Collections.singletonList(this.body));
            return this.compressionEnabled ? OkHttpUtils.gzippedMsgpackRequestBodyOf(buffers) : OkHttpUtils.msgpackRequestBodyOf(buffers);
        }
    }

    private static final class MetaWriter
    implements MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1);
            int metricsSize = 0;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.writeUTF8(RemoteMapper.METRICS);
            this.writable.startMap(metricsSize);
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(RemoteMapper.META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(RemoteMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                if (!(value instanceof Iterable)) {
                    this.writable.writeObjectString(value, null);
                    continue;
                }
                String serializedValue = JsonMapper.toJson((Collection)value);
                this.writable.writeString(serializedValue, null);
            }
        }
    }
}

