/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.payloadtags.json;

import ddtrot.dd.trace.payloadtags.json.PathCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class JsonPath {
    private final Segment[] segments;

    private JsonPath(Collection<Segment> segments) {
        this.segments = segments.toArray(new Segment[0]);
    }

    public boolean matches(PathCursor pathCursor) {
        int i = this.segments.length - 1;
        int j = pathCursor.length();
        while (i >= 0 && j >= 0 && this.segments[i].matches(this.jsonPathSegment(pathCursor, j))) {
            int offset2;
            --j;
            if (this.segments[--i + 1] != Segment.Singleton.DESCENDANT) continue;
            int prevSearchSegmentPos = this.findPrevDescendantSegment(this, i);
            int blockSize = i - prevSearchSegmentPos;
            for (offset2 = j - blockSize + 2; offset2 > 0 && !this.matchPathBlock(this, prevSearchSegmentPos + 1, pathCursor, offset2, blockSize); --offset2) {
            }
            i = prevSearchSegmentPos;
            j = offset2 - 1;
        }
        return j < 0 && i < 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Segment segment : this.segments) {
            sb.append(segment);
        }
        return sb.toString();
    }

    private boolean matchPathBlock(JsonPath pattern, int offset1, PathCursor pathCursor, int offset2, int blockSize) {
        for (int i = 0; i < blockSize; ++i) {
            if (pattern.segments[offset1 + i].matches(this.jsonPathSegment(pathCursor, offset2 + i))) continue;
            return false;
        }
        return true;
    }

    private Object jsonPathSegment(PathCursor pathCursor, int index) {
        if (index == 0) {
            return null;
        }
        return pathCursor.get(index - 1);
    }

    private int findPrevDescendantSegment(JsonPath pattern, int from) {
        int i;
        for (i = from - 1; i > 0; --i) {
            if (pattern.segments[i] != Segment.Singleton.DESCENDANT) continue;
            return i;
        }
        return i;
    }

    private static abstract class Segment {
        private Segment() {
        }

        protected boolean matches(Object value) {
            return this == Singleton.WILDCARD || this == Singleton.DESCENDANT || this == Singleton.ROOT && value == null;
        }

        private static final class Index
        extends Segment {
            private final int index;

            public Index(int index) {
                this.index = index;
            }

            @Override
            protected boolean matches(Object value) {
                return value instanceof Integer && (Integer)value == this.index;
            }

            public String toString() {
                return "[" + this.index + "]";
            }
        }

        private static final class Name
        extends Segment {
            private final String name;

            public Name(String name) {
                this.name = name;
            }

            @Override
            protected boolean matches(Object value) {
                return value instanceof String && value.equals(this.name);
            }

            public String toString() {
                return "['" + this.name + "']";
            }
        }

        private static final class Singleton
        extends Segment {
            private static final Segment ROOT = new Singleton("$");
            private static final Segment WILDCARD = new Singleton("[*]");
            private static final Segment DESCENDANT = new Singleton("..");
            private final String repr;

            public Singleton(String repr) {
                this.repr = repr;
            }

            public String toString() {
                return this.repr;
            }
        }
    }

    public static class Builder {
        private final List<Segment> segments = new ArrayList<Segment>();

        public Builder() {
            this.segments.add(Segment.Singleton.ROOT);
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder name(String name) {
            this.segments.add(new Segment.Name(name));
            return this;
        }

        public Builder index(int index) {
            this.segments.add(new Segment.Index(index));
            return this;
        }

        public Builder anyDesc() {
            this.segments.add(Segment.Singleton.DESCENDANT);
            return this;
        }

        public Builder anyChild() {
            this.segments.add(Segment.Singleton.WILDCARD);
            return this;
        }

        public JsonPath build() {
            return new JsonPath(this.segments);
        }
    }
}

