/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.TagMapFactory;
import ddtrot.dd.trace.api.function.TriConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface TagMap
extends Map<String, Object>,
Iterable<Entry> {
    public static final TagMap EMPTY = TagMapFactory.INSTANCE.empty();

    public static TagMap fromMap(Map<String, ?> map) {
        TagMap tagMap = TagMap.create(map.size());
        tagMap.putAll((Map<? extends String, ? extends Object>)map);
        return tagMap;
    }

    public static TagMap fromMapImmutable(Map<String, ?> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        return TagMap.fromMap(map).freeze();
    }

    public static TagMap create() {
        return TagMapFactory.INSTANCE.create();
    }

    public static TagMap create(int size) {
        return TagMapFactory.INSTANCE.create(size);
    }

    public static Ledger ledger() {
        return new Ledger();
    }

    public static Ledger ledger(int size) {
        return new Ledger(size);
    }

    public boolean isOptimized();

    @Override
    @Deprecated
    public Set<String> keySet();

    @Override
    @Deprecated
    public Collection<Object> values();

    @Override
    public Set<Map.Entry<String, Object>> entrySet();

    @Override
    @Deprecated
    public Object get(Object var1);

    public Object getObject(String var1);

    public String getString(String var1);

    public boolean getBoolean(String var1);

    public boolean getBooleanOrDefault(String var1, boolean var2);

    public int getInt(String var1);

    public int getIntOrDefault(String var1, int var2);

    public long getLong(String var1);

    public long getLongOrDefault(String var1, long var2);

    public float getFloat(String var1);

    public float getFloatOrDefault(String var1, float var2);

    public double getDouble(String var1);

    public double getDoubleOrDefault(String var1, double var2);

    public Entry getEntry(String var1);

    @Override
    @Deprecated
    public Object put(String var1, Object var2);

    public void set(String var1, Object var2);

    public void set(String var1, CharSequence var2);

    public void set(String var1, boolean var2);

    public void set(String var1, int var2);

    public void set(String var1, long var2);

    public void set(String var1, float var2);

    public void set(String var1, double var2);

    public void set(Entry var1);

    public Entry getAndSet(String var1, Object var2);

    public Entry getAndSet(String var1, CharSequence var2);

    public Entry getAndSet(String var1, boolean var2);

    public Entry getAndSet(String var1, int var2);

    public Entry getAndSet(String var1, long var2);

    public Entry getAndSet(String var1, float var2);

    public Entry getAndSet(String var1, double var2);

    public Entry getAndSet(Entry var1);

    @Override
    public void putAll(Map<? extends String, ? extends Object> var1);

    public void putAll(TagMap var1);

    public void fillMap(Map<? super String, Object> var1);

    public void fillStringMap(Map<? super String, ? super String> var1);

    @Override
    @Deprecated
    public Object remove(Object var1);

    public boolean remove(String var1);

    public Entry getAndRemove(String var1);

    public TagMap copy();

    public TagMap immutableCopy();

    @Override
    public Iterator<Entry> iterator();

    public Stream<Entry> stream();

    @Override
    public void forEach(Consumer<? super Entry> var1);

    public <T> void forEach(T var1, BiConsumer<T, ? super Entry> var2);

    public <T, U> void forEach(T var1, U var2, TriConsumer<T, U, ? super Entry> var3);

    @Override
    public void clear();

    public TagMap freeze();

    public boolean isFrozen();

    public void checkWriteAccess();

    public static final class Ledger
    implements Iterable<EntryChange> {
        EntryChange[] entryChanges;
        int nextPos = 0;
        boolean containsRemovals = false;

        private Ledger() {
            this(8);
        }

        private Ledger(int size) {
            this.entryChanges = new EntryChange[size];
        }

        public boolean isDefinitelyEmpty() {
            return this.nextPos == 0;
        }

        public int estimateSize() {
            return this.nextPos;
        }

        public boolean containsRemovals() {
            return this.containsRemovals;
        }

        public Ledger set(String tag, Object value) {
            return this.recordEntry(Entry.newAnyEntry(tag, value));
        }

        public Ledger set(String tag, CharSequence value) {
            return this.recordEntry(Entry.newObjectEntry(tag, value));
        }

        public Ledger set(String tag, boolean value) {
            return this.recordEntry(Entry.newBooleanEntry(tag, value));
        }

        public Ledger set(String tag, int value) {
            return this.recordEntry(Entry.newIntEntry(tag, value));
        }

        public Ledger set(String tag, long value) {
            return this.recordEntry(Entry.newLongEntry(tag, value));
        }

        public Ledger set(String tag, float value) {
            return this.recordEntry(Entry.newFloatEntry(tag, value));
        }

        public Ledger set(String tag, double value) {
            return this.recordEntry(Entry.newDoubleEntry(tag, value));
        }

        public Ledger set(Entry entry) {
            return this.recordEntry(entry);
        }

        public Ledger remove(String tag) {
            return this.recordRemoval(EntryChange.newRemoval(tag));
        }

        private Ledger recordEntry(Entry entry) {
            this.recordChange(entry);
            return this;
        }

        private Ledger recordRemoval(EntryRemoval entry) {
            this.recordChange(entry);
            this.containsRemovals = true;
            return this;
        }

        private void recordChange(EntryChange entryChange) {
            if (this.nextPos >= this.entryChanges.length) {
                this.entryChanges = Arrays.copyOf(this.entryChanges, this.entryChanges.length << 1);
            }
            this.entryChanges[this.nextPos++] = entryChange;
        }

        public Ledger smartRemove(String tag) {
            if (this.contains(tag)) {
                this.remove(tag);
            }
            return this;
        }

        private boolean contains(String tag) {
            EntryChange[] thisChanges = this.entryChanges;
            int lenClamp = Math.min(this.nextPos, thisChanges.length);
            for (int i = 0; i < lenClamp; ++i) {
                if (!thisChanges[i].matches(tag)) continue;
                return true;
            }
            return false;
        }

        Entry findLastEntry(String tag) {
            int clampLen;
            EntryChange[] thisChanges = this.entryChanges;
            for (int i = clampLen = Math.min(this.nextPos, thisChanges.length) - 1; i >= 0; --i) {
                EntryChange thisChange = thisChanges[i];
                if (thisChange.isRemoval() || !thisChange.matches(tag)) continue;
                return (Entry)thisChange;
            }
            return null;
        }

        public void reset() {
            Arrays.fill(this.entryChanges, null);
            this.nextPos = 0;
        }

        @Override
        public Iterator<EntryChange> iterator() {
            return new IteratorImpl(this.entryChanges, this.nextPos);
        }

        public TagMap build() {
            TagMap map = TagMap.create(this.estimateSize());
            this.fill(map);
            return map;
        }

        TagMap build(TagMapFactory<?> mapFactory) {
            Object map = mapFactory.create(this.estimateSize());
            this.fill((TagMap)map);
            return map;
        }

        void fill(TagMap map) {
            EntryChange[] entryChanges = this.entryChanges;
            int size = this.nextPos;
            for (int i = 0; i < size && i < entryChanges.length; ++i) {
                EntryChange change = entryChanges[i];
                if (change.isRemoval()) {
                    map.remove(change.tag());
                    continue;
                }
                map.set((Entry)change);
            }
        }

        TagMap buildImmutable(TagMapFactory<?> mapFactory) {
            if (this.nextPos == 0) {
                return mapFactory.empty();
            }
            return this.build(mapFactory).freeze();
        }

        public TagMap buildImmutable() {
            if (this.nextPos == 0) {
                return EMPTY;
            }
            return this.build().freeze();
        }

        static final class IteratorImpl
        implements Iterator<EntryChange> {
            private final EntryChange[] entryChanges;
            private final int size;
            private int pos;

            IteratorImpl(EntryChange[] entryChanges, int size) {
                this.entryChanges = entryChanges;
                this.size = size;
                this.pos = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos + 1 < this.size;
            }

            @Override
            public EntryChange next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no next");
                }
                return this.entryChanges[++this.pos];
            }
        }
    }

    public static final class Entry
    extends EntryChange
    implements Map.Entry<String, Object> {
        public static final byte ANY = 0;
        public static final byte OBJECT = 1;
        public static final byte BOOLEAN = 2;
        public static final byte CHAR = 3;
        public static final byte BYTE = 4;
        public static final byte SHORT = 5;
        public static final byte INT = 6;
        public static final byte LONG = 7;
        public static final byte FLOAT = 8;
        public static final byte DOUBLE = 9;
        int lazyTagHash = 0;
        volatile byte rawType;
        volatile long rawPrim;
        volatile Object rawObj;
        volatile String strCache = null;

        static Entry newAnyEntry(Map.Entry<? extends String, ? extends Object> entry) {
            return Entry.newAnyEntry(entry.getKey(), entry.getValue());
        }

        static Entry newAnyEntry(String tag, Object value) {
            return new Entry(tag, 0, 0L, value);
        }

        static Entry newObjectEntry(String tag, Object value) {
            return new Entry(tag, 1, 0L, value);
        }

        static Entry newBooleanEntry(String tag, boolean value) {
            return new Entry(tag, 2, Entry.boolean2Prim(value), value);
        }

        static Entry newBooleanEntry(String tag, Boolean box) {
            return new Entry(tag, 2, Entry.boolean2Prim(box), box);
        }

        static Entry newIntEntry(String tag, int value) {
            return new Entry(tag, 6, Entry.int2Prim(value), null);
        }

        static Entry newIntEntry(String tag, Integer box) {
            return new Entry(tag, 6, Entry.int2Prim(box), box);
        }

        static Entry newLongEntry(String tag, long value) {
            return new Entry(tag, 7, Entry.long2Prim(value), null);
        }

        static Entry newLongEntry(String tag, Long box) {
            return new Entry(tag, 7, Entry.long2Prim(box), box);
        }

        static Entry newFloatEntry(String tag, float value) {
            return new Entry(tag, 8, Entry.float2Prim(value), null);
        }

        static Entry newFloatEntry(String tag, Float box) {
            return new Entry(tag, 8, Entry.float2Prim(box.floatValue()), box);
        }

        static Entry newDoubleEntry(String tag, double value) {
            return new Entry(tag, 9, Entry.double2Prim(value), null);
        }

        static Entry newDoubleEntry(String tag, Double box) {
            return new Entry(tag, 9, Entry.double2Prim(box), box);
        }

        private Entry(String tag, byte type, long prim, Object obj) {
            super(tag);
            this.rawType = type;
            this.rawPrim = prim;
            this.rawObj = obj;
        }

        int hash() {
            int hash = this.lazyTagHash;
            if (hash != 0) {
                return hash;
            }
            this.lazyTagHash = hash = Entry._hash(this.tag);
            return hash;
        }

        public byte type() {
            return this.resolveAny();
        }

        public boolean is(byte type) {
            byte curType = this.rawType;
            if (curType == type) {
                return true;
            }
            if (curType != 0) {
                return false;
            }
            return this.resolveAny() == type;
        }

        public boolean isNumericPrimitive() {
            byte curType = this.rawType;
            if (Entry._isNumericPrimitive(curType)) {
                return true;
            }
            if (curType != 0) {
                return false;
            }
            return Entry._isNumericPrimitive(this.resolveAny());
        }

        public boolean isNumber() {
            byte curType = this.rawType;
            return Entry._isNumericPrimitive(curType) || this.rawObj instanceof Number;
        }

        static boolean _isNumericPrimitive(byte type) {
            return type >= 4;
        }

        private byte resolveAny() {
            int resolvedType;
            long prim;
            byte curType = this.rawType;
            if (curType != 0) {
                return curType;
            }
            Object value = this.rawObj;
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                prim = Entry.boolean2Prim(boolValue);
                resolvedType = 2;
            } else if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                prim = Entry.int2Prim(intValue);
                resolvedType = 6;
            } else if (value instanceof Long) {
                Long longValue = (Long)value;
                prim = Entry.long2Prim(longValue);
                resolvedType = 7;
            } else if (value instanceof Float) {
                Float floatValue = (Float)value;
                prim = Entry.float2Prim(floatValue.floatValue());
                resolvedType = 8;
            } else if (value instanceof Double) {
                Double doubleValue = (Double)value;
                prim = Entry.double2Prim(doubleValue);
                resolvedType = 9;
            } else {
                prim = 0L;
                resolvedType = 1;
            }
            this._setPrim((byte)resolvedType, prim);
            return (byte)resolvedType;
        }

        private void _setPrim(byte type, long prim) {
            this.rawPrim = prim;
            this.rawType = type;
        }

        public boolean isObject() {
            return this.is((byte)1);
        }

        @Override
        public boolean isRemoval() {
            return false;
        }

        public Object objectValue() {
            if (this.rawObj != null) {
                return this.rawObj;
            }
            switch (this.rawType) {
                case 2: {
                    this.rawObj = Entry.prim2Boolean(this.rawPrim);
                    break;
                }
                case 6: {
                    this.rawObj = Entry.prim2Int(this.rawPrim);
                    break;
                }
                case 7: {
                    this.rawObj = Entry.prim2Long(this.rawPrim);
                    break;
                }
                case 8: {
                    this.rawObj = Float.valueOf(Entry.prim2Float(this.rawPrim));
                    break;
                }
                case 9: {
                    this.rawObj = Entry.prim2Double(this.rawPrim);
                    break;
                }
            }
            return this.rawObj;
        }

        public boolean booleanValue() {
            byte type = this.rawType;
            if (type == 2) {
                return Entry.prim2Boolean(this.rawPrim);
            }
            if (type == 0 && this.rawObj instanceof Boolean) {
                boolean boolValue = (Boolean)this.rawObj;
                this._setPrim((byte)2, Entry.boolean2Prim(boolValue));
                return boolValue;
            }
            byte resolvedType = this.resolveAny();
            long prim = this.rawPrim;
            switch (resolvedType) {
                case 6: {
                    return Entry.prim2Int(prim) != 0;
                }
                case 7: {
                    return Entry.prim2Long(prim) != 0L;
                }
                case 8: {
                    return Entry.prim2Float(prim) != 0.0f;
                }
                case 9: {
                    return Entry.prim2Double(prim) != 0.0;
                }
                case 1: {
                    return this.rawObj != null;
                }
            }
            return false;
        }

        public int intValue() {
            byte type = this.rawType;
            if (type == 6) {
                return Entry.prim2Int(this.rawPrim);
            }
            if (type == 0 && this.rawObj instanceof Integer) {
                int intValue = (Integer)this.rawObj;
                this._setPrim((byte)6, Entry.int2Prim(intValue));
                return intValue;
            }
            byte resolvedType = this.resolveAny();
            long prim = this.rawPrim;
            switch (resolvedType) {
                case 2: {
                    return Entry.prim2Boolean(prim) ? 1 : 0;
                }
                case 7: {
                    return (int)Entry.prim2Long(prim);
                }
                case 8: {
                    return (int)Entry.prim2Float(prim);
                }
                case 9: {
                    return (int)Entry.prim2Double(prim);
                }
                case 1: {
                    return 0;
                }
            }
            return 0;
        }

        public long longValue() {
            byte type = this.rawType;
            if (type == 7) {
                return Entry.prim2Long(this.rawPrim);
            }
            if (type == 0 && this.rawObj instanceof Long) {
                long longValue = (Long)this.rawObj;
                this._setPrim((byte)7, Entry.long2Prim(longValue));
                return longValue;
            }
            byte resolvedType = this.resolveAny();
            long prim = this.rawPrim;
            switch (resolvedType) {
                case 2: {
                    return Entry.prim2Boolean(prim) ? 1L : 0L;
                }
                case 6: {
                    return Entry.prim2Int(prim);
                }
                case 8: {
                    return (long)Entry.prim2Float(prim);
                }
                case 9: {
                    return (long)Entry.prim2Double(prim);
                }
                case 1: {
                    return 0L;
                }
            }
            return 0L;
        }

        public float floatValue() {
            byte type = this.rawType;
            if (type == 8) {
                return Entry.prim2Float(this.rawPrim);
            }
            if (type == 0 && this.rawObj instanceof Float) {
                float floatValue = ((Float)this.rawObj).floatValue();
                this._setPrim((byte)8, Entry.float2Prim(floatValue));
                return floatValue;
            }
            byte resolvedType = this.resolveAny();
            long prim = this.rawPrim;
            switch (resolvedType) {
                case 2: {
                    return Entry.prim2Boolean(prim) ? 1.0f : 0.0f;
                }
                case 6: {
                    return Entry.prim2Int(prim);
                }
                case 7: {
                    return Entry.prim2Long(prim);
                }
                case 9: {
                    return (float)Entry.prim2Double(prim);
                }
                case 1: {
                    return 0.0f;
                }
            }
            return 0.0f;
        }

        public double doubleValue() {
            byte type = this.rawType;
            if (type == 9) {
                return Entry.prim2Double(this.rawPrim);
            }
            if (type == 0 && this.rawObj instanceof Double) {
                double doubleValue = (Double)this.rawObj;
                this._setPrim((byte)9, Entry.double2Prim(doubleValue));
                return doubleValue;
            }
            byte resolvedType = this.resolveAny();
            long prim = this.rawPrim;
            switch (resolvedType) {
                case 2: {
                    return Entry.prim2Boolean(prim) ? 1.0 : 0.0;
                }
                case 6: {
                    return Entry.prim2Int(prim);
                }
                case 7: {
                    return Entry.prim2Long(prim);
                }
                case 8: {
                    return Entry.prim2Float(prim);
                }
                case 1: {
                    return 0.0;
                }
            }
            return 0.0;
        }

        public String stringValue() {
            String computeStr;
            String strCache = this.strCache;
            if (strCache != null) {
                return strCache;
            }
            this.strCache = computeStr = this.computeStringValue();
            return computeStr;
        }

        private String computeStringValue() {
            switch (this.rawType) {
                case 2: {
                    return Boolean.toString(Entry.prim2Boolean(this.rawPrim));
                }
                case 6: {
                    return Integer.toString(Entry.prim2Int(this.rawPrim));
                }
                case 7: {
                    return Long.toString(Entry.prim2Long(this.rawPrim));
                }
                case 8: {
                    return Float.toString(Entry.prim2Float(this.rawPrim));
                }
                case 9: {
                    return Double.toString(Entry.prim2Double(this.rawPrim));
                }
                case 0: 
                case 1: {
                    return this.rawObj.toString();
                }
            }
            return null;
        }

        public String toString() {
            return this.tag() + '=' + this.stringValue();
        }

        @Override
        @Deprecated
        public String getKey() {
            return this.tag();
        }

        @Override
        @Deprecated
        public Object getValue() {
            return this.objectValue();
        }

        @Override
        @Deprecated
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.hash();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry that = (Entry)obj;
            return this.tag.equals(that.tag) && this.objectValue().equals(that.objectValue());
        }

        private static long boolean2Prim(boolean value) {
            return value ? 1L : 0L;
        }

        private static boolean prim2Boolean(long prim) {
            return prim != 0L;
        }

        private static long int2Prim(int value) {
            return value;
        }

        private static int prim2Int(long prim) {
            return (int)prim;
        }

        private static long long2Prim(long value) {
            return value;
        }

        private static long prim2Long(long prim) {
            return prim;
        }

        private static long float2Prim(float value) {
            return Float.floatToIntBits(value);
        }

        private static float prim2Float(long prim) {
            return Float.intBitsToFloat((int)prim);
        }

        private static long double2Prim(double value) {
            return Double.doubleToRawLongBits(value);
        }

        private static double prim2Double(long prim) {
            return Double.longBitsToDouble(prim);
        }

        static int _hash(String tag) {
            int hash = tag.hashCode();
            return hash == 0 ? 56582 : hash ^ hash >>> 16;
        }
    }

    public static final class EntryRemoval
    extends EntryChange {
        EntryRemoval(String tag) {
            super(tag);
        }

        @Override
        public boolean isRemoval() {
            return true;
        }
    }

    public static abstract class EntryChange {
        final String tag;

        public static final EntryRemoval newRemoval(String tag) {
            return new EntryRemoval(tag);
        }

        EntryChange(String tag) {
            this.tag = tag;
        }

        public final String tag() {
            return this.tag;
        }

        public final boolean matches(String tag) {
            return this.tag.equals(tag);
        }

        public abstract boolean isRemoval();
    }
}

