/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.coverage;

import ddtrot.dd.trace.api.civisibility.InstrumentationTestBridge;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageProbes;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageStore;
import ddtrot.dd.trace.api.civisibility.coverage.NoOpProbes;
import ddtrot.dd.trace.api.civisibility.domain.TestContext;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public abstract class CoveragePerTestBridge {
    private static final ThreadLocal<CoverageProbes> COVERAGE_PROBES = new ThreadLocal();
    private static volatile CoverageStore.Registry COVERAGE_STORE_REGISTRY;
    private static final Object COVERAGE_STORE_REGISTRY_LOCK;
    @GuardedBy(value="COVERAGE_STORE_REGISTRY_LOCK")
    private static final Queue<TotalProbeCount> DEFERRED_PROBE_COUNTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCoverageStoreRegistry(@Nonnull CoverageStore.Registry coverageStoreRegistry) {
        Object object = COVERAGE_STORE_REGISTRY_LOCK;
        synchronized (object) {
            while (!DEFERRED_PROBE_COUNTS.isEmpty()) {
                TotalProbeCount c = DEFERRED_PROBE_COUNTS.poll();
                coverageStoreRegistry.setTotalProbeCount(c.className, c.count);
            }
            COVERAGE_STORE_REGISTRY = coverageStoreRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTotalProbeCount(String className, int totalProbeCount) {
        if (COVERAGE_STORE_REGISTRY != null) {
            COVERAGE_STORE_REGISTRY.setTotalProbeCount(className, totalProbeCount);
            return;
        }
        Object object = COVERAGE_STORE_REGISTRY_LOCK;
        synchronized (object) {
            if (COVERAGE_STORE_REGISTRY != null) {
                COVERAGE_STORE_REGISTRY.setTotalProbeCount(className, totalProbeCount);
            } else {
                DEFERRED_PROBE_COUNTS.offer(new TotalProbeCount(className, totalProbeCount));
            }
        }
    }

    public static void recordCoverage(Class<?> clazz, long classId, int probeId) {
        CoveragePerTestBridge.getCurrentCoverageProbes().record(clazz, classId, probeId);
    }

    public static void recordCoverage(Class<?> clazz) {
        CoveragePerTestBridge.getCurrentCoverageProbes().record(clazz);
    }

    public static void recordCoverage(String absolutePath) {
        CoveragePerTestBridge.getCurrentCoverageProbes().recordNonCodeResource(absolutePath);
    }

    private static CoverageProbes getCurrentCoverageProbes() {
        CoverageProbes probes = COVERAGE_PROBES.get();
        if (probes != null) {
            return probes;
        }
        TestContext currentTest = InstrumentationTestBridge.getCurrentTestContext();
        if (currentTest != null) {
            return currentTest.getCoverageStore().getProbes();
        }
        return NoOpProbes.INSTANCE;
    }

    public static void setThreadLocalCoverageProbes(CoverageProbes probes) {
        COVERAGE_PROBES.set(probes);
    }

    public static void removeThreadLocalCoverageProbes() {
        COVERAGE_PROBES.remove();
    }

    static {
        COVERAGE_STORE_REGISTRY_LOCK = new Object();
        DEFERRED_PROBE_COUNTS = new ArrayDeque<TotalProbeCount>();
    }

    private static final class TotalProbeCount {
        private final String className;
        private final int count;

        private TotalProbeCount(String className, int count) {
            this.className = className;
            this.count = count;
        }
    }
}

