/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import ddtrot.dd.trace.api.telemetry.MetricCollector;
import ddtrot.dd.trace.api.telemetry.OtelEnvMetricCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelEnvMetricCollectorImpl
implements MetricCollector<OtelEnvMetric>,
OtelEnvMetricCollector {
    private static final Logger log = LoggerFactory.getLogger(OtelEnvMetricCollectorImpl.class);
    private static final String OTEL_ENV_HIDING_METRIC_NAME = "otel.env.hiding";
    private static final String OTEL_ENV_INVALID_METRIC_NAME = "otel.env.invalid";
    private static final String OTEL_ENV_UNSUPPORTED_METRIC_NAME = "otel.env.unsupported";
    private static final String CONFIG_OTEL_KEY_TAG = "config_opentelemetry:";
    private static final String CONFIG_DATADOG_KEY_TAG = "config_datadog:";
    private static final String NAMESPACE = "tracers";
    private static final OtelEnvMetricCollectorImpl INSTANCE = new OtelEnvMetricCollectorImpl();
    private final BlockingQueue<OtelEnvMetric> metricsQueue = new ArrayBlockingQueue<OtelEnvMetric>(1024);

    private OtelEnvMetricCollectorImpl() {
    }

    public static OtelEnvMetricCollectorImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void setHidingOtelEnvVarMetric(String otelName, String ddName) {
        this.setMetricOtelEnvVarMetric(OTEL_ENV_HIDING_METRIC_NAME, CONFIG_OTEL_KEY_TAG + otelName, CONFIG_DATADOG_KEY_TAG + ddName);
    }

    @Override
    public void setInvalidOtelEnvVarMetric(String otelName, String ddName) {
        this.setMetricOtelEnvVarMetric(OTEL_ENV_INVALID_METRIC_NAME, CONFIG_OTEL_KEY_TAG + otelName, CONFIG_DATADOG_KEY_TAG + ddName);
    }

    @Override
    public void setUnsupportedOtelEnvVarMetric(String otelName) {
        this.setMetricOtelEnvVarMetric(OTEL_ENV_UNSUPPORTED_METRIC_NAME, CONFIG_OTEL_KEY_TAG + otelName);
    }

    private void setMetricOtelEnvVarMetric(String metricName, String ... tags) {
        if (!this.metricsQueue.offer(new OtelEnvMetric(NAMESPACE, true, metricName, "count", (Number)1, tags))) {
            log.debug("Unable to add telemetry metric {} for {}", (Object)metricName, (Object)tags[0]);
        }
    }

    @Override
    public void prepareMetrics() {
    }

    @Override
    public Collection<OtelEnvMetric> drain() {
        if (this.metricsQueue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OtelEnvMetric> drained = new ArrayList<OtelEnvMetric>(this.metricsQueue.size());
        this.metricsQueue.drainTo(drained);
        return drained;
    }

    public static class OtelEnvMetric
    extends MetricCollector.Metric {
        public OtelEnvMetric(String namespace, boolean common, String metricName, String type, Number value, String ... tags) {
            super(namespace, common, metricName, type, value, tags);
        }
    }
}

