/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import ddtrot.dd.trace.util.ConfigStrings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigConverter {
    private static final Logger log = LoggerFactory.getLogger(ConfigConverter.class);
    private static final ValueOfLookup LOOKUP = new ValueOfLookup();

    ConfigConverter() {
    }

    static <T> T valueOf(String value, @Nonnull Class<T> tClass) {
        Objects.requireNonNull(tClass, "tClass is marked non-null but is null");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            return (T)((MethodHandle)LOOKUP.get(tClass)).invoke(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            log.debug("Can't parse: ", e);
            throw new NumberFormatException(e.toString());
        }
    }

    @Nonnull
    static List<String> parseList(String str) {
        return ConfigConverter.parseList(str, ",");
    }

    @Nonnull
    @SuppressForbidden
    static List<String> parseList(String str, String separator) {
        String trimmed = ConfigStrings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = trimmed.split(separator, -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    @Nonnull
    static Map<String, String> parseMap(String str, String settingName) {
        return ConfigConverter.parseMap(str, settingName, ':');
    }

    @Nonnull
    static Map<String, String> parseMap(String str, String settingName, char keyValueSeparator) {
        String trimmed = ConfigStrings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigConverter.loadMap(map, trimmed, settingName, keyValueSeparator);
        return map;
    }

    @Nonnull
    static Map<String, String> parseTraceTagsMap(String str, char keyValueSeparator, List<Character> argSeparators) {
        String trimmed = ConfigStrings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigConverter.loadTraceTagsMap(map, trimmed, keyValueSeparator, argSeparators);
        return map;
    }

    @Nonnull
    static Map<String, String> parseMapWithOptionalMappings(String str, String settingName, String defaultPrefix, boolean lowercaseKeys) {
        String trimmed = ConfigStrings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigConverter.loadMapWithOptionalMapping(map, trimmed, settingName, defaultPrefix, lowercaseKeys);
        return map;
    }

    @Nonnull
    static Map<String, String> parseOrderedMap(String str, String settingName) {
        String trimmed = ConfigStrings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ConfigConverter.loadMap(map, trimmed, settingName, ':');
        return map;
    }

    private static void loadMap(Map<String, String> map, String str, String settingName, char keyValueSeparator) {
        try {
            int start = 0;
            int splitter = str.indexOf(keyValueSeparator, start);
            while (splitter != -1) {
                String key;
                int end;
                int nextSplitter = str.indexOf(keyValueSeparator, splitter + 1);
                int nextComma = str.indexOf(44, splitter + 1);
                nextComma = nextComma == -1 ? str.length() : nextComma;
                int nextSpace = str.indexOf(32, splitter + 1);
                nextSpace = nextSpace == -1 ? str.length() : nextSpace;
                int n = end = nextComma < str.length() ? nextComma : nextSpace;
                while (nextSplitter != -1 && nextSplitter < end) {
                    nextSplitter = str.indexOf(keyValueSeparator, nextSplitter + 1);
                }
                if (nextSplitter == -1) {
                    end = nextComma;
                    if (nextComma < str.length() - 1) {
                        throw new BadFormatException("Non white space characters after trailing ','");
                    }
                } else if (nextComma < str.length()) {
                    end = nextComma;
                } else if (nextSpace < str.length()) {
                    end = nextSpace;
                } else {
                    throw new BadFormatException("Illegal position of split character ':'");
                }
                if ((key = str.substring(start, splitter).trim()).indexOf(44) != -1) {
                    throw new BadFormatException("Illegal ',' character in key '" + key + "'");
                }
                String value = str.substring(splitter + 1, end).trim();
                if (value.indexOf(32) != -1) {
                    throw new BadFormatException("Illegal ' ' character in value for key '" + key + "'");
                }
                if (!key.isEmpty() && !value.isEmpty()) {
                    map.put(key, value);
                }
                splitter = nextSplitter;
                start = end + 1;
            }
        }
        catch (Throwable t) {
            if (t instanceof BadFormatException) {
                log.warn("Invalid config for {}. {}. Must match 'key1{}value1,key2{}value2' or 'key1{}value1 key2{}value2'.", new Object[]{settingName, t.getMessage(), Character.valueOf(keyValueSeparator), Character.valueOf(keyValueSeparator), Character.valueOf(keyValueSeparator), Character.valueOf(keyValueSeparator)});
            } else {
                log.warn("Unexpected exception during config parsing of {}.", (Object)settingName, (Object)t);
            }
            map.clear();
        }
    }

    private static void loadTraceTagsMap(Map<String, String> map, String str, char keyValueSeparator, List<Character> argSeparators) {
        int start = 0;
        int splitter = str.indexOf(keyValueSeparator, start);
        char argSeparator = '\u0000';
        int argSeparatorInd = -1;
        for (Character sep : argSeparators) {
            argSeparatorInd = str.indexOf(sep.charValue());
            if (argSeparatorInd == -1) continue;
            argSeparator = sep.charValue();
            break;
        }
        while (start < str.length()) {
            String value;
            String key;
            int end;
            int nextSplitter = argSeparatorInd == -1 ? -1 : str.indexOf(keyValueSeparator, argSeparatorInd + 1);
            int nextArgSeparator = argSeparatorInd == -1 ? -1 : str.indexOf(argSeparator, argSeparatorInd + 1);
            int n = end = argSeparatorInd == -1 ? str.length() : argSeparatorInd;
            if (start >= end) {
                start = end + 1;
                splitter = nextSplitter;
                argSeparatorInd = nextArgSeparator;
                continue;
            }
            if (splitter >= end || splitter == -1) {
                key = str.substring(start, end).trim();
                value = "";
            } else {
                key = str.substring(start, splitter).trim();
                value = str.substring(splitter + 1, end).trim();
            }
            if (!key.isEmpty()) {
                map.put(key, value);
            }
            splitter = nextSplitter;
            argSeparatorInd = nextArgSeparator;
            start = end + 1;
        }
    }

    private static void loadMapWithOptionalMapping(Map<String, String> map, String str, String settingName, String defaultPrefix, boolean lowercaseKeys) {
        try {
            int listChar;
            String string = defaultPrefix = null == defaultPrefix ? "" : defaultPrefix;
            if (!defaultPrefix.isEmpty() && !defaultPrefix.endsWith(".")) {
                defaultPrefix = defaultPrefix + ".";
            }
            int start = 0;
            int len = str.length();
            int n = listChar = str.indexOf(44) == -1 ? 32 : 44;
            while (start < len) {
                String key;
                int delimiter;
                int end = len;
                int listPos = str.indexOf(listChar, start);
                int mapPos = str.indexOf(58, start);
                int n2 = listPos == -1 ? mapPos : (delimiter = mapPos == -1 ? listPos : Math.min(listPos, mapPos));
                if (delimiter == -1) {
                    delimiter = end;
                } else if (delimiter == mapPos) {
                    int nextList = str.indexOf(listChar, delimiter + 1);
                    if (mapPos == start) {
                        throw new BadFormatException("Illegal empty key at position " + start);
                    }
                    if (nextList != -1) {
                        end = nextList;
                    }
                } else {
                    end = delimiter;
                }
                if (start != end && !(key = ConfigConverter.trimmedHeader(str, start, delimiter, lowercaseKeys)).isEmpty()) {
                    String value;
                    if (delimiter == mapPos) {
                        value = ConfigConverter.trimmedHeader(str, delimiter + 1, end, false);
                        if (!value.isEmpty() && !Character.isLetter(value.charAt(0))) {
                            throw new BadFormatException("Illegal tag starting with non letter for key '" + key + "'");
                        }
                    } else {
                        if (key.charAt(0) == '*') {
                            map.clear();
                            map.put(key, defaultPrefix);
                            return;
                        }
                        if (Character.isLetter(key.charAt(0))) {
                            value = defaultPrefix + ConfigStrings.normalizedHeaderTag(key);
                        } else {
                            throw new BadFormatException("Illegal key only tag starting with non letter '" + key + "'");
                        }
                    }
                    if (!value.isEmpty()) {
                        map.put(key, value);
                    }
                }
                start = end + 1;
            }
        }
        catch (Throwable t) {
            if (t instanceof BadFormatException) {
                log.warn("Invalid config for {}. {}. Must match '(key:value|key)([ ,](key:value|key))*'.", (Object)settingName, (Object)t.getMessage());
            } else {
                log.warn("Unexpected exception during config parsing of {}.", (Object)settingName, (Object)t);
            }
            map.clear();
        }
    }

    @Nonnull
    private static String trimmedHeader(String str, int start, int end, boolean lowercase) {
        if (start >= end) {
            return "";
        }
        StringBuilder builder = new StringBuilder(end - start);
        int firstNonWhiteSpace = -1;
        int lastNonWhitespace = -1;
        for (int i = start; i < end; ++i) {
            char c;
            char c2 = c = lowercase ? Character.toLowerCase(str.charAt(i)) : str.charAt(i);
            if (Character.isWhitespace(c)) {
                builder.append(' ');
                continue;
            }
            firstNonWhiteSpace = firstNonWhiteSpace == -1 ? i : firstNonWhiteSpace;
            lastNonWhitespace = i;
            builder.append(c);
        }
        if (firstNonWhiteSpace == -1) {
            return "";
        }
        str = builder.substring(firstNonWhiteSpace - start, lastNonWhitespace - start + 1);
        return str;
    }

    @Nonnull
    @SuppressForbidden
    static BitSet parseIntegerRangeSet(@Nonnull String str, String settingName) throws NumberFormatException {
        String[] tokens;
        if (!(str = str.replaceAll("\\s", "")).matches("\\d{1,3}(?:-\\d{1,3})?(?:,\\d{1,3}(?:-\\d{1,3})?)*")) {
            log.warn("Invalid config for {}: '{}'. Must be formatted like '400-403,405,410-499'.", (Object)settingName, (Object)str);
            throw new NumberFormatException();
        }
        int lastSeparator = Math.max(str.lastIndexOf(44), str.lastIndexOf(45));
        int maxValue = Integer.parseInt(str.substring(lastSeparator + 1));
        BitSet set = new BitSet(maxValue);
        for (String token : tokens = str.split(",", -1)) {
            int separator = token.indexOf(45);
            if (separator == -1) {
                set.set(Integer.parseInt(token));
                continue;
            }
            if (separator <= 0) continue;
            int left = Integer.parseInt(token.substring(0, separator));
            int right = Integer.parseInt(token.substring(separator + 1));
            int min = Math.min(left, right);
            int max = Math.max(left, right);
            set.set(min, max + 1);
        }
        return set;
    }

    public static Boolean booleanValueOf(String value) {
        if ("1".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value)) {
            return Boolean.FALSE;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new InvalidBooleanValueException("Invalid boolean value: " + value);
    }

    private static class ValueOfLookup
    extends ClassValue<MethodHandle> {
        private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

        private ValueOfLookup() {
        }

        @Override
        protected MethodHandle computeValue(Class<?> type) {
            try {
                if (Boolean.class.equals(type)) {
                    return MethodHandles.lookup().findStatic(ConfigConverter.class, "booleanValueOf", MethodType.methodType(Boolean.class, String.class));
                }
                return PUBLIC_LOOKUP.findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                log.debug("Can't invoke or access 'valueOf': ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static final class BadFormatException
    extends Exception {
        public BadFormatException(String message) {
            super(message);
        }
    }

    static class InvalidBooleanValueException
    extends IllegalArgumentException {
        public InvalidBooleanValueException(String message) {
            super(message);
        }
    }
}

