/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.ClassloaderConfigurationOverrides;
import datadog.trace.api.Config;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.DynamicConfig;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.TagMap;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.TracePropagationBehaviorExtract;
import datadog.trace.api.experimental.DataStreamsCheckpointer;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.context.TraceScope;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.ExternalAgentLauncher;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.communication.monitor.DDAgentStatsDClientManager;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.context.propagation.Propagators;
import ddtrot.dd.environment.ThreadUtils;
import ddtrot.dd.trace.api.EndpointTracker;
import ddtrot.dd.trace.api.datastreams.AgentDataStreamsMonitoring;
import ddtrot.dd.trace.api.datastreams.PathwayContext;
import ddtrot.dd.trace.api.flare.TracerFlare;
import ddtrot.dd.trace.api.gateway.CallbackProvider;
import ddtrot.dd.trace.api.gateway.InstrumentationGateway;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.gateway.SubscriptionService;
import ddtrot.dd.trace.api.metrics.SpanMetricRegistry;
import ddtrot.dd.trace.api.naming.SpanNaming;
import ddtrot.dd.trace.api.remoteconfig.ServiceNameCollector;
import ddtrot.dd.trace.api.rum.RumInjector;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.api.time.SystemTimeSource;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentHistogram;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Baggage;
import ddtrot.dd.trace.bootstrap.instrumentation.api.BlackHoleSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanAttributes;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.civisibility.interceptor.CiVisibilityApmProtocolInterceptor;
import ddtrot.dd.trace.civisibility.interceptor.CiVisibilityTelemetryInterceptor;
import ddtrot.dd.trace.civisibility.interceptor.CiVisibilityTraceInterceptor;
import ddtrot.dd.trace.common.GitMetadataTraceInterceptor;
import ddtrot.dd.trace.common.metrics.MetricsAggregator;
import ddtrot.dd.trace.common.metrics.MetricsAggregatorFactory;
import ddtrot.dd.trace.common.metrics.NoOpMetricsAggregator;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.common.sampling.SpanSamplingRules;
import ddtrot.dd.trace.common.sampling.TraceSamplingRules;
import ddtrot.dd.trace.common.writer.DDAgentWriter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.common.writer.WriterFactory;
import ddtrot.dd.trace.common.writer.ddintake.DDIntakeTraceInterceptor;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.DDSpanLink;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.core.PendingTrace;
import ddtrot.dd.trace.core.PendingTraceBuffer;
import ddtrot.dd.trace.core.StatusLogger;
import ddtrot.dd.trace.core.StreamingTraceCollector;
import ddtrot.dd.trace.core.TraceCollector;
import ddtrot.dd.trace.core.TracingConfigPoller;
import ddtrot.dd.trace.core.baggage.BaggagePropagator;
import ddtrot.dd.trace.core.datastreams.DataStreamsMonitoring;
import ddtrot.dd.trace.core.datastreams.DefaultDataStreamsMonitoring;
import ddtrot.dd.trace.core.histogram.Histograms;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.core.monitor.MonitoringImpl;
import ddtrot.dd.trace.core.monitor.TracerHealthMetrics;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.InferredProxyPropagator;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.propagation.TracingPropagator;
import ddtrot.dd.trace.core.propagation.XRayPropagator;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import ddtrot.dd.trace.core.servicediscovery.ServiceDiscovery;
import ddtrot.dd.trace.core.servicediscovery.ServiceDiscoveryFactory;
import ddtrot.dd.trace.core.taginterceptor.RuleFlags;
import ddtrot.dd.trace.core.taginterceptor.TagInterceptor;
import ddtrot.dd.trace.core.traceinterceptor.LatencyTraceInterceptor;
import ddtrot.dd.trace.lambda.LambdaHandler;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.dd.trace.util.CollectionUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTracer
implements AgentTracer.TracerAPI,
TracerFlare.Reporter {
    private static final Logger log = LoggerFactory.getLogger(CoreTracer.class);
    public static final BigInteger TRACE_ID_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    private static final String LANG_STATSD_TAG = "lang";
    private static final String LANG_VERSION_STATSD_TAG = "lang_version";
    private static final String LANG_INTERPRETER_STATSD_TAG = "lang_interpreter";
    private static final String LANG_INTERPRETER_VENDOR_STATSD_TAG = "lang_interpreter_vendor";
    private static final String TRACER_VERSION_STATSD_TAG = "tracer_version";
    private final long startTimeNano;
    private final long startNanoTicks;
    private final long clockSyncPeriod;
    private final boolean allowInferredServices;
    private volatile long lastSyncTicks;
    private volatile long counterDrift;
    private final TracingConfigPoller tracingConfigPoller;
    private final PendingTraceBuffer pendingTraceBuffer;
    final String serviceName;
    final Writer writer;
    final Sampler initialSampler;
    final ContinuableScopeManager scopeManager;
    volatile MetricsAggregator metricsAggregator;
    final Config initialConfig;
    private final DynamicConfig<ConfigSnapshot> dynamicConfig;
    private final TagMap localRootSpanTags;
    private final boolean localRootSpanTagsNeedIntercept;
    private final TagMap defaultSpanTags;
    private final boolean defaultSpanTagsNeedsIntercept;
    private final int partialFlushMinSpans;
    private final StatsDClient statsDClient;
    private final Monitoring monitoring;
    private final Monitoring performanceMonitoring;
    private final HealthMetrics healthMetrics;
    private final Recording traceWriteTimer;
    private final IdGenerationStrategy idGenerationStrategy;
    private final TraceCollector.Factory traceCollectorFactory;
    private final DataStreamsMonitoring dataStreamsMonitoring;
    private final ExternalAgentLauncher externalAgentLauncher;
    private final boolean disableSamplingMechanismValidation;
    private final TimeSource timeSource;
    private final ProfilingContextIntegration profilingContextIntegration;
    private final boolean injectBaggageAsTags;
    private final boolean flushOnClose;
    private final Collection<Runnable> shutdownListeners = new CopyOnWriteArrayList<Runnable>();
    private final Thread shutdownCallback;
    private final TagInterceptor tagInterceptor;
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(Comparator.comparingInt(TraceInterceptor::priority));
    private final boolean logs128bTraceIdEnabled;
    private final InstrumentationGateway instrumentationGateway;
    private final CallbackProvider callbackProviderAppSec;
    private final CallbackProvider callbackProviderIast;
    private final CallbackProvider universalCallbackProvider;
    private final PropagationTags.Factory propagationTagsFactory;
    private static final boolean SPAN_BUILDER_REUSE_ENABLED = Config.get().isSpanBuilderReuseEnabled();
    private final ReusableSingleSpanBuilderThreadLocalCache spanBuilderThreadLocalCache = SPAN_BUILDER_REUSE_ENABLED ? new ReusableSingleSpanBuilderThreadLocalCache(this) : null;
    private final RatelimitedLogger rlLog = new RatelimitedLogger(log, 1, TimeUnit.MINUTES);

    public static final CoreTracerBuilder builder() {
        return new CoreTracerBuilder();
    }

    @Override
    public ConfigSnapshot captureTraceConfig() {
        return this.dynamicConfig.captureTraceConfig();
    }

    @Override
    public AgentHistogram newHistogram(double relativeAccuracy, int maxNumBins) {
        return Histograms.newHistogram(relativeAccuracy, maxNumBins);
    }

    @Override
    public void updatePreferredServiceName(String serviceName) {
        this.dynamicConfig.current().setPreferredServiceName(serviceName).apply();
        ServiceNameCollector.get().addService(serviceName);
    }

    PropagationTags.Factory getPropagationTagsFactory() {
        return this.propagationTagsFactory;
    }

    @Override
    public void onRootSpanFinished(AgentSpan root, EndpointTracker tracker) {
        if (!root.isOutbound()) {
            this.profilingContextIntegration.onRootSpanFinished(root, tracker);
        }
    }

    void onRootSpanPublished(AgentSpan root) {
        RequestContext requestContext = root.getRequestContext();
        if (requestContext != null) {
            try {
                requestContext.close();
            }
            catch (IOException e) {
                log.warn("Error closing request context data", (Throwable)e);
            }
        }
    }

    @Override
    public EndpointTracker onRootSpanStarted(AgentSpan root) {
        if (!root.isOutbound()) {
            return this.profilingContextIntegration.onRootSpanStarted(root);
        }
        return null;
    }

    @Deprecated
    private CoreTracer(Config config, String serviceName, SharedCommunicationObjects sharedCommunicationObjects, Writer writer, IdGenerationStrategy idGenerationStrategy, Sampler sampler, SingleSpanSampler singleSpanSampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, Map<String, Object> localRootSpanTags, TagMap defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, Map<String, String> baggageMapping, int partialFlushMinSpans, StatsDClient statsDClient, HealthMetrics healthMetrics, TagInterceptor tagInterceptor, boolean strictTraceWrites, InstrumentationGateway instrumentationGateway, TimeSource timeSource, DataStreamsMonitoring dataStreamsMonitoring, ProfilingContextIntegration profilingContextIntegration, boolean reportInTracerFlare, boolean pollForTracingConfiguration, boolean injectBaggageAsTags, boolean flushOnClose) {
        this(config, serviceName, sharedCommunicationObjects, writer, idGenerationStrategy, sampler, singleSpanSampler, injector, extractor, TagMap.fromMap(localRootSpanTags), defaultSpanTags, serviceNameMappings, taggedHeaders, baggageMapping, partialFlushMinSpans, statsDClient, healthMetrics, tagInterceptor, strictTraceWrites, instrumentationGateway, null, timeSource, dataStreamsMonitoring, profilingContextIntegration, reportInTracerFlare, pollForTracingConfiguration, injectBaggageAsTags, flushOnClose);
    }

    private CoreTracer(Config config, String serviceName, SharedCommunicationObjects sharedCommunicationObjects, Writer writer, IdGenerationStrategy idGenerationStrategy, Sampler sampler, SingleSpanSampler singleSpanSampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, TagMap localRootSpanTags, TagMap defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, Map<String, String> baggageMapping, int partialFlushMinSpans, StatsDClient statsDClient, HealthMetrics healthMetrics, TagInterceptor tagInterceptor, boolean strictTraceWrites, InstrumentationGateway instrumentationGateway, ServiceDiscoveryFactory serviceDiscoveryFactory, TimeSource timeSource, DataStreamsMonitoring dataStreamsMonitoring, ProfilingContextIntegration profilingContextIntegration, boolean reportInTracerFlare, boolean pollForTracingConfiguration, boolean injectBaggageAsTags, boolean flushOnClose) {
        TraceSamplingRules traceSamplingRules;
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        assert (baggageMapping != null);
        if (reportInTracerFlare) {
            TracerFlare.addReporter(this);
        }
        this.timeSource = timeSource == null ? SystemTimeSource.INSTANCE : timeSource;
        this.startTimeNano = this.timeSource.getCurrentTimeNanos();
        this.startNanoTicks = this.timeSource.getNanoTicks();
        this.clockSyncPeriod = Math.max(1000000L, TimeUnit.SECONDS.toNanos(config.getClockSyncPeriod()));
        this.lastSyncTicks = this.startNanoTicks;
        this.serviceName = serviceName;
        this.initialConfig = config;
        this.initialSampler = sampler;
        String traceSamplingRulesJson = config.getTraceSamplingRules();
        if (traceSamplingRulesJson == null) {
            traceSamplingRulesJson = "[]";
            traceSamplingRules = TraceSamplingRules.EMPTY;
        } else {
            traceSamplingRules = TraceSamplingRules.deserialize(traceSamplingRulesJson);
        }
        String spanSamplingRulesJson = config.getSpanSamplingRules();
        String spanSamplingRulesFile = config.getSpanSamplingRulesFile();
        SpanSamplingRules spanSamplingRules = SpanSamplingRules.EMPTY;
        if (spanSamplingRulesJson != null) {
            spanSamplingRules = SpanSamplingRules.deserialize(spanSamplingRulesJson);
        } else if (spanSamplingRulesFile != null) {
            spanSamplingRules = SpanSamplingRules.deserializeFile(spanSamplingRulesFile);
        }
        this.tagInterceptor = null == tagInterceptor ? new TagInterceptor(new RuleFlags(config)) : tagInterceptor;
        this.defaultSpanTags = defaultSpanTags;
        this.defaultSpanTagsNeedsIntercept = this.tagInterceptor.needsIntercept(this.defaultSpanTags);
        this.dynamicConfig = DynamicConfig.create((x$0, x$1) -> new ConfigSnapshot((DynamicConfig.Builder)x$0, (ConfigSnapshot)x$1)).setTracingEnabled(true).setRuntimeMetricsEnabled(config.isRuntimeMetricsEnabled()).setLogsInjectionEnabled(config.isLogsInjectionEnabled()).setDataStreamsEnabled(config.isDataStreamsEnabled()).setServiceMapping(serviceNameMappings).setHeaderTags(taggedHeaders).setBaggageMapping(baggageMapping).setTraceSampleRate(config.getTraceSampleRate()).setSpanSamplingRules(spanSamplingRules.getRules()).setTraceSamplingRules(traceSamplingRules.getRules(), traceSamplingRulesJson).setTracingTags(config.getMergedSpanTags()).apply();
        this.logs128bTraceIdEnabled = Config.get().isLogs128bitTraceIdEnabled();
        this.partialFlushMinSpans = partialFlushMinSpans;
        IdGenerationStrategy idGenerationStrategy2 = this.idGenerationStrategy = null == idGenerationStrategy ? Config.get().getIdGenerationStrategy() : idGenerationStrategy;
        this.statsDClient = statsDClient != null ? statsDClient : (writer == null || writer instanceof DDAgentWriter ? CoreTracer.createStatsDClient(config) : StatsDClient.NO_OP);
        Monitoring monitoring = this.monitoring = config.isHealthMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.healthMetrics = healthMetrics != null ? healthMetrics : (config.isHealthMetricsEnabled() ? new TracerHealthMetrics(this.statsDClient) : HealthMetrics.NO_OP);
        this.healthMetrics.start();
        this.performanceMonitoring = config.isPerfMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.traceWriteTimer = this.performanceMonitoring.newThreadLocalTimer("trace.write");
        this.scopeManager = new ContinuableScopeManager(config.getScopeDepthLimit(), config.isScopeStrictMode(), profilingContextIntegration, this.healthMetrics);
        this.externalAgentLauncher = new ExternalAgentLauncher(config);
        this.disableSamplingMechanismValidation = config.isSamplingMechanismValidationDisabled();
        if (sharedCommunicationObjects == null) {
            sharedCommunicationObjects = new SharedCommunicationObjects();
        }
        sharedCommunicationObjects.monitoring = this.monitoring;
        sharedCommunicationObjects.createRemaining(config);
        this.tracingConfigPoller = new TracingConfigPoller(this.dynamicConfig);
        if (pollForTracingConfiguration) {
            this.tracingConfigPoller.start(config, sharedCommunicationObjects);
        }
        this.writer = writer == null ? WriterFactory.createWriter(config, sharedCommunicationObjects, sampler, singleSpanSampler, this.healthMetrics) : writer;
        DDAgentFeaturesDiscovery featuresDiscovery = sharedCommunicationObjects.featuresDiscovery(config);
        if (config.isCiVisibilityEnabled()) {
            featuresDiscovery.discoverIfOutdated();
        }
        if (config.isCiVisibilityEnabled() && (config.isCiVisibilityAgentlessEnabled() || featuresDiscovery.supportsEvpProxy())) {
            this.pendingTraceBuffer = PendingTraceBuffer.discarding();
            this.traceCollectorFactory = new StreamingTraceCollector.Factory(this, this.timeSource, this.healthMetrics);
        } else {
            this.pendingTraceBuffer = strictTraceWrites ? PendingTraceBuffer.discarding() : PendingTraceBuffer.delaying(this.timeSource, config, sharedCommunicationObjects, this.healthMetrics);
            this.traceCollectorFactory = new PendingTrace.Factory(this, this.pendingTraceBuffer, this.timeSource, strictTraceWrites, this.healthMetrics);
        }
        this.pendingTraceBuffer.start();
        sharedCommunicationObjects.whenReady(this.writer::start);
        this.metricsAggregator = NoOpMetricsAggregator.INSTANCE;
        SharedCommunicationObjects sco = sharedCommunicationObjects;
        sharedCommunicationObjects.whenReady(() -> AgentTaskScheduler.get().execute(() -> {
            this.metricsAggregator = MetricsAggregatorFactory.createMetricsAggregator(config, sco, this.healthMetrics);
            AgentTaskScheduler.get().scheduleWithJitter(MetricsAggregator::start, this.metricsAggregator, 1L, TimeUnit.SECONDS);
        }));
        this.dataStreamsMonitoring = dataStreamsMonitoring == null ? new DefaultDataStreamsMonitoring(config, sharedCommunicationObjects, this.timeSource, this::captureTraceConfig) : dataStreamsMonitoring;
        sharedCommunicationObjects.whenReady(this.dataStreamsMonitoring::start);
        HttpCodec.Extractor tracingExtractor = extractor == null ? HttpCodec.createExtractor(config, this::captureTraceConfig) : extractor;
        TracingPropagator tracingPropagator = new TracingPropagator(config.isApmTracingEnabled(), injector, tracingExtractor);
        Propagators.register(AgentPropagation.TRACING_CONCERN, tracingPropagator);
        Propagators.register(AgentPropagation.XRAY_TRACING_CONCERN, new XRayPropagator(config), false);
        if (config.isDataStreamsEnabled()) {
            Propagators.register(AgentPropagation.DSM_CONCERN, this.dataStreamsMonitoring.propagator());
        }
        if (config.isBaggagePropagationEnabled() && config.getTracePropagationBehaviorExtract() != TracePropagationBehaviorExtract.IGNORE) {
            Propagators.register(AgentPropagation.BAGGAGE_CONCERN, new BaggagePropagator(config));
        }
        if (config.isInferredProxyPropagationEnabled()) {
            Propagators.register(AgentPropagation.INFERRED_PROXY_CONCERN, new InferredProxyPropagator());
        }
        if (config.isCiVisibilityEnabled()) {
            if (config.isCiVisibilityTraceSanitationEnabled()) {
                this.addTraceInterceptor((TraceInterceptor)CiVisibilityTraceInterceptor.INSTANCE);
            }
            if (config.isCiVisibilityAgentlessEnabled()) {
                this.addTraceInterceptor((TraceInterceptor)DDIntakeTraceInterceptor.INSTANCE);
            } else {
                featuresDiscovery.discoverIfOutdated();
                if (!featuresDiscovery.supportsEvpProxy()) {
                    this.addTraceInterceptor((TraceInterceptor)CiVisibilityApmProtocolInterceptor.INSTANCE);
                }
            }
            if (config.isCiVisibilityTelemetryEnabled()) {
                this.addTraceInterceptor((TraceInterceptor)new CiVisibilityTelemetryInterceptor());
            }
        }
        if (config.isTraceGitMetadataEnabled()) {
            this.addTraceInterceptor(GitMetadataTraceInterceptor.INSTANCE);
        }
        if (config.isTraceKeepLatencyThresholdEnabled()) {
            this.addTraceInterceptor(LatencyTraceInterceptor.INSTANCE);
        }
        this.instrumentationGateway = instrumentationGateway;
        this.callbackProviderAppSec = instrumentationGateway.getCallbackProvider(RequestContextSlot.APPSEC);
        this.callbackProviderIast = instrumentationGateway.getCallbackProvider(RequestContextSlot.IAST);
        this.universalCallbackProvider = instrumentationGateway.getUniversalCallbackProvider();
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        StatusLogger.logStatus(config);
        this.propagationTagsFactory = PropagationTags.factory(config);
        this.profilingContextIntegration = profilingContextIntegration;
        this.injectBaggageAsTags = injectBaggageAsTags;
        this.flushOnClose = flushOnClose;
        this.allowInferredServices = SpanNaming.instance().namingSchema().allowInferredServices();
        if (profilingContextIntegration != ProfilingContextIntegration.NoOp.INSTANCE) {
            TagMap tmp = TagMap.fromMap(localRootSpanTags);
            tmp.put("_dd.profiling.ctx", (Object)profilingContextIntegration.name());
            this.localRootSpanTags = tmp.freeze();
        } else {
            this.localRootSpanTags = TagMap.fromMapImmutable(localRootSpanTags);
        }
        this.localRootSpanTagsNeedIntercept = this.tagInterceptor.needsIntercept(this.localRootSpanTags);
        if (serviceDiscoveryFactory != null) {
            AgentTaskScheduler.get().schedule(() -> {
                ServiceDiscovery serviceDiscovery = (ServiceDiscovery)serviceDiscoveryFactory.get();
                if (serviceDiscovery != null) {
                    try (TraceScope blackhole = this.muteTracing();){
                        serviceDiscovery.writeTracerMetadata(config);
                    }
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    public void rebuildTraceConfig(Config config) {
        this.dynamicConfig.initial().setTracingEnabled(true).setRuntimeMetricsEnabled(config.isRuntimeMetricsEnabled()).setLogsInjectionEnabled(config.isLogsInjectionEnabled()).setDataStreamsEnabled(config.isDataStreamsEnabled()).setServiceMapping(config.getServiceMapping()).setHeaderTags(config.getRequestHeaderTags()).setBaggageMapping(config.getBaggageMapping()).setTraceSampleRate(config.getTraceSampleRate()).setTracingTags(config.getGlobalTags()).apply();
    }

    protected void finalize() {
        if (null != this.shutdownCallback) {
            try {
                this.shutdownCallback.run();
                Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception e) {
                log.error("Error while finalizing DDTracer.", (Throwable)e);
            }
        }
    }

    public TraceCollector createTraceCollector(DDTraceId id) {
        return this.traceCollectorFactory.create(id);
    }

    TraceCollector createTraceCollector(DDTraceId id, ConfigSnapshot traceConfig) {
        return this.traceCollectorFactory.create(id, traceConfig);
    }

    private void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: {}", (Object)classLoader, (Object)e);
        }
    }

    long getTimeWithNanoTicks(long nanoTicks) {
        long computedNanoTime = this.startTimeNano + Math.max(0L, nanoTicks - this.startNanoTicks);
        if (nanoTicks - this.lastSyncTicks >= this.clockSyncPeriod) {
            long drift = computedNanoTime - this.timeSource.getCurrentTimeNanos();
            if (Math.abs(drift + this.counterDrift) >= 1000000L) {
                this.counterDrift = -TimeUnit.MILLISECONDS.toNanos(TimeUnit.NANOSECONDS.toMillis(drift));
            }
            this.lastSyncTicks = nanoTicks;
        }
        return computedNanoTime + this.counterDrift;
    }

    @Override
    public CoreSpanBuilder buildSpan(String instrumentationName, CharSequence operationName) {
        return this.createMultiSpanBuilder(instrumentationName, operationName);
    }

    MultiSpanBuilder createMultiSpanBuilder(String instrumentationName, CharSequence operationName) {
        return new MultiSpanBuilder(this, instrumentationName, operationName);
    }

    @Override
    public CoreSpanBuilder singleSpanBuilder(String instrumentationName, CharSequence operationName) {
        return SPAN_BUILDER_REUSE_ENABLED ? this.reuseSingleSpanBuilder(instrumentationName, operationName) : this.createMultiSpanBuilder(instrumentationName, operationName);
    }

    ReusableSingleSpanBuilder createSingleSpanBuilder(String instrumentationName, CharSequence oprationName) {
        ReusableSingleSpanBuilder singleSpanBuilder = new ReusableSingleSpanBuilder(this);
        singleSpanBuilder.init(instrumentationName, oprationName);
        return singleSpanBuilder;
    }

    CoreSpanBuilder reuseSingleSpanBuilder(String instrumentationName, CharSequence operationName) {
        return CoreTracer.reuseSingleSpanBuilder(this, this.spanBuilderThreadLocalCache, instrumentationName, operationName);
    }

    static final ReusableSingleSpanBuilder reuseSingleSpanBuilder(CoreTracer tracer, ReusableSingleSpanBuilderThreadLocalCache tlCache, String instrumentationName, CharSequence operationName) {
        if (ThreadUtils.isCurrentThreadVirtual()) {
            return tracer.createSingleSpanBuilder(instrumentationName, operationName);
        }
        ReusableSingleSpanBuilder tlSpanBuilder = (ReusableSingleSpanBuilder)tlCache.get();
        boolean wasReset = tlSpanBuilder.reset(instrumentationName, operationName);
        if (wasReset) {
            return tlSpanBuilder;
        }
        ReusableSingleSpanBuilder newSpanBuilder = tracer.createSingleSpanBuilder(instrumentationName, operationName);
        tlCache.set(newSpanBuilder);
        return newSpanBuilder;
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
        return this.singleSpanBuilder(instrumentationName, spanName).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
        return this.singleSpanBuilder(instrumentationName, spanName).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpanContext parent) {
        return this.singleSpanBuilder(instrumentationName, spanName).ignoreActiveSpan().asChildOf(parent).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpanContext parent, long startTimeMicros) {
        return this.singleSpanBuilder(instrumentationName, spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activateSpan(span);
    }

    @Override
    public AgentScope activateManualSpan(AgentSpan span) {
        return this.scopeManager.activateManualSpan(span);
    }

    @Override
    public void activateSpanWithoutScope(AgentSpan span) {
        this.scopeManager.activateSpan(span);
    }

    @Override
    public AgentScope.Continuation captureActiveSpan() {
        return this.scopeManager.captureActiveSpan();
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span) {
        return this.scopeManager.captureSpan(span);
    }

    public boolean isAsyncPropagationEnabled() {
        return this.scopeManager.isAsyncPropagationEnabled();
    }

    public void setAsyncPropagationEnabled(boolean asyncPropagationEnabled) {
        this.scopeManager.setAsyncPropagationEnabled(asyncPropagationEnabled);
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        this.scopeManager.closePrevious(finishSpan);
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        return this.scopeManager.activateNext(span);
    }

    public TagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public void checkpointActiveForRollback() {
        this.scopeManager.checkpointActiveForRollback();
    }

    @Override
    public void rollbackActiveToCheckpoint() {
        this.scopeManager.rollbackActiveToCheckpoint();
    }

    @Override
    public void closeActive() {
        AgentScope activeScope = this.scopeManager.active();
        if (activeScope != null) {
            activeScope.close();
        }
    }

    @Override
    public AgentSpanContext notifyExtensionStart(Object event) {
        return LambdaHandler.notifyStartInvocation(this, event);
    }

    @Override
    public void notifyExtensionEnd(AgentSpan span, Object result, boolean isError) {
        LambdaHandler.notifyEndInvocation(span, result, isError);
    }

    @Override
    public AgentDataStreamsMonitoring getDataStreamsMonitoring() {
        return this.dataStreamsMonitoring;
    }

    void write(List<DDSpan> trace) {
        boolean published;
        if (trace.isEmpty() || !trace.get(0).traceConfig().isTraceEnabled()) {
            return;
        }
        List<DDSpan> writtenTrace = this.interceptCompleteTrace(trace);
        if (writtenTrace.isEmpty()) {
            return;
        }
        for (DDSpan span : writtenTrace) {
            span.processServiceTags();
        }
        boolean forceKeep = this.metricsAggregator.publish(writtenTrace);
        TraceCollector traceCollector = writtenTrace.get(0).context().getTraceCollector();
        traceCollector.setSamplingPriorityIfNecessary();
        DDSpan rootSpan = traceCollector.getRootSpan();
        DDSpan spanToSample = rootSpan == null ? writtenTrace.get(0) : rootSpan;
        spanToSample.forceKeep(forceKeep);
        boolean bl = published = forceKeep || traceCollector.sample(spanToSample);
        if (published) {
            this.writer.write(writtenTrace);
        } else {
            this.writer.incrementDropCounts(writtenTrace.size());
        }
        if (null != rootSpan) {
            this.onRootSpanFinished(rootSpan, rootSpan.getEndpointTracker());
        }
    }

    private List<DDSpan> interceptCompleteTrace(List<DDSpan> trace) {
        if (!this.interceptors.isEmpty() && !trace.isEmpty()) {
            Collection<DDSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                try {
                    interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
                }
                catch (Throwable e) {
                    String interceptorName = traceInterceptor.getClass().getName();
                    this.rlLog.warn("Throwable raised in TraceInterceptor {}", interceptorName, e);
                }
                if (interceptedTrace != null) continue;
                interceptedTrace = Collections.emptyList();
            }
            trace = new ArrayList<DDSpan>(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                trace.add((DDSpan)mutableSpan);
            }
        }
        return trace;
    }

    public String getTraceId() {
        return this.getTraceId(this.activeSpan());
    }

    public String getSpanId() {
        return this.getSpanId(this.activeSpan());
    }

    @Override
    public String getTraceId(AgentSpan span) {
        if (span != null && span.getTraceId() != null) {
            DDTraceId traceId = span.getTraceId();
            if (this.logs128bTraceIdEnabled && traceId.toHighOrderLong() != 0L) {
                return traceId.toHexString();
            }
            return traceId.toString();
        }
        return "0";
    }

    @Override
    public String getSpanId(AgentSpan span) {
        if (span != null) {
            return DDSpanId.toString((long)span.getSpanId());
        }
        return "0";
    }

    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        if (this.interceptors.add(interceptor)) {
            return true;
        }
        Comparator<TraceInterceptor> interceptorComparator = this.interceptors.comparator();
        if (interceptorComparator != null) {
            TraceInterceptor anotherInterceptor = this.interceptors.stream().filter(i -> interceptorComparator.compare((TraceInterceptor)i, interceptor) == 0).findFirst().orElse(null);
            log.warn("Interceptor {} will NOT be registered with the tracer, as already registered interceptor {} is considered its duplicate", (Object)interceptor, (Object)anotherInterceptor);
        }
        return false;
    }

    public TraceScope muteTracing() {
        return this.activateSpan(this.blackholeSpan());
    }

    public DataStreamsCheckpointer getDataStreamsCheckpointer() {
        return this.dataStreamsMonitoring;
    }

    @Override
    public void addShutdownListener(Runnable listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void addScopeListener(ScopeListener listener) {
        this.scopeManager.addScopeListener(listener);
    }

    @Override
    public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
        return (SubscriptionService)((Object)this.instrumentationGateway.getCallbackProvider(slot));
    }

    @Override
    public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
        if (slot == RequestContextSlot.APPSEC) {
            return this.callbackProviderAppSec;
        }
        if (slot == RequestContextSlot.IAST) {
            return this.callbackProviderIast;
        }
        return CallbackProvider.CallbackProviderNoop.INSTANCE;
    }

    @Override
    public CallbackProvider getUniversalCallbackProvider() {
        return this.universalCallbackProvider;
    }

    @Override
    public void close() {
        for (Runnable shutdownListener : this.shutdownListeners) {
            try {
                shutdownListener.run();
            }
            catch (Exception e) {
                log.error("Error while running shutdown listener", (Throwable)e);
            }
        }
        if (this.flushOnClose) {
            this.flush();
        }
        this.tracingConfigPoller.stop();
        this.pendingTraceBuffer.close();
        this.writer.close();
        RumInjector.shutdownTelemetry();
        this.statsDClient.close();
        this.metricsAggregator.close();
        this.dataStreamsMonitoring.close();
        this.externalAgentLauncher.close();
        this.healthMetrics.close();
    }

    public void addScopeListener(final Runnable afterScopeActivatedCallback, final Runnable afterScopeClosedCallback) {
        this.addScopeListener(new ScopeListener(){

            @Override
            public void afterScopeActivated() {
                afterScopeActivatedCallback.run();
            }

            @Override
            public void afterScopeClosed() {
                afterScopeClosedCallback.run();
            }
        });
    }

    public void flush() {
        this.pendingTraceBuffer.flush();
        this.writer.flush();
    }

    public void flushMetrics() {
        try {
            this.metricsAggregator.forceReport().get(2500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.debug("Failed to wait for metrics flush.", (Throwable)e);
        }
    }

    @Override
    public ProfilingContextIntegration getProfilingContext() {
        return this.profilingContextIntegration;
    }

    public TraceSegment getTraceSegment() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan == null) {
            return null;
        }
        AgentSpanContext ctx = activeSpan.context();
        if (ctx instanceof DDSpanContext) {
            return ((DDSpanContext)ctx).getTraceSegment();
        }
        return null;
    }

    @Override
    public void addReportToFlare(ZipOutputStream zip) throws IOException {
        TracerFlare.addText(zip, "dynamic_config.txt", this.dynamicConfig.toString());
        TracerFlare.addText(zip, "tracer_health.txt", this.healthMetrics.summary());
        TracerFlare.addText(zip, "span_metrics.txt", SpanMetricRegistry.getInstance().summary());
    }

    private static StatsDClient createStatsDClient(Config config) {
        Integer port;
        if (!config.isHealthMetricsEnabled()) {
            return StatsDClient.NO_OP;
        }
        String host = config.getHealthMetricsStatsdHost();
        if (host == null) {
            host = config.getJmxFetchStatsdHost();
        }
        if ((port = config.getHealthMetricsStatsdPort()) == null) {
            port = config.getJmxFetchStatsdPort();
        }
        return DDAgentStatsDClientManager.statsDClientManager().statsDClient(host, port, config.getDogStatsDNamedPipe(), "datadog:tracer".replace(':', '.'), CoreTracer.generateConstantTags(config));
    }

    private static String[] generateConstantTags(Config config) {
        String env;
        ArrayList<String> constantTags = new ArrayList<String>();
        constantTags.add(CoreTracer.statsdTag(LANG_STATSD_TAG, "java"));
        constantTags.add(CoreTracer.statsdTag(LANG_VERSION_STATSD_TAG, DDTraceCoreInfo.JAVA_VERSION));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_NAME));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_VENDOR_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_VENDOR));
        constantTags.add(CoreTracer.statsdTag(TRACER_VERSION_STATSD_TAG, DDTraceCoreInfo.VERSION));
        constantTags.add(CoreTracer.statsdTag("service", config.getServiceName()));
        Map<String, String> mergedSpanTags = config.getMergedSpanTags();
        String version = mergedSpanTags.get("version");
        if (version != null && !version.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("version", version));
        }
        if ((env = mergedSpanTags.get("env")) != null && !env.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("env", env));
        }
        return constantTags.toArray(new String[0]);
    }

    Recording writeTimer() {
        return this.traceWriteTimer.start();
    }

    private static String statsdTag(String tagPrefix, String tagValue) {
        return tagPrefix + ":" + tagValue;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        HashMap<V, K> inverted = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(inverted);
    }

    static TagMap withTracerTags(Map<String, ?> userSpanTags, Config config, TraceConfig traceConfig) {
        TagMap result = TagMap.create(userSpanTags.size() + 5);
        result.putAll((Map<? extends String, ? extends Object>)userSpanTags);
        if (null != config) {
            if (!config.getEnv().isEmpty()) {
                result.put("env", (Object)config.getEnv());
            }
            if (!config.getVersion().isEmpty()) {
                result.put("version", (Object)config.getVersion());
            }
            if (config.isDataJobsEnabled()) {
                result.put("_dd.djm.enabled", (Object)1);
            }
            if (config.isDataStreamsEnabled()) {
                result.put("_dd.dsm.enabled", (Object)1);
            }
        }
        if (null != traceConfig) {
            if (traceConfig.isDataStreamsEnabled()) {
                result.put("_dd.dsm.enabled", (Object)1);
            } else {
                result.remove("_dd.dsm.enabled");
            }
        }
        return result.freeze();
    }

    protected class ConfigSnapshot
    extends DynamicConfig.Snapshot {
        final Sampler sampler;
        final TagMap mergedTracerTags;
        final boolean mergedTracerTagsNeedsIntercept;

        protected ConfigSnapshot(DynamicConfig.Builder builder, ConfigSnapshot oldSnapshot) {
            super(builder, oldSnapshot);
            this.sampler = null == oldSnapshot ? CoreTracer.this.initialSampler : (Objects.equals(this.getTraceSampleRate(), oldSnapshot.getTraceSampleRate()) && Objects.equals(this.getTraceSamplingRules(), oldSnapshot.getTraceSamplingRules()) ? oldSnapshot.sampler : Sampler.Builder.forConfig(CoreTracer.this.initialConfig, this));
            if (null == oldSnapshot) {
                this.mergedTracerTags = CoreTracer.this.defaultSpanTags.immutableCopy();
                this.mergedTracerTagsNeedsIntercept = CoreTracer.this.defaultSpanTagsNeedsIntercept;
            } else if (this.getTracingTags().equals(oldSnapshot.getTracingTags())) {
                this.mergedTracerTags = oldSnapshot.mergedTracerTags;
                this.mergedTracerTagsNeedsIntercept = oldSnapshot.mergedTracerTagsNeedsIntercept;
            } else {
                this.mergedTracerTags = CoreTracer.withTracerTags(this.getTracingTags(), CoreTracer.this.initialConfig, this);
                this.mergedTracerTagsNeedsIntercept = CoreTracer.this.tagInterceptor.needsIntercept(this.mergedTracerTags);
            }
        }
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super(AgentThreadFactory.AGENT_THREAD_GROUP, "dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    static final class ReusableSingleSpanBuilder
    extends CoreSpanBuilder {
        boolean inUse = false;

        ReusableSingleSpanBuilder(CoreTracer tracer) {
            super(tracer);
        }

        void init(String instrumentationName, CharSequence operationName) {
            assert (!this.inUse);
            this.instrumentationName = instrumentationName;
            this.operationName = operationName;
            this.inUse = true;
        }

        final boolean reset(String instrumentationName, CharSequence operationName) {
            if (this.inUse) {
                return false;
            }
            this.inUse = true;
            this.instrumentationName = instrumentationName;
            this.operationName = operationName;
            if (this.tagLedger != null) {
                this.tagLedger.reset();
            }
            this.timestampMicro = 0L;
            this.parent = null;
            this.serviceName = null;
            this.resourceName = null;
            this.errorFlag = false;
            this.spanType = null;
            this.ignoreScope = false;
            this.builderRequestContextDataAppSec = null;
            this.builderRequestContextDataIast = null;
            this.builderCiVisibilityContextData = null;
            this.links = null;
            this.spanId = 0L;
            return true;
        }

        @Override
        public AgentSpan start() {
            assert (this.inUse) : "ReusableSingleSpanBuilder not reset properly -- multiple span construction?";
            AgentSpan span = this.startImpl();
            this.inUse = false;
            return span;
        }
    }

    static final class ReusableSingleSpanBuilderThreadLocalCache
    extends ThreadLocal<ReusableSingleSpanBuilder> {
        private final CoreTracer tracer;

        public ReusableSingleSpanBuilderThreadLocalCache(CoreTracer tracer) {
            this.tracer = tracer;
        }

        @Override
        protected ReusableSingleSpanBuilder initialValue() {
            return new ReusableSingleSpanBuilder(this.tracer);
        }
    }

    static final class MultiSpanBuilder
    extends CoreSpanBuilder {
        MultiSpanBuilder(CoreTracer tracer, String instrumentationName, CharSequence operationName) {
            super(tracer);
            this.instrumentationName = instrumentationName;
            this.operationName = operationName;
        }

        @Override
        public AgentSpan start() {
            return this.startImpl();
        }
    }

    public static abstract class CoreSpanBuilder
    implements AgentTracer.SpanBuilder {
        protected final CoreTracer tracer;
        protected String instrumentationName;
        protected CharSequence operationName;
        protected TagMap.Ledger tagLedger;
        protected long timestampMicro;
        protected AgentSpanContext parent;
        protected String serviceName;
        protected String resourceName;
        protected boolean errorFlag;
        protected CharSequence spanType;
        protected boolean ignoreScope = false;
        protected Object builderRequestContextDataAppSec;
        protected Object builderRequestContextDataIast;
        protected Object builderCiVisibilityContextData;
        protected List<AgentSpanLink> links;
        protected long spanId;

        CoreSpanBuilder(CoreTracer tracer) {
            this.tracer = tracer;
        }

        @Override
        public final CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        protected final DDSpan buildSpan() {
            EndpointTracker tracker;
            DDSpan span = DDSpan.create(this.instrumentationName, this.timestampMicro, this.buildSpanContext(), this.links);
            if (span.isLocalRootSpan() && (tracker = this.tracer.onRootSpanStarted(span)) != null) {
                span.setEndpointTracker(tracker);
            }
            return span;
        }

        private final void addParentContextAsLinks(AgentSpanContext parentContext) {
            SpanLink link;
            if (parentContext instanceof ExtractedContext) {
                String headers = ((ExtractedContext)parentContext).getPropagationStyle().toString();
                SpanAttributes attributes = SpanAttributes.builder().put("reason", "propagation_behavior_extract").put("context_headers", headers).build();
                link = DDSpanLink.from((ExtractedContext)parentContext, attributes);
            } else {
                link = SpanLink.from(parentContext);
            }
            this.withLink(link);
        }

        private final void addTerminatedContextAsLinks() {
            List<AgentSpanLink> terminatedContextLinks;
            if (this.parent instanceof TagContext && !(terminatedContextLinks = ((TagContext)this.parent).getTerminatedContextLinks()).isEmpty()) {
                if (this.links == null) {
                    this.links = new ArrayList<AgentSpanLink>();
                }
                this.links.addAll(terminatedContextLinks);
            }
        }

        @Override
        public abstract AgentSpan start();

        protected AgentSpan startImpl() {
            AgentSpan span;
            AgentSpanContext pc = this.parent;
            if (pc == null && !this.ignoreScope && (span = this.tracer.activeSpan()) != null) {
                pc = span.context();
            }
            if (pc == BlackHoleSpan.Context.INSTANCE) {
                return new BlackHoleSpan(pc.getTraceId());
            }
            return this.buildSpan();
        }

        @Override
        public final CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        @Override
        public final CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)(string == null || string.isEmpty() ? null : string));
        }

        @Override
        public final CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        @Override
        public final CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        @Override
        public final CoreSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public final CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        @Override
        public final CoreSpanBuilder withSpanType(CharSequence spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public final CoreSpanBuilder asChildOf(AgentSpanContext spanContext) {
            this.parent = spanContext;
            return this;
        }

        public final CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        @Override
        public final CoreSpanBuilder withTag(String tag, Object value) {
            if (tag == null) {
                return this;
            }
            TagMap.Ledger tagLedger = this.tagLedger;
            if (tagLedger == null) {
                this.tagLedger = tagLedger = TagMap.ledger();
            }
            if (value == null) {
                tagLedger.smartRemove(tag);
            } else {
                tagLedger.set(tag, value);
            }
            return this;
        }

        @Override
        public final <T> AgentTracer.SpanBuilder withRequestContextData(RequestContextSlot slot, T data) {
            switch (slot) {
                case APPSEC: {
                    this.builderRequestContextDataAppSec = data;
                    break;
                }
                case CI_VISIBILITY: {
                    this.builderCiVisibilityContextData = data;
                    break;
                }
                case IAST: {
                    this.builderRequestContextDataIast = data;
                }
            }
            return this;
        }

        @Override
        public final AgentTracer.SpanBuilder withLink(AgentSpanLink link) {
            if (link != null) {
                if (this.links == null) {
                    this.links = new ArrayList<AgentSpanLink>();
                }
                this.links.add(link);
            }
            return this;
        }

        @Override
        public final CoreSpanBuilder withSpanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        private final DDSpanContext buildSpanContext() {
            ClassloaderConfigurationOverrides.ContextualInfo contextualInfo;
            PathwayContext pathwayContext;
            PropagationTags propagationTags;
            Object ciVisibilityContextData;
            Object requestContextDataIast;
            Object requestContextDataAppSec;
            boolean rootSpanTagsNeedsIntercept;
            TagMap rootSpanTags;
            boolean coreTagsNeedsIntercept;
            TagMap coreTags;
            CharSequence origin;
            int samplingPriority;
            TraceCollector parentTraceCollector;
            Baggage w3cBaggage;
            Map<String, String> baggage;
            long parentSpanId;
            DDTraceId traceId;
            AgentSpan activeSpan;
            long spanId = this.spanId == 0L ? this.tracer.idGenerationStrategy.generateSpanId() : this.spanId;
            AgentSpanContext parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = this.tracer.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            if (parentContext != null && parentContext.isRemote()) {
                switch (Config.get().getTracePropagationBehaviorExtract()) {
                    case RESTART: {
                        this.addParentContextAsLinks(parentContext);
                        parentContext = null;
                        break;
                    }
                    case IGNORE: {
                        parentContext = null;
                        break;
                    }
                    default: {
                        this.addTerminatedContextAsLinks();
                    }
                }
            }
            String parentServiceName = null;
            if (parentContext instanceof DDSpanContext) {
                RequestContext requestContext;
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                w3cBaggage = null;
                parentTraceCollector = ddsc.getTraceCollector();
                samplingPriority = -128;
                origin = null;
                coreTags = null;
                coreTagsNeedsIntercept = false;
                rootSpanTags = null;
                rootSpanTagsNeedsIntercept = false;
                parentServiceName = ddsc.getServiceName();
                if (this.serviceName == null) {
                    this.serviceName = parentServiceName;
                }
                if ((requestContext = ((DDSpanContext)parentContext).getRequestContext()) != null) {
                    requestContextDataAppSec = requestContext.getData(RequestContextSlot.APPSEC);
                    requestContextDataIast = requestContext.getData(RequestContextSlot.IAST);
                    ciVisibilityContextData = requestContext.getData(RequestContextSlot.CI_VISIBILITY);
                } else {
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                    ciVisibilityContextData = null;
                }
                propagationTags = this.tracer.propagationTagsFactory.empty();
            } else {
                ConfigSnapshot traceConfig;
                long endToEndStartTime;
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    endToEndStartTime = extractedContext.getEndToEndStartTime();
                    propagationTags = extractedContext.getPropagationTags();
                } else if (parentContext != null) {
                    traceId = parentContext.getTraceId() == DDTraceId.ZERO ? this.tracer.idGenerationStrategy.generateTraceId() : parentContext.getTraceId();
                    parentSpanId = parentContext.getSpanId();
                    samplingPriority = parentContext.getSamplingPriority();
                    endToEndStartTime = 0L;
                    propagationTags = this.tracer.propagationTagsFactory.empty();
                } else {
                    traceId = this.tracer.idGenerationStrategy.generateTraceId();
                    parentSpanId = 0L;
                    samplingPriority = -128;
                    endToEndStartTime = 0L;
                    propagationTags = this.tracer.propagationTagsFactory.empty();
                }
                if (parentContext instanceof TagContext) {
                    TagContext tc = (TagContext)parentContext;
                    traceConfig = (ConfigSnapshot)tc.getTraceConfig();
                    coreTags = tc.getTags();
                    coreTagsNeedsIntercept = true;
                    origin = tc.getOrigin();
                    baggage = tc.getBaggage();
                    w3cBaggage = tc.getW3CBaggage();
                    requestContextDataAppSec = tc.getRequestContextDataAppSec();
                    requestContextDataIast = tc.getRequestContextDataIast();
                    ciVisibilityContextData = tc.getCiVisibilityContextData();
                } else {
                    traceConfig = null;
                    coreTags = null;
                    coreTagsNeedsIntercept = false;
                    origin = null;
                    baggage = null;
                    w3cBaggage = null;
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                    ciVisibilityContextData = null;
                }
                rootSpanTags = this.tracer.localRootSpanTags;
                rootSpanTagsNeedsIntercept = this.tracer.localRootSpanTagsNeedIntercept;
                parentTraceCollector = this.tracer.createTraceCollector(traceId, traceConfig);
                if (endToEndStartTime > 0L) {
                    parentTraceCollector.beginEndToEnd(endToEndStartTime);
                }
            }
            ConfigSnapshot traceConfig = parentTraceCollector.getTraceConfig();
            PathwayContext pathwayContext2 = pathwayContext = parentContext != null && parentContext.getPathwayContext() != null && parentContext.getPathwayContext().isStarted() ? parentContext.getPathwayContext() : this.tracer.dataStreamsMonitoring.newPathwayContext();
            if (!this.tracer.allowInferredServices) {
                DDSpan rootSpan = parentTraceCollector.getRootSpan();
                String string = this.serviceName = rootSpan != null ? rootSpan.getServiceName() : null;
            }
            if (this.serviceName == null) {
                this.serviceName = traceConfig.getPreferredServiceName();
            }
            Map<String, Object> contextualTags = null;
            if (parentServiceName == null && (contextualInfo = ClassloaderConfigurationOverrides.maybeGetContextualInfo()) != null) {
                if (this.serviceName == null) {
                    this.serviceName = contextualInfo.getServiceName();
                }
                contextualTags = contextualInfo.getTags();
            }
            if (this.serviceName == null) {
                this.serviceName = this.tracer.serviceName;
            }
            CharSequence operationName = this.operationName != null ? this.operationName : this.resourceName;
            TagMap mergedTracerTags = traceConfig.mergedTracerTags;
            boolean mergedTracerTagsNeedsIntercept = traceConfig.mergedTracerTagsNeedsIntercept;
            int tagsSize = mergedTracerTags.size() + (null == this.tagLedger ? 0 : this.tagLedger.estimateSize()) + (null == coreTags ? 0 : coreTags.size()) + (null == rootSpanTags ? 0 : rootSpanTags.size()) + (null == contextualTags ? 0 : contextualTags.size());
            if (this.builderRequestContextDataAppSec != null) {
                requestContextDataAppSec = this.builderRequestContextDataAppSec;
            }
            if (this.builderCiVisibilityContextData != null) {
                ciVisibilityContextData = this.builderCiVisibilityContextData;
            }
            if (this.builderRequestContextDataIast != null) {
                requestContextDataIast = this.builderRequestContextDataIast;
            }
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, parentServiceName, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, w3cBaggage, this.errorFlag, this.spanType, tagsSize, parentTraceCollector, requestContextDataAppSec, requestContextDataIast, ciVisibilityContextData, pathwayContext, this.tracer.disableSamplingMechanismValidation, propagationTags, this.tracer.profilingContextIntegration, this.tracer.injectBaggageAsTags);
            context.setAllTags(mergedTracerTags, mergedTracerTagsNeedsIntercept);
            context.setAllTags(this.tagLedger);
            context.setAllTags(coreTags, coreTagsNeedsIntercept);
            context.setAllTags(rootSpanTags, rootSpanTagsNeedsIntercept);
            context.setAllTags(contextualTags);
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private SharedCommunicationObjects sharedCommunicationObjects;
        private Writer writer;
        private IdGenerationStrategy idGenerationStrategy;
        private Sampler sampler;
        private SingleSpanSampler singleSpanSampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private TagMap localRootSpanTags;
        private TagMap defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private Map<String, String> baggageMapping;
        private int partialFlushMinSpans;
        private StatsDClient statsDClient;
        private HealthMetrics healthMetrics;
        private TagInterceptor tagInterceptor;
        private boolean strictTraceWrites;
        private InstrumentationGateway instrumentationGateway;
        private ServiceDiscoveryFactory serviceDiscoveryFactory;
        private TimeSource timeSource;
        private DataStreamsMonitoring dataStreamsMonitoring;
        private ProfilingContextIntegration profilingContextIntegration = ProfilingContextIntegration.NoOp.INSTANCE;
        private boolean reportInTracerFlare;
        private boolean pollForTracingConfiguration;
        private boolean injectBaggageAsTags;
        private boolean flushOnClose;

        public CoreTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreTracerBuilder sharedCommunicationObjects(SharedCommunicationObjects sharedCommunicationObjects) {
            this.sharedCommunicationObjects = sharedCommunicationObjects;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder idGenerationStrategy(IdGenerationStrategy idGenerationStrategy) {
            this.idGenerationStrategy = idGenerationStrategy;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder singleSpanSampler(SingleSpanSampler singleSpanSampler) {
            this.singleSpanSampler = singleSpanSampler;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, ?> localRootSpanTags) {
            this.localRootSpanTags = TagMap.fromMapImmutable(localRootSpanTags);
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(TagMap tagMap) {
            this.localRootSpanTags = tagMap.immutableCopy();
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, ?> defaultSpanTags) {
            this.defaultSpanTags = TagMap.fromMapImmutable(defaultSpanTags);
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(TagMap defaultSpanTags) {
            this.defaultSpanTags = defaultSpanTags.immutableCopy();
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = CollectionUtils.tryMakeImmutableMap(serviceNameMappings);
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = CollectionUtils.tryMakeImmutableMap(taggedHeaders);
            return this;
        }

        public CoreTracerBuilder baggageMapping(Map<String, String> baggageMapping) {
            this.baggageMapping = CollectionUtils.tryMakeImmutableMap(baggageMapping);
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracerBuilder statsDClient(StatsDClient statsDClient) {
            this.statsDClient = statsDClient;
            return this;
        }

        public CoreTracerBuilder tagInterceptor(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder healthMetrics(HealthMetrics healthMetrics) {
            this.healthMetrics = healthMetrics;
            return this;
        }

        public CoreTracerBuilder strictTraceWrites(boolean strictTraceWrites) {
            this.strictTraceWrites = strictTraceWrites;
            return this;
        }

        public CoreTracerBuilder instrumentationGateway(InstrumentationGateway instrumentationGateway) {
            this.instrumentationGateway = instrumentationGateway;
            return this;
        }

        public CoreTracerBuilder serviceDiscoveryFactory(ServiceDiscoveryFactory serviceDiscoveryFactory) {
            this.serviceDiscoveryFactory = serviceDiscoveryFactory;
            return this;
        }

        public CoreTracerBuilder timeSource(TimeSource timeSource) {
            this.timeSource = timeSource;
            return this;
        }

        public CoreTracerBuilder dataStreamsMonitoring(DataStreamsMonitoring dataStreamsMonitoring) {
            this.dataStreamsMonitoring = dataStreamsMonitoring;
            return this;
        }

        public CoreTracerBuilder profilingContextIntegration(ProfilingContextIntegration profilingContextIntegration) {
            this.profilingContextIntegration = profilingContextIntegration;
            return this;
        }

        public CoreTracerBuilder reportInTracerFlare() {
            this.reportInTracerFlare = true;
            return this;
        }

        public CoreTracerBuilder pollForTracingConfiguration() {
            this.pollForTracingConfiguration = true;
            return this;
        }

        public CoreTracerBuilder injectBaggageAsTags(boolean injectBaggageAsTags) {
            this.injectBaggageAsTags = injectBaggageAsTags;
            return this;
        }

        public CoreTracerBuilder flushOnClose(boolean flushOnClose) {
            this.flushOnClose = flushOnClose;
            return this;
        }

        public CoreTracerBuilder() {
            this.config(Config.get());
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config, null));
            this.singleSpanSampler(SingleSpanSampler.Builder.forConfig(config));
            this.instrumentationGateway(new InstrumentationGateway());
            this.injector(HttpCodec.createInjector(config, config.getTracePropagationStylesToInject(), CoreTracer.invertMap(config.getBaggageMapping())));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(CoreTracer.withTracerTags(config.getMergedSpanTags(), config, null));
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getRequestHeaderTags());
            this.baggageMapping(config.getBaggageMapping());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            this.strictTraceWrites(config.isTraceStrictWritesEnabled());
            this.injectBaggageAsTags(config.isInjectBaggageAsTagsEnabled());
            this.flushOnClose(config.isCiVisibilityEnabled());
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.sharedCommunicationObjects, this.writer, this.idGenerationStrategy, this.sampler, this.singleSpanSampler, this.injector, this.extractor, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.baggageMapping, this.partialFlushMinSpans, this.statsDClient, this.healthMetrics, this.tagInterceptor, this.strictTraceWrites, this.instrumentationGateway, this.serviceDiscoveryFactory, this.timeSource, this.dataStreamsMonitoring, this.profilingContextIntegration, this.reportInTracerFlare, this.pollForTracingConfiguration, this.injectBaggageAsTags, this.flushOnClose);
        }
    }
}

