/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.trace.api.datastreams.Backlog;
import ddtrot.dd.trace.api.datastreams.DataStreamsTags;
import ddtrot.dd.trace.api.datastreams.SchemaRegistryUsage;
import ddtrot.dd.trace.api.datastreams.StatsPoint;
import ddtrot.dd.trace.core.datastreams.StatsGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StatsBucket {
    private final long startTimeNanos;
    private final long bucketDurationNanos;
    private final Map<Long, StatsGroup> hashToGroup = new HashMap<Long, StatsGroup>();
    private final Map<DataStreamsTags, Long> backlogs = new HashMap<DataStreamsTags, Long>();
    private final Map<SchemaKey, Long> schemaRegistryUsages = new HashMap<SchemaKey, Long>();

    public StatsBucket(long startTimeNanos, long bucketDurationNanos) {
        this.startTimeNanos = startTimeNanos;
        this.bucketDurationNanos = bucketDurationNanos;
    }

    public void addPoint(StatsPoint statsPoint) {
        this.hashToGroup.computeIfAbsent(statsPoint.getAggregationHash(), hash -> new StatsGroup(statsPoint.getTags(), statsPoint.getHash(), statsPoint.getParentHash())).add(statsPoint.getPathwayLatencyNano(), statsPoint.getEdgeLatencyNano(), statsPoint.getPayloadSizeBytes());
    }

    public void addBacklog(Backlog backlog) {
        this.backlogs.compute(backlog.getTags(), (k, v) -> v == null ? backlog.getValue() : Math.max(v, backlog.getValue()));
    }

    public void addSchemaRegistryUsage(SchemaRegistryUsage usage) {
        SchemaKey key = new SchemaKey(usage.getTopic(), usage.getClusterId(), usage.getSchemaId(), usage.isSuccess(), usage.isKey(), usage.getOperation());
        this.schemaRegistryUsages.merge(key, 1L, Long::sum);
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getBucketDurationNanos() {
        return this.bucketDurationNanos;
    }

    public Collection<StatsGroup> getGroups() {
        return this.hashToGroup.values();
    }

    public Collection<Map.Entry<DataStreamsTags, Long>> getBacklogs() {
        return this.backlogs.entrySet();
    }

    public Collection<Map.Entry<SchemaKey, Long>> getSchemaRegistryUsages() {
        return this.schemaRegistryUsages.entrySet();
    }

    public static class SchemaKey {
        private final String topic;
        private final String clusterId;
        private final int schemaId;
        private final boolean isSuccess;
        private final boolean isKey;
        private final String operation;

        public SchemaKey(String topic, String clusterId, int schemaId, boolean isSuccess, boolean isKey, String operation) {
            this.topic = topic;
            this.clusterId = clusterId;
            this.schemaId = schemaId;
            this.isSuccess = isSuccess;
            this.isKey = isKey;
            this.operation = operation;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public int getSchemaId() {
            return this.schemaId;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public boolean isKey() {
            return this.isKey;
        }

        public String getOperation() {
            return this.operation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaKey that = (SchemaKey)o;
            return this.schemaId == that.schemaId && this.isSuccess == that.isSuccess && this.isKey == that.isKey && Objects.equals(this.topic, that.topic) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.operation, that.operation);
        }

        public int hashCode() {
            int result = this.topic != null ? this.topic.hashCode() : 0;
            result = 31 * result + (this.clusterId != null ? this.clusterId.hashCode() : 0);
            result = 31 * result + this.schemaId;
            result = 31 * result + (this.isSuccess ? 1 : 0);
            result = 31 * result + (this.isKey ? 1 : 0);
            result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
            return result;
        }
    }
}

