/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.Config;
import datadog.trace.api.TagMap;
import ddtrot.dd.trace.api.naming.NamingSchema;
import ddtrot.dd.trace.api.naming.SpanNaming;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class PeerServiceCalculator
extends TagsPostProcessor {
    private final NamingSchema.ForPeerService peerServiceNaming;
    private final Map<String, String> peerServiceMapping;
    private final boolean canRemap;

    public PeerServiceCalculator() {
        this(SpanNaming.instance().namingSchema().peerService(), Config.get().getPeerServiceMapping());
    }

    PeerServiceCalculator(@Nonnull NamingSchema.ForPeerService peerServiceNaming, @Nonnull Map<String, String> peerServiceMapping) {
        this.peerServiceNaming = peerServiceNaming;
        this.peerServiceMapping = peerServiceMapping;
        this.canRemap = !peerServiceMapping.isEmpty();
    }

    @Override
    public void processTags(TagMap unsafeTags, DDSpanContext spanContext, List<AgentSpanLink> spanLinks) {
        Object peerService = unsafeTags.getObject("peer.service");
        if (peerService != null) {
            if (this.canRemap) {
                this.remapPeerService(unsafeTags, peerService);
                return;
            }
        } else if (this.peerServiceNaming.supports()) {
            this.peerServiceNaming.tags(unsafeTags);
            this.remapPeerService(unsafeTags, this.canRemap ? unsafeTags.getObject("peer.service") : null);
            return;
        }
    }

    private void remapPeerService(TagMap unsafeTags, Object value) {
        String mapped;
        if (value != null && (mapped = this.peerServiceMapping.get(value)) != null) {
            unsafeTags.put("peer.service", (Object)mapped);
            unsafeTags.put("_dd.peer.service.remapped_from", value);
        }
    }
}

