/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.TagMap;
import ddtrot.com.google.re2j.Matcher;
import ddtrot.com.google.re2j.Pattern;
import ddtrot.com.google.re2j.PatternSyntaxException;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import ddtrot.dd.trace.util.Strings;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryObfuscator
extends TagsPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryObfuscator.class);
    private static final String DEFAULT_OBFUSCATION_PATTERN = "(?i)(?:(?:\"|%22)?)(?:(?:old[-_]?|new[-_]?)?p(?:ass)?w(?:or)?d(?:1|2)?|pass(?:[-_]?phrase)?|secret|(?:api[-_]?|private[-_]?|public[-_]?|access[-_]?|secret[-_]?|app(?:lication)?[-_]?)key(?:[-_]?id)?|token|consumer[-_]?(?:id|key|secret)|sign(?:ed|ature)?|auth(?:entication|orization)?)(?:(?:\\s|%20)*(?:=|%3D)[^&]+|(?:\"|%22)(?:\\s|%20)*(?::|%3A)(?:\\s|%20)*(?:\"|%22)(?:%2[^2]|%[^2]|[^\"%])+(?:\"|%22))|(?:bearer(?:\\s|%20)+[a-z0-9._\\-]+|token(?::|%3A)[a-z0-9]{13}|gh[opsu]_[0-9a-zA-Z]{36}|ey[I-L](?:[\\w=-]|%3D)+\\.ey[I-L](?:[\\w=-]|%3D)+(?:\\.(?:[\\w.+/=-]|%3D|%2F|%2B)+)?|-{5}BEGIN(?:[a-z\\s]|%20)+PRIVATE(?:\\s|%20)KEY-{5}[^\\-]+-{5}END(?:[a-z\\s]|%20)+PRIVATE(?:\\s|%20)KEY(?:-{5})?(?:\\n|%0A)?|(?:ssh-(?:rsa|dss)|ecdsa-[a-z0-9]+-[a-z0-9]+)(?:\\s|%20|%09)+(?:[a-z0-9/.+]|%2F|%5C|%2B){100,}(?:=|%3D)*(?:(?:\\s|%20|%09)+[a-z0-9._-]+)?)";
    private final Pattern pattern;

    public QueryObfuscator(String regex) {
        if ("".equals(regex)) {
            this.pattern = null;
            return;
        }
        if (regex == null) {
            regex = DEFAULT_OBFUSCATION_PATTERN;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            log.error("Could not compile given query obfuscation regex: {}", (Object)regex, (Object)e);
        }
        this.pattern = pattern;
    }

    private String obfuscate(String query) {
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(query);
            while (matcher.find()) {
                query = Strings.replace(query, matcher.group(), "<redacted>");
            }
        }
        return query;
    }

    @Override
    public void processTags(TagMap unsafeTags, DDSpanContext spanContext, List<AgentSpanLink> spanLinks) {
        Object query = unsafeTags.getObject("http.query.string");
        if (query instanceof CharSequence) {
            query = this.obfuscate(query.toString());
            unsafeTags.put("http.query.string", query);
            Object url = unsafeTags.getObject("http.url");
            if (url instanceof CharSequence) {
                unsafeTags.put("http.url", (Object)(url + "?" + query));
            }
        }
    }
}

