/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api.java.lang;

import ddtrot.dd.trace.bootstrap.ActiveSubsystems;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;

public class ProcessImplInstrumentationHelpers {
    private static final int LIMIT = 4096;
    public static final boolean ONLINE;
    private static final MethodHandle PROCESS_ON_EXIT;
    private static final Executor EXECUTOR;
    private static final Pattern REDACTED_PARAM_PAT;
    private static final Set<String> REDACTED_BINARIES;

    private ProcessImplInstrumentationHelpers() {
    }

    public static Map<String, String> createTags(String[] origCommand) {
        String[] command = !ActiveSubsystems.APPSEC_ACTIVE ? new String[]{origCommand[0]} : origCommand;
        command = ProcessImplInstrumentationHelpers.redact(command);
        HashMap<String, String> ret = new HashMap<String, String>(4);
        StringBuilder sb = new StringBuilder("[");
        long remaining = 4096L;
        for (int i = 0; i < command.length; ++i) {
            String cur = command[i];
            if ((remaining -= (long)cur.length()) < 0L) {
                ret.put("cmd.truncated", "true");
                break;
            }
            if (i != 0) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(cur.replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append('\"');
        }
        sb.append("]");
        ret.put("cmd.exec", sb.toString());
        return ret;
    }

    private static String[] redact(String[] command) {
        if (command.length == 0) {
            return command;
        }
        String[] newCommand = null;
        if (REDACTED_BINARIES.contains(ProcessImplInstrumentationHelpers.determineResource(command))) {
            newCommand = new String[command.length];
            newCommand[0] = command[0];
            for (int i = 1; i < command.length; ++i) {
                newCommand[i] = "?";
            }
            return newCommand;
        }
        boolean redactNext = false;
        for (int i = 1; i < command.length; ++i) {
            if (redactNext) {
                if (newCommand == null) {
                    newCommand = new String[command.length];
                    System.arraycopy(command, 0, newCommand, 0, command.length);
                }
                newCommand[i] = "?";
                redactNext = false;
                continue;
            }
            String s = command[i];
            if (s == null) continue;
            int posEqual = s.indexOf(61);
            if (posEqual == -1) {
                if (!REDACTED_PARAM_PAT.matcher(s).matches()) continue;
                redactNext = true;
                continue;
            }
            String param = s.substring(0, posEqual);
            if (!REDACTED_PARAM_PAT.matcher(param).matches()) continue;
            if (newCommand == null) {
                newCommand = new String[command.length];
                System.arraycopy(command, 0, newCommand, 0, command.length);
            }
            newCommand[i] = param + "=?";
        }
        return newCommand != null ? newCommand : command;
    }

    public static void addProcessCompletionHook(Process p, AgentSpan span) {
        if (PROCESS_ON_EXIT != null) {
            CompletableFuture future;
            try {
                future = PROCESS_ON_EXIT.invokeExact(p);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new UndeclaredThrowableException(e);
            }
            future.whenComplete((process, thr) -> {
                if (thr != null) {
                    span.setError(true);
                    span.setErrorMessage(thr.getMessage());
                } else {
                    span.setTag("cmd.exit_code", process.exitValue());
                }
                span.finish();
            });
        } else if (EXECUTOR != null) {
            EXECUTOR.execute(() -> {
                try {
                    int exitCode = p.waitFor();
                    span.setTag("cmd.exit_code", exitCode);
                }
                catch (InterruptedException e) {
                    span.setError(true);
                    span.setErrorMessage(e.getMessage());
                }
                span.finish();
            });
        }
    }

    public static CharSequence determineResource(String[] command) {
        String first = command[0];
        int pos = first.lastIndexOf(47);
        if (pos == -1 || pos == first.length() - 1) {
            return first;
        }
        return first.substring(pos + 1);
    }

    static {
        REDACTED_PARAM_PAT = Pattern.compile("^(?i)-{0,2}(?:p(?:ass(?:w(?:or)?d)?)?|api_?key|secret|a(?:ccess|uth)_token|mysql_pwd|credentials|(?:stripe)?token)$");
        REDACTED_BINARIES = Collections.singleton("md5");
        MethodHandle processOnExit = null;
        Executor executor = null;
        try {
            processOnExit = MethodHandles.publicLookup().findVirtual(Process.class, "onExit", MethodType.methodType(CompletableFuture.class));
        }
        catch (Throwable e) {
            try {
                Class<?> unixProcessCls = ClassLoader.getSystemClassLoader().loadClass("java.lang.UNIXProcess");
                Field f = unixProcessCls.getDeclaredField("processReaperExecutor");
                f.setAccessible(true);
                executor = (Executor)f.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        PROCESS_ON_EXIT = processOnExit;
        EXECUTOR = executor;
        ONLINE = PROCESS_ON_EXIT != null || EXECUTOR != null;
    }
}

