/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.CITagsProvider;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.info.CILocalGitInfoBuilder;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.info.UserSuppliedGitInfoBuilder;
import ddtrot.dd.trace.util.Strings;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CITagsProviderImpl
implements CITagsProvider {
    private static final Logger log = LoggerFactory.getLogger(CITagsProviderImpl.class);
    private final Map<String, String> ciTags;
    private final boolean ci;

    public CITagsProviderImpl(CIProviderInfo ciProviderInfo, CILocalGitInfoBuilder ciLocalGitInfoBuilder, UserSuppliedGitInfoBuilder userSuppliedGitInfoBuilder, String gitFolderName) {
        CIInfo ciInfo = ciProviderInfo.buildCIInfo();
        GitInfo ciGitInfo = ciProviderInfo.buildCIGitInfo();
        GitInfo localGitInfo = ciLocalGitInfoBuilder.build(ciInfo, gitFolderName);
        GitInfo userSuppliedGitInfo = userSuppliedGitInfoBuilder.build();
        this.ci = ciProviderInfo.isCI();
        this.ciTags = new CITagsBuilder().withCiProviderName(ciInfo.getCiProviderName()).withCiPipelineId(ciInfo.getCiPipelineId()).withCiPipelineName(ciInfo.getCiPipelineName()).withCiStageName(ciInfo.getCiStageName()).withCiJobName(ciInfo.getCiJobName()).withCiPipelineNumber(ciInfo.getCiPipelineNumber()).withCiPipelineUrl(ciInfo.getCiPipelineUrl()).withCiJorUrl(ciInfo.getCiJobUrl()).withCiWorkspacePath(ciInfo.getCiWorkspace()).withCiEnvVars(ciInfo.getCiEnvVars()).withGitRepositoryUrl(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommit(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitBranch(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitTag(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitAuthorName(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitAuthorEmail(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitAuthorDate(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitCommitterName(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitCommitterEmail(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitCommitterDate(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitMessage(userSuppliedGitInfo, ciGitInfo, localGitInfo).build();
        if (!userSuppliedGitInfo.isEmpty()) {
            String resolvedCommitSha;
            String resolvedRepoUrl = this.ciTags.get("git.repository_url");
            if (resolvedRepoUrl == null || resolvedRepoUrl.isEmpty()) {
                log.error("Could not resolve git repository URL (can be provided via DD_GIT_REPOSITORY_URL env var)");
            }
            if (!GitUtils.isValidCommitSha(resolvedCommitSha = this.ciTags.get("git.commit.sha"))) {
                log.error("Git commit SHA could not be resolved or is invalid: " + resolvedCommitSha + " (can be provided via " + "DD_GIT_COMMIT_SHA" + " env var, and must be a full-length git SHA)");
            }
        }
    }

    @Override
    public boolean isCI() {
        return this.ci;
    }

    @Override
    public Map<String, String> getCiTags() {
        return this.ciTags;
    }

    public static class CITagsBuilder {
        private final Map<String, String> ciTags = new HashMap<String, String>();

        public CITagsBuilder withCiProviderName(String ciProviderName) {
            return this.putTagValue("ci.provider.name", ciProviderName, new String[0]);
        }

        public CITagsBuilder withCiPipelineId(String ciPipelineId) {
            return this.putTagValue("ci.pipeline.id", ciPipelineId, new String[0]);
        }

        public CITagsBuilder withCiPipelineName(String ciPipelineName) {
            return this.putTagValue("ci.pipeline.name", ciPipelineName, new String[0]);
        }

        public CITagsBuilder withCiPipelineNumber(String ciPipelineNumber) {
            return this.putTagValue("ci.pipeline.number", ciPipelineNumber, new String[0]);
        }

        public CITagsBuilder withCiPipelineUrl(String ciPipelineUrl) {
            return this.putTagValue("ci.pipeline.url", ciPipelineUrl, new String[0]);
        }

        public CITagsBuilder withCiStageName(String ciStageName) {
            return this.putTagValue("ci.stage.name", ciStageName, new String[0]);
        }

        public CITagsBuilder withCiJobName(String ciJobName) {
            return this.putTagValue("ci.job.name", ciJobName, new String[0]);
        }

        public CITagsBuilder withCiJorUrl(String ciJobUrl) {
            return this.putTagValue("ci.job.url", ciJobUrl, new String[0]);
        }

        public CITagsBuilder withCiWorkspacePath(String ciWorkspacePath) {
            return this.putTagValue("ci.workspace_path", ciWorkspacePath, new String[0]);
        }

        public CITagsBuilder withCiEnvVars(Map<String, String> ciEnvVars) {
            if (ciEnvVars == null || ciEnvVars.isEmpty()) {
                return this;
            }
            return this.putTagValue("_dd.ci.env_vars", Strings.toJson(ciEnvVars), new String[0]);
        }

        public CITagsBuilder withGitRepositoryUrl(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.repository_url", userSuppliedGitInfo.getRepositoryURL(), ciGitInfo.getRepositoryURL(), localGitInfo.getRepositoryURL());
        }

        public CITagsBuilder withGitCommit(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.commit.sha", userSuppliedGitInfo.getCommit().getSha(), ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha());
        }

        public CITagsBuilder withGitBranch(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.branch", userSuppliedGitInfo.getBranch(), ciGitInfo.getBranch(), localGitInfo.getBranch());
        }

        public CITagsBuilder withGitTag(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.tag", userSuppliedGitInfo.getTag(), ciGitInfo.getTag(), localGitInfo.getTag());
        }

        public CITagsBuilder withGitCommitAuthorName(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitAuthorName = userSuppliedGitInfo.getCommit().getAuthor().getName();
            String ciGitAuthorName = ciGitInfo.getCommit().getAuthor().getName();
            String localGitAuthorName = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getAuthor().getName() : null;
            return this.putTagValue("git.commit.author.name", userSuppliedGitAuthorName, ciGitAuthorName, localGitAuthorName);
        }

        public CITagsBuilder withGitCommitAuthorEmail(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitAuthorEmail = userSuppliedGitInfo.getCommit().getAuthor().getEmail();
            String ciGitAuthorEmail = ciGitInfo.getCommit().getAuthor().getEmail();
            String localGitAuthorEmail = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getAuthor().getEmail() : null;
            return this.putTagValue("git.commit.author.email", userSuppliedGitAuthorEmail, ciGitAuthorEmail, localGitAuthorEmail);
        }

        public CITagsBuilder withGitCommitAuthorDate(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitAuthorDate = userSuppliedGitInfo.getCommit().getAuthor().getIso8601Date();
            String ciGitAuthorDate = ciGitInfo.getCommit().getAuthor().getIso8601Date();
            String localGitAuthorDate = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getAuthor().getIso8601Date() : null;
            return this.putTagValue("git.commit.author.date", userSuppliedGitAuthorDate, ciGitAuthorDate, localGitAuthorDate);
        }

        public CITagsBuilder withGitCommitCommitterName(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitterName = userSuppliedGitInfo.getCommit().getCommitter().getName();
            String ciGitCommitterName = ciGitInfo.getCommit().getCommitter().getName();
            String localGitCommitterName = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getCommitter().getName() : null;
            return this.putTagValue("git.commit.committer.name", userSuppliedGitCommitterName, ciGitCommitterName, localGitCommitterName);
        }

        public CITagsBuilder withGitCommitCommitterEmail(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitterEmail = userSuppliedGitInfo.getCommit().getCommitter().getEmail();
            String ciGitCommitterEmail = ciGitInfo.getCommit().getCommitter().getEmail();
            String localCommitterEmail = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getCommitter().getEmail() : null;
            return this.putTagValue("git.commit.committer.email", userSuppliedGitCommitterEmail, ciGitCommitterEmail, localCommitterEmail);
        }

        public CITagsBuilder withGitCommitCommitterDate(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitterDate = userSuppliedGitInfo.getCommit().getCommitter().getIso8601Date();
            String ciGitCommitterDate = ciGitInfo.getCommit().getCommitter().getIso8601Date();
            String localGitCommitterDate = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getCommitter().getIso8601Date() : null;
            return this.putTagValue("git.commit.committer.date", userSuppliedGitCommitterDate, ciGitCommitterDate, localGitCommitterDate);
        }

        public CITagsBuilder withGitCommitMessage(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitMessage = userSuppliedGitInfo.getCommit().getFullMessage();
            String ciGitCommitMessage = ciGitInfo.getCommit().getFullMessage();
            String localGitCommitMessage = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getFullMessage() : null;
            return this.putTagValue("git.commit.message", userSuppliedGitCommitMessage, ciGitCommitMessage, localGitCommitMessage);
        }

        public Map<String, String> build() {
            return this.ciTags;
        }

        private CITagsBuilder putTagValue(String tagKey, String tagValue, String ... fallbackValues) {
            if (tagValue != null) {
                this.ciTags.put(tagKey, tagValue);
            } else {
                for (String fallbackValue : fallbackValues) {
                    if (fallbackValue == null) continue;
                    this.ciTags.put(tagKey, fallbackValue);
                    break;
                }
            }
            return this;
        }

        private boolean isCommitShaEquals(GitInfo ciGitInfo, GitInfo localGitInfo) {
            String ciGitCommit = ciGitInfo.getCommit().getSha();
            String localFSGitCommit = localGitInfo.getCommit().getSha();
            return ciGitCommit == null || ciGitCommit.equalsIgnoreCase(localFSGitCommit);
        }
    }
}

