/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.utils.PathUtils;

class CircleCIInfo
implements CIProviderInfo {
    public static final String CIRCLECI = "CIRCLECI";
    public static final String CIRCLECI_PROVIDER_NAME = "circleci";
    public static final String CIRCLECI_PIPELINE_ID = "CIRCLE_WORKFLOW_ID";
    public static final String CIRCLECI_PIPELINE_NAME = "CIRCLE_PROJECT_REPONAME";
    public static final String CIRCLECI_BUILD_URL = "CIRCLE_BUILD_URL";
    public static final String CIRCLECI_BUILD_NUM = "CIRCLE_BUILD_NUM";
    public static final String CIRCLECI_WORKSPACE_PATH = "CIRCLE_WORKING_DIRECTORY";
    public static final String CIRCLECI_GIT_REPOSITORY_URL = "CIRCLE_REPOSITORY_URL";
    public static final String CIRCLECI_GIT_COMMIT = "CIRCLE_SHA1";
    public static final String CIRCLECI_GIT_BRANCH = "CIRCLE_BRANCH";
    public static final String CIRCLECI_GIT_TAG = "CIRCLE_TAG";
    public static final String CIRCLECI_JOB_NAME = "CIRCLE_JOB";

    CircleCIInfo() {
    }

    @Override
    public GitInfo buildCIGitInfo() {
        String gitTag = GitUtils.normalizeRef(System.getenv(CIRCLECI_GIT_TAG));
        return new GitInfo(GitUtils.filterSensitiveInfo(System.getenv(CIRCLECI_GIT_REPOSITORY_URL)), this.buildGitBranch(gitTag), gitTag, new CommitInfo(System.getenv(CIRCLECI_GIT_COMMIT)));
    }

    @Override
    public CIInfo buildCIInfo() {
        String pipelineId = System.getenv(CIRCLECI_PIPELINE_ID);
        return CIInfo.builder().ciProviderName(CIRCLECI_PROVIDER_NAME).ciPipelineId(pipelineId).ciPipelineName(System.getenv(CIRCLECI_PIPELINE_NAME)).ciPipelineUrl(this.buildPipelineUrl(pipelineId)).ciJobName(System.getenv(CIRCLECI_JOB_NAME)).ciJobUrl(System.getenv(CIRCLECI_BUILD_URL)).ciWorkspace(PathUtils.expandTilde(System.getenv(CIRCLECI_WORKSPACE_PATH))).ciEnvVars(CIRCLECI_PIPELINE_ID, CIRCLECI_BUILD_NUM).build();
    }

    @Override
    public boolean isCI() {
        return true;
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        return GitUtils.normalizeRef(System.getenv(CIRCLECI_GIT_BRANCH));
    }

    private String buildPipelineUrl(String pipelineId) {
        if (pipelineId == null) {
            return null;
        }
        return String.format("https://app.circleci.com/pipelines/workflows/%s", pipelineId);
    }
}

