/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.Matcher;

public class CompositeMatcher
implements Matcher {
    private final Matcher[] delegates;

    public CompositeMatcher(Matcher[] delegates) {
        this.delegates = delegates;
    }

    @Override
    public int consume(char[] line, int offset) {
        return this.consume(line, offset, 0);
    }

    private int consume(char[] line, int offset, int matcherOffset) {
        int position = offset;
        while (matcherOffset < this.delegates.length) {
            int consumed;
            Matcher delegate = this.delegates[matcherOffset];
            if (delegate.multi() && (consumed = this.consume(line, position, matcherOffset + 1)) >= 0) {
                return position - offset + consumed;
            }
            consumed = delegate.consume(line, position);
            if (consumed < 0) {
                return consumed;
            }
            position += consumed;
            if (delegate.multi()) continue;
            ++matcherOffset;
        }
        return position - offset;
    }

    @Override
    public boolean multi() {
        return false;
    }
}

