/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import datadog.trace.api.Config;
import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteResponseListener;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDIntakeApi
extends RemoteApi {
    private static final String DD_API_KEY_HEADER = "dd-api-key";
    private static final Logger log = LoggerFactory.getLogger(DDIntakeApi.class);
    private final OkHttpClient httpClient;
    private final HttpUrl intakeUrl;
    private final String apiKey;
    private final HttpRetryPolicy.Factory retryPolicyFactory;

    public static DDIntakeApiBuilder builder() {
        return new DDIntakeApiBuilder();
    }

    private DDIntakeApi(OkHttpClient httpClient, HttpUrl intakeUrl, String apiKey, HttpRetryPolicy.Factory retryPolicyFactory) {
        this.httpClient = httpClient;
        this.intakeUrl = intakeUrl;
        this.apiKey = apiKey;
        this.retryPolicyFactory = retryPolicyFactory;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        sizeInBytes = payload.sizeInBytes();
        try {
            request = new Request.Builder().url(this.intakeUrl).addHeader("dd-api-key", this.apiKey).post(payload.toRequest()).build();
            this.totalTraces += (long)payload.traceCount();
            this.receivedTraces += (long)payload.traceCount();
            retryPolicy = this.retryPolicyFactory.create();
            while (true) lbl-1000:
            // 2 sources

            {
                block26: {
                    try {
                        response = this.httpClient.newCall(request).execute();
                        var6_9 = null;
                        try {
                            if (response.isSuccessful()) {
                                this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                                var7_11 = RemoteApi.Response.success(response.code());
                                return var7_11;
                            }
                            if (!retryPolicy.shouldRetry(response)) {
                                this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response, null);
                                var7_12 = RemoteApi.Response.failed(response.code());
                                return var7_12;
                            }
                        }
                        catch (Throwable var7_13) {
                            var6_9 = var7_13;
                            throw var7_13;
                        }
                        finally {
                            if (response != null) {
                                if (var6_9 != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable var8_15) {
                                        var6_9.addSuppressed(var8_15);
                                    }
                                } else {
                                    response.close();
                                }
                            }
                        }
                    }
                    catch (ConnectException ex) {
                        if (retryPolicy.shouldRetry(null)) break block26;
                        this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
                        return RemoteApi.Response.failed(ex);
                    }
                }
                backoffMs = retryPolicy.backoff();
                try {
                    Thread.sleep(backoffMs);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                break;
            }
        }
        catch (IOException e) {
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
        {
            ** while (true)
        }
    }

    @Override
    public void addResponseListener(RemoteResponseListener listener) {
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public static class DDIntakeApiBuilder {
        private String site = Config.get().getSite();
        private String apiVersion = "v2";
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl hostUrl = null;
        OkHttpClient httpClient = null;
        HttpRetryPolicy.Factory retryPolicyFactory = new HttpRetryPolicy.Factory(5, 100, 2.0);
        private String apiKey;

        public DDIntakeApiBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDIntakeApiBuilder site(String site) {
            this.site = site;
            return this;
        }

        public DDIntakeApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDIntakeApiBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public DDIntakeApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDIntakeApiBuilder hostUrl(HttpUrl hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        DDIntakeApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDIntakeApi build() {
            assert (this.apiKey != null);
            String trackName = (this.trackType != null ? this.trackType.name() : TrackType.NOOP.name()).toLowerCase();
            if (null == this.hostUrl) {
                this.hostUrl = HttpUrl.get(String.format("https://%s-intake.%s", trackName, this.site));
            }
            HttpUrl intakeUrl = this.hostUrl.resolve(String.format("/api/%s/%s", this.apiVersion, trackName));
            OkHttpClient client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(intakeUrl, this.timeoutMillis);
            return new DDIntakeApi(client, intakeUrl, this.apiKey, this.retryPolicyFactory);
        }
    }
}

