/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.propagation.PropagationTagsFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatadogPropagationTagsFactory {
    private static final Logger log = LoggerFactory.getLogger(DatadogPropagationTagsFactory.class);
    private static final String ALLOWED_TAG_PREFIX = "_dd.p.";
    private static final String DECISION_MAKER_TAG = "_dd.p.dm";
    private static final String UPSTREAM_SERVICES_DEPRECATED_TAG = "_dd.p.upstream_services";
    private static final String PROPAGATION_ERROR_EXTRACT_MAX_SIZE = "extract_max_size";
    private static final String PROPAGATION_ERROR_INJECT_MAX_SIZE = "inject_max_size";
    private static final String PROPAGATION_ERROR_DISABLED = "disabled";
    private static final String PROPAGATION_ERROR_DECODING_ERROR = "decoding_error";
    private static final char TAGS_SEPARATOR = ',';
    private static final char TAG_KEY_SEPARATOR = '=';
    private static final int MIN_ALLOWED_CHAR = 32;
    private static final int MAX_ALLOWED_CHAR = 126;
    private final int datadogTagsLimit;

    DatadogPropagationTagsFactory(int datadogTagsLimit) {
        this.datadogTagsLimit = datadogTagsLimit;
    }

    public PropagationTags fromHeaderValue(PropagationTagsFactory tagsFactory, String value) {
        if (value == null) {
            return tagsFactory.empty();
        }
        if (value.length() > this.datadogTagsLimit) {
            return tagsFactory.createInvalid(PROPAGATION_ERROR_EXTRACT_MAX_SIZE);
        }
        ArrayList<String> tagPairs = new ArrayList<String>(10);
        int len = value.length();
        int tagPos = 0;
        while (tagPos < len) {
            int tagKeyEndsAt = value.indexOf(61, tagPos);
            if (tagKeyEndsAt < 0 || tagKeyEndsAt == len) {
                log.warn("Invalid datadog tags header value: '{}' tag without a value at {}", (Object)value, (Object)tagPos);
                return tagsFactory.createInvalid(PROPAGATION_ERROR_DECODING_ERROR);
            }
            int tagValuePos = tagKeyEndsAt + 1;
            int tagValueEndsAt = value.indexOf(44, tagKeyEndsAt);
            if (tagValueEndsAt < 0) {
                tagValueEndsAt = len;
            }
            String tagKey = value.substring(tagPos, tagKeyEndsAt);
            String tagValue = value.substring(tagValuePos, tagValueEndsAt);
            if (!DatadogPropagationTagsFactory.validateTagKey(tagKey)) {
                log.warn("Invalid datadog tags header value: '{}' invalid tag key at {}", (Object)value, (Object)tagPos);
                return tagsFactory.createInvalid(PROPAGATION_ERROR_DECODING_ERROR);
            }
            if (tagKey.startsWith(ALLOWED_TAG_PREFIX) && !tagKey.startsWith(UPSTREAM_SERVICES_DEPRECATED_TAG)) {
                if (!DatadogPropagationTagsFactory.validateTagValue(tagKey, tagValue)) {
                    log.warn("Invalid datadog tags header value: '{}' invalid tag value at {}", (Object)value, (Object)tagValuePos);
                    return tagsFactory.createInvalid(PROPAGATION_ERROR_DECODING_ERROR);
                }
                tagPairs.add(tagKey);
                tagPairs.add(tagValue);
            }
            tagPos = tagValueEndsAt + 1;
        }
        return tagsFactory.createValid(tagPairs, DatadogPropagationTagsFactory.calcTagsLength(tagPairs), DatadogPropagationTagsFactory.containsTag(tagPairs, DECISION_MAKER_TAG));
    }

    String headerValue(PropagationTags propagationTags) {
        int newSize = DatadogPropagationTagsFactory.countTagSize(propagationTags.tagsSize(), DECISION_MAKER_TAG, propagationTags.decisionMakerTagValue());
        if (newSize > this.datadogTagsLimit) {
            return null;
        }
        Iterator<String> it = propagationTags.tagPairs().iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String tagKey = it.next();
            String tagValue = it.next();
            DatadogPropagationTagsFactory.appendTag(sb, tagKey, tagValue);
        }
        if (propagationTags.missingDecisionMaker() && propagationTags.decisionMakerTagValue() != null) {
            DatadogPropagationTagsFactory.appendTag(sb, DECISION_MAKER_TAG, propagationTags.decisionMakerTagValue());
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public void fillTagMap(PropagationTags propagationTags, Map<String, String> tagMap) {
        int newSize = DatadogPropagationTagsFactory.countTagSize(propagationTags.tagsSize(), DECISION_MAKER_TAG, propagationTags.decisionMakerTagValue());
        if (newSize > this.datadogTagsLimit) {
            if (this.datadogTagsLimit == 0) {
                tagMap.put("_dd.propagation_error", PROPAGATION_ERROR_DISABLED);
            } else {
                tagMap.put("_dd.propagation_error", PROPAGATION_ERROR_INJECT_MAX_SIZE);
            }
            return;
        }
        Iterator<String> it = propagationTags.tagPairs().iterator();
        while (it.hasNext()) {
            String tagKey = it.next();
            String tagValue = it.next();
            tagMap.put(tagKey, tagValue);
        }
        if (propagationTags.missingDecisionMaker() && propagationTags.decisionMakerTagValue() != null) {
            tagMap.put(DECISION_MAKER_TAG, propagationTags.decisionMakerTagValue());
        }
    }

    private static boolean containsTag(List<String> tagPairs, String tagName) {
        for (int i = 0; i < tagPairs.size(); i += 2) {
            if (!tagPairs.get(i).equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private static int calcTagsLength(List<String> tagPairs) {
        int size = 0;
        for (String tagPair : tagPairs) {
            size += tagPair.length();
            ++size;
        }
        return size - 1;
    }

    private static void appendTag(StringBuilder sb, String tagKey, String tagValue) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(tagKey);
        sb.append('=');
        sb.append(tagValue);
    }

    private static int countTagSize(int size, String tagKey, String tagValue) {
        if (tagValue != null) {
            if (size > 0) {
                ++size;
            }
            size += tagKey.length();
            ++size;
            size += tagValue.length();
        }
        return size;
    }

    private static boolean validateTagKey(String tagKey) {
        for (int i = 0; i < tagKey.length(); ++i) {
            char c = tagKey.charAt(i);
            if (DatadogPropagationTagsFactory.isAllowedKeyChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateTagValue(String tagKey, String tagValue) {
        for (int i = 0; i < tagValue.length(); ++i) {
            char c = tagValue.charAt(i);
            if (DatadogPropagationTagsFactory.isAllowedValueChar(c)) continue;
            return false;
        }
        return !tagKey.equals(DECISION_MAKER_TAG) || DatadogPropagationTagsFactory.validateDecisionMakerTag(tagValue);
    }

    private static boolean isAllowedKeyChar(char c) {
        return c > ' ' && c <= '~' && c != ',';
    }

    private static boolean isAllowedValueChar(char c) {
        return c >= ' ' && c <= '~' && c != '=';
    }

    private static boolean validateDecisionMakerTag(String value) {
        int i;
        int sepPos = value.indexOf(45);
        if (sepPos < 0) {
            return false;
        }
        if (sepPos != 0 && sepPos != 10) {
            return false;
        }
        int samplingMechanismPos = sepPos + 1;
        int len = value.length();
        if (samplingMechanismPos == len) {
            return false;
        }
        for (i = 0; i < sepPos; ++i) {
            if (DatadogPropagationTagsFactory.isHexDigit(value.charAt(i))) continue;
            return false;
        }
        for (i = samplingMechanismPos; i < len; ++i) {
            if (DatadogPropagationTagsFactory.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || DatadogPropagationTagsFactory.isDigit(c);
    }
}

