/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddagent;

import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InstrumentationTags;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.common.writer.ddagent.TraceMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class TraceMapperV0_4
implements TraceMapper {
    private final int size;
    private final MetaWriter metaWriter = new MetaWriter();

    public TraceMapperV0_4(int size) {
        this.size = size;
    }

    public TraceMapperV0_4() {
        this(0x500000);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startArray(trace.size());
        for (int i = 0; i < trace.size(); ++i) {
            CoreSpan<?> span = trace.get(i);
            writable.startMap(12);
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeLong(span.getTraceId().toLong());
            writable.writeUTF8(SPAN_ID);
            writable.writeLong(span.getSpanId());
            writable.writeUTF8(PARENT_ID);
            writable.writeLong(span.getParentId());
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(TYPE);
            writable.writeString(span.getType(), null);
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable).withWriteSamplingPriority(i == 0 || i == trace.size() - 1));
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_4();
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return "v0.4";
    }

    private static class PayloadV0_4
    extends Payload {
        private PayloadV0_4() {
        }

        @Override
        public int sizeInBytes() {
            return this.msgpackArrayHeaderSize(this.traceCount()) + this.body.remaining();
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer header = this.msgpackArrayHeader(this.traceCount());
            while (header.hasRemaining()) {
                channel.write(header);
            }
            while (this.body.hasRemaining()) {
                channel.write(this.body);
            }
        }

        @Override
        public RequestBody toRequest() {
            return OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.msgpackArrayHeader(this.traceCount()), this.body));
        }
    }

    private static final class MetaWriter
    extends MetadataConsumer {
        private Writable writable;
        private boolean writeSamplingPriority;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        MetaWriter withWriteSamplingPriority(boolean writeSamplingPriority) {
            this.writeSamplingPriority = writeSamplingPriority;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1) + (null == metadata.getOrigin() ? 0 : 1) + 1;
            int metricsSize = (this.writeSamplingPriority && metadata.hasSamplingPriority() ? 1 : 0) + (metadata.measured() ? 1 : 0) + (metadata.topLevel() ? 1 : 0) + 1;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.writeUTF8(RemoteMapper.METRICS);
            this.writable.startMap(metricsSize);
            if (this.writeSamplingPriority && metadata.hasSamplingPriority()) {
                this.writable.writeUTF8(TraceMapper.SAMPLING_PRIORITY_KEY);
                this.writable.writeInt(metadata.samplingPriority());
            }
            if (metadata.measured()) {
                this.writable.writeUTF8(InstrumentationTags.DD_MEASURED);
                this.writable.writeInt(1);
            }
            if (metadata.topLevel()) {
                this.writable.writeUTF8(InstrumentationTags.DD_TOP_LEVEL);
                this.writable.writeInt(1);
            }
            this.writable.writeUTF8(TraceMapper.THREAD_ID);
            this.writable.writeLong(metadata.getThreadId());
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(RemoteMapper.META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            this.writable.writeUTF8(TraceMapper.THREAD_NAME);
            this.writable.writeUTF8(metadata.getThreadName());
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(RemoteMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            if (null != metadata.getOrigin()) {
                this.writable.writeUTF8(TraceMapper.ORIGIN_KEY);
                this.writable.writeString(metadata.getOrigin(), null);
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (entry.getValue() instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObjectString(entry.getValue(), null);
            }
        }
    }
}

