/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.Functions;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.bootstrap.ActiveSubsystems;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class ContextInterpreter
implements AgentPropagation.KeyClassifier {
    protected final Map<String, String> taggedHeaders;
    protected final Map<String, String> baggageMapping;
    protected DDTraceId traceId;
    protected long spanId;
    protected int samplingPriority;
    protected Map<String, String> tags;
    protected Map<String, String> baggage;
    protected String origin;
    protected long endToEndStartTime;
    protected boolean valid;
    protected PropagationTags propagationTags;
    private TagContext.HttpHeaders httpHeaders;
    private final String customIpHeaderName;
    private final boolean clientIpResolutionEnabled;
    private final boolean clientIpWithoutAppSec;
    private boolean collectIpHeaders;
    protected static final boolean LOG_EXTRACT_HEADER_NAMES = Config.get().isLogExtractHeaderNames();
    private static final DDCache<String, String> CACHE = DDCaches.newFixedSizeCache(64);

    protected String toLowerCase(String key) {
        return CACHE.computeIfAbsent(key, Functions.LowerCase.INSTANCE);
    }

    protected ContextInterpreter(Map<String, String> taggedHeaders, Map<String, String> baggageMapping, Config config) {
        this.taggedHeaders = taggedHeaders;
        this.baggageMapping = baggageMapping;
        this.customIpHeaderName = config.getTraceClientIpHeader();
        this.clientIpResolutionEnabled = config.isTraceClientIpResolverEnabled();
        this.clientIpWithoutAppSec = config.isClientIpEnabled();
        this.reset();
    }

    protected final boolean handledForwarding(String key, String value) {
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        if ("forwarded".equalsIgnoreCase(key)) {
            this.getHeaders().forwarded = value;
            return true;
        }
        if ("forwarded-for".equalsIgnoreCase(key)) {
            this.getHeaders().forwardedFor = value;
            return true;
        }
        return false;
    }

    protected final boolean handledXForwarding(String key, String value) {
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        if ("x-forwarded-proto".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedProto = value;
            return true;
        }
        if ("x-forwarded-host".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedHost = value;
            return true;
        }
        if ("x-forwarded-for".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedFor = value;
            return true;
        }
        if ("x-forwarded-port".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedPort = value;
            return true;
        }
        if ("x-forwarded".equalsIgnoreCase(key)) {
            this.getHeaders().xForwarded = value;
            return true;
        }
        return false;
    }

    protected final boolean handledUserAgent(String key, String value) {
        if (value == null || !"user-agent".equalsIgnoreCase(key)) {
            return false;
        }
        this.getHeaders().userAgent = value;
        return true;
    }

    protected final boolean handledIpHeaders(String key, String value) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        if (null != value && this.customIpHeaderName != null && this.customIpHeaderName.equalsIgnoreCase(key)) {
            this.getHeaders().customIpHeader = value;
            return true;
        }
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        char last = Character.toLowerCase(key.charAt(key.length() - 1));
        if (last == 'p') {
            if ("x-cluster-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xClusterClientIp = value;
                return true;
            }
            if ("x-real-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xRealIp = value;
                return true;
            }
            if ("client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().clientIp = value;
                return true;
            }
            if ("true-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().trueClientIp = value;
                return true;
            }
        }
        if ("via".equalsIgnoreCase(key)) {
            this.getHeaders().via = value;
            return true;
        }
        return false;
    }

    protected final boolean handleTags(String key, String value) {
        if (this.taggedHeaders.isEmpty() || value == null) {
            return false;
        }
        String lowerCaseKey = this.toLowerCase(key);
        String mappedKey = this.taggedHeaders.get(lowerCaseKey);
        if (null != mappedKey) {
            if (this.tags.isEmpty()) {
                this.tags = new TreeMap<String, String>();
            }
            this.tags.put(mappedKey, HttpCodec.decode(HttpCodec.firstHeaderValue(value)));
            return true;
        }
        return false;
    }

    protected final boolean handleMappedBaggage(String key, String value) {
        if (this.baggageMapping.isEmpty() || value == null) {
            return false;
        }
        String lowerCaseKey = this.toLowerCase(key);
        String mappedKey = this.baggageMapping.get(lowerCaseKey);
        if (null != mappedKey) {
            if (this.baggage.isEmpty()) {
                this.baggage = new TreeMap<String, String>();
            }
            this.baggage.put(mappedKey, HttpCodec.decode(value));
            return true;
        }
        return false;
    }

    public ContextInterpreter reset() {
        this.traceId = DDTraceId.ZERO;
        this.spanId = 0L;
        this.samplingPriority = -128;
        this.origin = null;
        this.endToEndStartTime = 0L;
        this.tags = Collections.emptyMap();
        this.baggage = Collections.emptyMap();
        this.valid = true;
        this.httpHeaders = null;
        this.collectIpHeaders = this.clientIpWithoutAppSec || this.clientIpResolutionEnabled && ActiveSubsystems.APPSEC_ACTIVE;
        return this;
    }

    TagContext build() {
        if (this.valid) {
            if (!DDTraceId.ZERO.equals((Object)this.traceId)) {
                ExtractedContext context = new ExtractedContext(this.traceId, this.spanId, this.samplingPriorityOrDefault(this.samplingPriority), this.origin, this.endToEndStartTime, this.baggage, this.tags, this.httpHeaders, this.propagationTags);
                return context;
            }
            if (this.origin != null || !this.tags.isEmpty() || this.httpHeaders != null || !this.baggage.isEmpty() || this.samplingPriority != -128) {
                return new TagContext(this.origin, this.tags, this.httpHeaders, this.baggage, this.samplingPriorityOrDefault(this.samplingPriority));
            }
        }
        return null;
    }

    protected void invalidateContext() {
        this.valid = false;
    }

    protected int defaultSamplingPriority() {
        return -128;
    }

    private TagContext.HttpHeaders getHeaders() {
        if (this.httpHeaders == null) {
            this.httpHeaders = new TagContext.HttpHeaders();
        }
        return this.httpHeaders;
    }

    private int samplingPriorityOrDefault(int samplingPriority) {
        return samplingPriority == -128 ? this.defaultSamplingPriority() : samplingPriority;
    }

    public static abstract class Factory {
        public ContextInterpreter create(Map<String, String> tagsMapping, Map<String, String> baggageMapping) {
            return this.construct(this.cleanMapping(tagsMapping), this.cleanMapping(baggageMapping, false));
        }

        protected abstract ContextInterpreter construct(Map<String, String> var1, Map<String, String> var2);

        protected Map<String, String> cleanMapping(Map<String, String> mapping, boolean lowerCaseValues) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
            for (Map.Entry<String, String> association : mapping.entrySet()) {
                String value = association.getValue().trim();
                if (lowerCaseValues) {
                    value = value.toLowerCase();
                }
                cleanedMapping.put(association.getKey().trim().toLowerCase(), value);
            }
            return cleanedMapping;
        }

        protected Map<String, String> cleanMapping(Map<String, String> mapping) {
            return this.cleanMapping(mapping, true);
        }
    }
}

