/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.gateway;

import ddtrot.dd.appsec.api.blocking.BlockingContentType;

public interface Flow<T> {
    public Action getAction();

    public T getResult();

    public static class ResultFlow<R>
    implements Flow<R> {
        private static final ResultFlow EMPTY = new ResultFlow<Object>(null);
        private final R result;

        public static <R> ResultFlow<R> empty() {
            return EMPTY;
        }

        public ResultFlow(R result) {
            this.result = result;
        }

        @Override
        public Action getAction() {
            return Action.Noop.INSTANCE;
        }

        @Override
        public R getResult() {
            return this.result;
        }
    }

    public static interface Action {
        public boolean isBlocking();

        public static class RequestBlockingAction
        implements Action {
            private final int statusCode;
            private final BlockingContentType blockingContentType;

            public RequestBlockingAction(int statusCode, BlockingContentType blockingContentType) {
                this.statusCode = statusCode;
                this.blockingContentType = blockingContentType;
            }

            @Override
            public boolean isBlocking() {
                return true;
            }

            public int getStatusCode() {
                return this.statusCode;
            }

            public BlockingContentType getBlockingContentType() {
                return this.blockingContentType;
            }
        }

        public static class Noop
        implements Action {
            public static Action INSTANCE = new Noop();

            private Noop() {
            }

            @Override
            public boolean isBlocking() {
                return false;
            }
        }
    }
}

