/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Base64Decoder {
    private static final int[] BASE_64;
    public static final Base64Decoder INSTANCE;

    public byte[] decode(byte[] src) {
        byte[] dst = new byte[this.outLength(src, 0, src.length)];
        int ret = this.decode0(src, 0, src.length, dst);
        if (ret != dst.length) {
            dst = Arrays.copyOf(dst, ret);
        }
        return dst;
    }

    public byte[] decode(String src) {
        return this.decode(src.getBytes(StandardCharsets.ISO_8859_1));
    }

    private int outLength(byte[] src, int sp, int sl) {
        int paddings = 0;
        int len = sl - sp;
        if (len == 0) {
            return 0;
        }
        if (len < 2) {
            if (BASE_64[0] == -1) {
                return 0;
            }
            throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
        }
        int n = 0;
        while (sp < sl) {
            int b;
            if ((b = src[sp++] & 0xFF) == 61) {
                len -= sl - sp + 1;
                break;
            }
            if ((b = BASE_64[b]) != -1) continue;
            ++n;
        }
        if (((len -= n) & 3) != 0) {
            paddings = 4 - (len & 3);
        }
        return 3 * ((len + 3) / 4) - paddings;
    }

    private int decode0(byte[] src, int sp, int sl, byte[] dst) {
        int dp = 0;
        int bits = 0;
        int shiftto = 18;
        while (sp < sl) {
            if (shiftto == 18 && sp + 4 < sl) {
                int sl0 = sp + (sl - sp & 0xFFFFFFFC);
                while (sp < sl0) {
                    int b4;
                    int b3;
                    int b1 = BASE_64[src[sp++] & 0xFF];
                    int b2 = BASE_64[src[sp++] & 0xFF];
                    if ((b1 | b2 | (b3 = BASE_64[src[sp++] & 0xFF]) | (b4 = BASE_64[src[sp++] & 0xFF])) < 0) {
                        sp -= 4;
                        break;
                    }
                    int bits0 = b1 << 18 | b2 << 12 | b3 << 6 | b4;
                    dst[dp++] = (byte)(bits0 >> 16);
                    dst[dp++] = (byte)(bits0 >> 8);
                    dst[dp++] = (byte)bits0;
                }
                if (sp >= sl) break;
            }
            int b = src[sp++] & 0xFF;
            if ((b = BASE_64[b]) < 0 && b == -2) {
                if ((shiftto != 6 || sp != sl && src[sp++] == 61) && shiftto != 18) break;
                throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
            }
            bits |= b << shiftto;
            if ((shiftto -= 6) >= 0) continue;
            dst[dp++] = (byte)(bits >> 16);
            dst[dp++] = (byte)(bits >> 8);
            dst[dp++] = (byte)bits;
            shiftto = 18;
            bits = 0;
        }
        if (shiftto == 6) {
            dst[dp++] = (byte)(bits >> 16);
        } else if (shiftto == 0) {
            dst[dp++] = (byte)(bits >> 16);
            dst[dp++] = (byte)(bits >> 8);
        } else if (shiftto == 12) {
            throw new IllegalArgumentException("Last unit does not have enough valid bits");
        }
        while (sp < sl) {
            if (BASE_64[src[sp++] & 0xFF] < 0) continue;
            throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + sp);
        }
        return dp;
    }

    static {
        int c;
        BASE_64 = new int[256];
        Arrays.fill(BASE_64, -1);
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Decoder.BASE_64[c] = i++;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Decoder.BASE_64[c] = i++;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Decoder.BASE_64[c] = i++;
        }
        Base64Decoder.BASE_64[43] = i++;
        Base64Decoder.BASE_64[47] = i;
        Base64Decoder.BASE_64[61] = -2;
        INSTANCE = new Base64Decoder();
    }
}

