/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace;

import com.datadoghq.trace.DDSpanContext;
import com.datadoghq.trace.util.Clock;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.opentracing.BaseSpan;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DDBaseSpan<S extends BaseSpan>
implements BaseSpan<S> {
    private static final Logger log = LoggerFactory.getLogger(DDBaseSpan.class);
    protected final DDSpanContext context;
    protected long startTimeMicro;
    protected long startTimeNano;
    protected long durationNano;

    protected DDBaseSpan(long timestampMicro, DDSpanContext context) {
        this.context = context;
        this.startTimeMicro = timestampMicro == 0L ? Clock.currentMicroTime() : timestampMicro;
        this.startTimeNano = Clock.currentNanoTicks();
        this.context.getTrace().add(this);
    }

    public final void finish() {
        this.finish(Clock.currentMicroTime());
    }

    public final void finish(long stoptimeMicros) {
        this.durationNano = Math.max(1L, TimeUnit.MICROSECONDS.toNanos(stoptimeMicros - this.startTimeMicro));
        this.afterFinish();
    }

    protected final void afterFinish() {
        log.debug("{} - Closing the span.", (Object)this);
        if (this.isRootSpan()) {
            Queue<DDBaseSpan<?>> spans = this.context().getTrace();
            for (DDBaseSpan dDBaseSpan : spans) {
                if (dDBaseSpan.getDurationNano() != 0L) continue;
                log.warn("{} - The parent span is marked as finished but this span isn't. You have to close each children.", (Object)this);
            }
            this.context.getTracer().write(this.context.getTrace());
            log.debug("{} - Write the trace", (Object)this);
        }
    }

    protected final boolean isRootSpan() {
        if (this.context().getTrace().isEmpty()) {
            return false;
        }
        DDBaseSpan<?> first = this.context().getTrace().peek();
        return first.context().getSpanId() == this.context().getSpanId() && this.context.getTracer() != null;
    }

    public void setErrorMeta(Throwable error) {
        this.context.setErrorFlag(true);
        this.setTag("error.msg", error.getMessage());
        this.setTag("error.type", error.getClass().getName());
        StringWriter errorString = new StringWriter();
        error.printStackTrace(new PrintWriter(errorString));
        this.setTag("error.stack", errorString.toString());
    }

    private boolean extractError(Map<String, ?> map) {
        if (map.get("error.object") instanceof Throwable) {
            Throwable error = (Throwable)map.get("error.object");
            this.setErrorMeta(error);
            return true;
        }
        return false;
    }

    public final S setTag(String tag, String value) {
        this.context().setTag(tag, value);
        return this.thisInstance();
    }

    public final S setTag(String tag, boolean value) {
        this.context().setTag(tag, value);
        return this.thisInstance();
    }

    public final S setTag(String tag, Number value) {
        this.context().setTag(tag, value);
        return this.thisInstance();
    }

    public final DDSpanContext context() {
        return this.context;
    }

    public final String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    public final S setBaggageItem(String key, String value) {
        this.context.setBaggageItem(key, value);
        return this.thisInstance();
    }

    public final S setOperationName(String operationName) {
        this.context().setOperationName(operationName);
        return this.thisInstance();
    }

    public final S log(Map<String, ?> map) {
        if (!this.extractError(map)) {
            log.debug("`log` method is not implemented. Doing nothing");
        }
        return this.thisInstance();
    }

    public final S log(long l, Map<String, ?> map) {
        if (!this.extractError(map)) {
            log.debug("`log` method is not implemented. Doing nothing");
        }
        return this.thisInstance();
    }

    public final S log(String s) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this.thisInstance();
    }

    public final S log(long l, String s) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this.thisInstance();
    }

    public final S log(String s, Object o) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this.thisInstance();
    }

    public final S log(long l, String s, Object o) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)s);
        return this.thisInstance();
    }

    public final S setServiceName(String serviceName) {
        this.context().setServiceName(serviceName);
        return this.thisInstance();
    }

    public final S setResourceName(String resourceName) {
        this.context().setResourceName(resourceName);
        return this.thisInstance();
    }

    public final S setSpanType(String type) {
        this.context().setSpanType(type);
        return this.thisInstance();
    }

    protected abstract S thisInstance();

    @JsonGetter
    public Map<String, String> getMeta() {
        HashMap<String, String> meta = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.context().getBaggageItems().entrySet()) {
            meta.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getTags().entrySet()) {
            meta.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return meta;
    }

    @JsonGetter(value="start")
    public long getStartTime() {
        return this.startTimeMicro * 1000L;
    }

    @JsonGetter(value="duration")
    public long getDurationNano() {
        return this.durationNano;
    }

    @JsonGetter(value="service")
    public String getServiceName() {
        return this.context.getServiceName();
    }

    @JsonGetter(value="trace_id")
    public long getTraceId() {
        return this.context.getTraceId();
    }

    @JsonGetter(value="span_id")
    public long getSpanId() {
        return this.context.getSpanId();
    }

    @JsonGetter(value="parent_id")
    public long getParentId() {
        return this.context.getParentId();
    }

    @JsonGetter(value="resource")
    public String getResourceName() {
        return this.context.getResourceName();
    }

    @JsonGetter(value="name")
    public String getOperationName() {
        return this.context.getOperationName();
    }

    @JsonIgnore
    public Map<String, Object> getTags() {
        return this.context().getTags();
    }

    @JsonGetter
    public String getType() {
        return this.context.getSpanType();
    }

    @JsonGetter
    public int getError() {
        return this.context.getErrorFlag() ? 1 : 0;
    }

    public String toString() {
        return this.context.toString() + ", duration_ns=" + this.durationNano;
    }
}

