/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace;

import com.datadoghq.trace.DDBaseSpan;
import com.datadoghq.trace.DDTracer;
import com.datadoghq.trace.integration.AbstractDecorator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements SpanContext {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    private final long traceId;
    private final long spanId;
    private final long parentId;
    private final String threadName = Thread.currentThread().getName();
    private final long threadId = Thread.currentThread().getId();
    private final Queue<DDBaseSpan<?>> trace;
    private final DDTracer tracer;
    private Map<String, String> baggageItems;
    private String serviceName;
    private String resourceName;
    private boolean errorFlag;
    private String spanType;
    private String operationName;
    private Map<String, Object> tags;

    public DDSpanContext(long traceId, long spanId, long parentId, String serviceName, String operationName, String resourceName, Map<String, String> baggageItems, boolean errorFlag, String spanType, Map<String, Object> tags, Queue<DDBaseSpan<?>> trace, DDTracer tracer) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.baggageItems = baggageItems == null ? Collections.emptyMap() : baggageItems;
        this.serviceName = serviceName;
        this.operationName = operationName;
        this.resourceName = resourceName;
        this.errorFlag = errorFlag;
        this.spanType = spanType;
        this.tags = tags;
        this.trace = trace == null ? new ConcurrentLinkedQueue() : trace;
        this.tracer = tracer;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getResourceName() {
        return this.resourceName == null || this.resourceName.isEmpty() ? this.operationName : this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public String getSpanType() {
        return this.spanType;
    }

    public void setSpanType(String spanType) {
        this.spanType = spanType;
    }

    public void setBaggageItem(String key, String value) {
        if (this.baggageItems.isEmpty()) {
            this.baggageItems = new HashMap<String, String>();
        }
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @JsonIgnore
    public Queue<DDBaseSpan<?>> getTrace() {
        return this.trace;
    }

    @JsonIgnore
    public DDTracer getTracer() {
        return this.tracer;
    }

    public synchronized void setTag(String tag, Object value) {
        if (value == null) {
            this.tags.remove(tag);
            return;
        }
        if (tag.equals("service.name")) {
            this.setServiceName(value.toString());
            return;
        }
        if (tag.equals("resource.name")) {
            this.setResourceName(value.toString());
            return;
        }
        if (tag.equals("span.type")) {
            this.setSpanType(value.toString());
            return;
        }
        if (this.tags.isEmpty()) {
            this.tags = new HashMap<String, Object>();
        }
        this.tags.put(tag, value);
        List<AbstractDecorator> decorators = this.tracer.getSpanContextDecorators(tag);
        if (decorators != null && value != null) {
            for (AbstractDecorator decorator : decorators) {
                try {
                    decorator.afterSetTag(this, tag, value);
                }
                catch (Throwable ex) {
                    log.warn("Could not decorate the span decorator={}: {}", (Object)decorator.getClass().getSimpleName(), (Object)ex.getMessage());
                }
            }
        }
        if (Tags.ERROR.getKey().equals(tag) && Boolean.TRUE.equals(value instanceof String ? Boolean.valueOf((String)value) : value)) {
            this.errorFlag = true;
        }
    }

    public synchronized Map<String, Object> getTags() {
        if (this.tags.isEmpty()) {
            this.tags = Maps.newHashMapWithExpectedSize((int)2);
        }
        this.tags.put("thread.name", this.threadName);
        this.tags.put("thread.id", this.threadId);
        return Collections.unmodifiableMap(this.tags);
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Span [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append("] trace=").append(this.getServiceName()).append("/").append(this.getOperationName()).append("/").append(this.getResourceName());
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        if (this.tags != null) {
            s.append(" tags=").append(new TreeMap<String, Object>(this.tags));
        }
        return s.toString();
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }
}

