/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace;

import java.util.Properties;

public class DDTraceConfig
extends Properties {
    private static final String PREFIX = "dd.";
    public static final String SERVICE_NAME = "service.name";
    public static final String WRITER_TYPE = "writer.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String AGENT_PORT = "agent.port";
    public static final String SAMPLER_TYPE = "sampler.type";
    public static final String SAMPLER_RATE = "sampler.rate";
    private final String serviceName = this.getPropOrEnv("dd.service.name");
    private final String writerType = this.getPropOrEnv("dd.writer.type");
    private final String agentHost = this.getPropOrEnv("dd.agent.host");
    private final String agentPort = this.getPropOrEnv("dd.agent.port");
    private final String samplerType = this.getPropOrEnv("dd.sampler.type");
    private final String samplerRate = this.getPropOrEnv("dd.sampler.rate");

    public DDTraceConfig() {
        Properties defaults = new Properties();
        defaults.setProperty(SERVICE_NAME, "unnamed-java-app");
        this.defaults = defaults;
        Properties baseValues = new Properties(defaults);
        this.setIfNotNull(SERVICE_NAME, this.serviceName);
        this.setIfNotNull(WRITER_TYPE, this.writerType);
        this.setIfNotNull(AGENT_HOST, this.agentHost);
        this.setIfNotNull(AGENT_PORT, this.agentPort);
        this.setIfNotNull(SAMPLER_TYPE, this.samplerType);
        this.setIfNotNull(SAMPLER_RATE, this.samplerRate);
    }

    public DDTraceConfig(String serviceName) {
        this.put(SERVICE_NAME, serviceName);
    }

    private void setIfNotNull(String key, String value) {
        if (value != null) {
            this.setProperty(key, value);
        }
    }

    private String getPropOrEnv(String name) {
        return System.getProperty(name, System.getenv(DDTraceConfig.propToEnvName(name)));
    }

    static String propToEnvName(String name) {
        return name.toUpperCase().replace(".", "_");
    }
}

