/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.integration;

import com.datadoghq.trace.DDSpanContext;
import com.datadoghq.trace.integration.AbstractDecorator;
import io.opentracing.tag.Tags;

public class DBTypeDecorator
extends AbstractDecorator {
    public DBTypeDecorator() {
        this.setMatchingTag(Tags.DB_TYPE.getKey());
        this.setSetTag("service.name");
    }

    @Override
    public boolean afterSetTag(DDSpanContext context, String tag, Object value) {
        if (super.afterSetTag(context, tag, value)) {
            if ("mongo".equals(value)) {
                context.setSpanType("mongodb");
            } else {
                context.setSpanType("sql");
            }
            context.setOperationName(String.valueOf(value) + ".query");
            return true;
        }
        return false;
    }
}

