/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.propagation;

import com.datadoghq.trace.DDSpanContext;
import com.datadoghq.trace.propagation.Codec;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCodec
implements Codec<TextMap> {
    private static final Logger log = LoggerFactory.getLogger(HTTPCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    private static final String TRACE_ID_KEY = "x-datadog-trace-id";
    private static final String SPAN_ID_KEY = "x-datadog-parent-id";

    @Override
    public void inject(DDSpanContext context, TextMap carrier) {
        carrier.put(TRACE_ID_KEY, String.valueOf(context.getTraceId()));
        carrier.put(SPAN_ID_KEY, String.valueOf(context.getSpanId()));
        for (Map.Entry<String, String> entry : context.baggageItems()) {
            carrier.put(OT_BAGGAGE_PREFIX + entry.getKey(), this.encode(entry.getValue()));
        }
    }

    @Override
    public DDSpanContext extract(TextMap carrier) {
        Map<String, String> baggage = Collections.emptyMap();
        Long traceId = 0L;
        Long spanId = 0L;
        for (Map.Entry entry : carrier) {
            String key = ((String)entry.getKey()).toLowerCase();
            if (key.equalsIgnoreCase(TRACE_ID_KEY)) {
                traceId = Long.parseLong((String)entry.getValue());
                continue;
            }
            if (key.equalsIgnoreCase(SPAN_ID_KEY)) {
                spanId = Long.parseLong((String)entry.getValue());
                continue;
            }
            if (!key.startsWith(OT_BAGGAGE_PREFIX)) continue;
            if (baggage.isEmpty()) {
                baggage = new HashMap<String, String>();
            }
            baggage.put(key.replace(OT_BAGGAGE_PREFIX, ""), this.decode((String)entry.getValue()));
        }
        DDSpanContext context = null;
        if (traceId != 0L) {
            context = new DDSpanContext(traceId, spanId, 0L, null, null, null, baggage, false, null, null, null, null);
            log.debug("{} - Parent context extracted", (Object)context);
        }
        return context;
    }

    private String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    private String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }
}

