/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.resolver;

import com.datadoghq.trace.integration.AbstractDecorator;
import com.datadoghq.trace.resolver.DDSpanDecoratorConfig;
import com.datadoghq.trace.resolver.FactoryUtils;
import com.datadoghq.trace.resolver.TracerConfig;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDDecoratorsFactory {
    private static final Logger log = LoggerFactory.getLogger(DDDecoratorsFactory.class);
    public static final String CONFIG_PATH = "dd-trace-decorators";
    public static String DECORATORS_PACKAGE = "com.datadoghq.trace.integration.";

    public static List<AbstractDecorator> create(List<DDSpanDecoratorConfig> decoratorsConfig) {
        ArrayList<AbstractDecorator> decorators = new ArrayList<AbstractDecorator>();
        for (DDSpanDecoratorConfig decoratorConfig : decoratorsConfig) {
            Class<?> decoratorClass;
            if (decoratorConfig.getType() == null) {
                log.warn("Cannot create decorator without type from configuration {}", (Object)decoratorConfig);
                continue;
            }
            try {
                decoratorClass = Class.forName(DECORATORS_PACKAGE + decoratorConfig.getType());
            }
            catch (ClassNotFoundException e) {
                log.warn("Cannot create decorator as the class {} is not defined. Provided configuration {}", (Object)decoratorConfig);
                continue;
            }
            AbstractDecorator decorator = null;
            try {
                decorator = (AbstractDecorator)decoratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("Cannot create decorator as we could not invoke the default constructor. Provided configuration {}", (Object)decoratorConfig);
                continue;
            }
            if (decoratorConfig.getMatchingTag() != null) {
                decorator.setMatchingTag(decoratorConfig.getMatchingTag());
            }
            if (decoratorConfig.getMatchingValue() != null) {
                decorator.setMatchingValue(decoratorConfig.getMatchingValue());
            }
            if (decoratorConfig.getSetTag() != null) {
                decorator.setSetTag(decoratorConfig.getSetTag());
            }
            if (decoratorConfig.getSetValue() != null) {
                decorator.setSetValue(decoratorConfig.getSetValue());
            }
            decorators.add(decorator);
        }
        return decorators;
    }

    public static List<AbstractDecorator> createFromResources() {
        List<AbstractDecorator> result = new ArrayList<AbstractDecorator>();
        TracerConfig config = FactoryUtils.loadConfigFromResource(CONFIG_PATH, TracerConfig.class);
        if (config != null) {
            result = DDDecoratorsFactory.create(config.getDecorators());
        }
        return result;
    }
}

