/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.resolver;

import com.datadoghq.trace.DDTracer;
import com.datadoghq.trace.integration.AbstractDecorator;
import com.datadoghq.trace.resolver.DDDecoratorsFactory;
import com.datadoghq.trace.resolver.FactoryUtils;
import com.datadoghq.trace.resolver.TracerConfig;
import com.datadoghq.trace.resolver.WriterConfig;
import com.datadoghq.trace.sampling.AbstractSampler;
import com.datadoghq.trace.sampling.AllSampler;
import com.datadoghq.trace.sampling.RateSampler;
import com.datadoghq.trace.sampling.Sampler;
import com.datadoghq.trace.writer.DDAgentWriter;
import com.datadoghq.trace.writer.DDApi;
import com.datadoghq.trace.writer.LoggingWriter;
import com.datadoghq.trace.writer.Writer;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracerFactory {
    private static final Logger log = LoggerFactory.getLogger(DDTracerFactory.class);
    public static final String SYSTEM_PROPERTY_CONFIG_PATH = "dd.trace.configurationFile";
    public static final String CONFIG_PATH = "dd-trace";
    private static final String DD_AGENT_WRITER_TYPE = DDAgentWriter.class.getSimpleName();
    private static final String LOGGING_WRITER_TYPE = LoggingWriter.class.getSimpleName();
    private static final String ALL_SAMPLER_TYPE = AllSampler.class.getSimpleName();
    private static final String RATE_SAMPLER_TYPE = RateSampler.class.getSimpleName();

    static DDTracer create(TracerConfig config) {
        WriterConfig c;
        String defaultServiceName;
        String string = defaultServiceName = config.getDefaultServiceName() != null ? config.getDefaultServiceName() : "unnamed-java-app";
        Writer writer = config.getWriter() != null ? (DD_AGENT_WRITER_TYPE.equals((c = config.getWriter()).getType()) ? new DDAgentWriter(new DDApi(c.getHost("localhost"), c.getPort(8126))) : (LOGGING_WRITER_TYPE.equals(c.getType()) ? new LoggingWriter() : DDTracer.UNASSIGNED_WRITER)) : DDTracer.UNASSIGNED_WRITER;
        Sampler sampler = config.getSampler() != null ? (RATE_SAMPLER_TYPE.equals(config.getSampler().getType()) ? new RateSampler(config.getSampler().getRate()) : (ALL_SAMPLER_TYPE.equals(config.getSampler().getType()) ? new AllSampler() : DDTracer.UNASSIGNED_SAMPLER)) : DDTracer.UNASSIGNED_SAMPLER;
        Map<String, String> skipTagsPatterns = config.getSampler().getSkipTagsPatterns();
        if (skipTagsPatterns != null && sampler instanceof AbstractSampler) {
            AbstractSampler aSampler = (AbstractSampler)sampler;
            for (Map.Entry<String, String> entry : skipTagsPatterns.entrySet()) {
                aSampler.addSkipTagPattern(entry.getKey(), Pattern.compile(entry.getValue()));
            }
        }
        return new DDTracer(defaultServiceName, writer, sampler);
    }

    @Deprecated
    public static DDTracer createFromConfigurationFile() {
        TracerConfig tracerConfig = FactoryUtils.loadConfigFromFilePropertyOrResource(SYSTEM_PROPERTY_CONFIG_PATH, CONFIG_PATH, TracerConfig.class);
        log.warn("DDTracerFactory is deprecated and will be removed in the next release.");
        log.warn("Use the constructor on DDTrace directly and env vars/sys props for config.");
        DDTracer tracer = null;
        log.trace("Tracer configuration: \n{}", (Object)tracerConfig);
        if (tracerConfig == null) {
            log.info("No valid configuration file {} found. Loading default tracer.", (Object)CONFIG_PATH);
            tracer = new DDTracer();
        } else {
            log.debug("Create a tracer instance from the configuration");
            tracer = DDTracerFactory.create(tracerConfig);
        }
        List<AbstractDecorator> decorators = DDDecoratorsFactory.createFromResources();
        for (AbstractDecorator decorator : decorators) {
            log.debug("Loading decorator: {}", (Object)decorator.getClass().getSimpleName());
            tracer.addDecorator(decorator);
        }
        return tracer;
    }
}

