/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.resolver;

import com.datadoghq.trace.DDTracer;
import com.datadoghq.trace.resolver.DDTracerFactory;
import com.datadoghq.trace.resolver.FactoryUtils;
import com.datadoghq.trace.resolver.TracerConfig;
import io.opentracing.NoopTracerFactory;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.util.GlobalTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracerResolver
extends TracerResolver {
    private static final Logger log = LoggerFactory.getLogger(DDTracerResolver.class);

    public static Tracer registerTracer() {
        Tracer tracer = TracerResolver.resolveTracer();
        if (tracer == null) {
            log.warn("Cannot resolved the tracer, use NoopTracer");
            return NoopTracerFactory.create();
        }
        log.info("Register the tracer via GlobalTracer");
        GlobalTracer.register((Tracer)tracer);
        return tracer;
    }

    protected Tracer resolve() {
        log.info("Creating the Datadog Tracer from the resolver");
        TracerConfig tracerConfig = FactoryUtils.loadConfigFromFilePropertyOrResource("dd.trace.configurationFile", "dd-trace", TracerConfig.class);
        if (tracerConfig != null) {
            return DDTracerFactory.createFromConfigurationFile();
        }
        return new DDTracer();
    }
}

