/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.resolver;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryUtils {
    private static final Logger log = LoggerFactory.getLogger(FactoryUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static <A> A loadConfigFromFilePropertyOrResource(String systemProperty, String resourceName, Class<A> targetClass) {
        String filePath = System.getProperty(systemProperty);
        if (filePath != null) {
            try {
                log.info("Loading config from file " + filePath);
                return (A)objectMapper.readValue(new File(filePath), targetClass);
            }
            catch (Exception e) {
                log.error("Cannot read provided configuration file " + filePath + ". Using the default one.", (Throwable)e);
            }
        }
        return FactoryUtils.loadConfigFromResource(resourceName, targetClass);
    }

    public static <A> A loadConfigFromFilePropertyOrResource(String systemProperty, String resourceName, TypeReference<A> type) {
        String filePath = System.getProperty(systemProperty);
        if (filePath != null) {
            try {
                log.info("Loading config from file " + filePath);
                return (A)objectMapper.readValue(new File(filePath), type);
            }
            catch (Exception e) {
                log.error("Cannot read provided configuration file " + filePath + ". Using the default one.", (Throwable)e);
            }
        }
        return FactoryUtils.loadConfigFromResource(resourceName, type);
    }

    public static <A> A loadConfigFromResource(String resourceName, Class<A> targetClass) {
        Object config = null;
        if (!resourceName.endsWith(".yaml") && !resourceName.endsWith(".yml")) {
            config = FactoryUtils.loadConfigFromResource(resourceName + ".yaml", targetClass);
            if (config == null) {
                config = FactoryUtils.loadConfigFromResource(resourceName + ".yml", targetClass);
            }
            if (config != null) {
                return (A)config;
            }
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(resourceName);
            if (resource != null) {
                log.info("Loading config from resource " + resource);
                config = objectMapper.readValue(resource.openStream(), targetClass);
            }
        }
        catch (IOException e) {
            log.warn("Could not load configuration file {}.", (Object)resourceName);
            log.error("Error when loading config file", (Throwable)e);
        }
        return (A)config;
    }

    public static <A> A loadConfigFromResource(String resourceName, TypeReference<A> type) {
        Object config = null;
        if (!resourceName.endsWith(".yaml") && !resourceName.endsWith(".yml")) {
            config = FactoryUtils.loadConfigFromResource(resourceName + ".yaml", type);
            if (config == null) {
                config = FactoryUtils.loadConfigFromResource(resourceName + ".yml", type);
            }
            if (config != null) {
                return (A)config;
            }
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(resourceName);
            if (resource != null) {
                log.info("Loading config from resource " + resource);
                config = objectMapper.readValue(resource.openStream(), type);
            }
        }
        catch (IOException e) {
            log.warn("Could not load configuration file {}.", (Object)resourceName);
            log.error("Error when loading config file", (Throwable)e);
        }
        return (A)config;
    }
}

