/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.sampling;

import com.datadoghq.trace.DDBaseSpan;
import com.datadoghq.trace.sampling.Sampler;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractSampler
implements Sampler {
    protected Map<String, Pattern> skipTagsPatterns = new HashMap<String, Pattern>();

    @Override
    public boolean sample(DDBaseSpan<?> span) {
        for (Map.Entry<String, Pattern> entry : this.skipTagsPatterns.entrySet()) {
            Object value = span.getTags().get(entry.getKey());
            if (value == null) continue;
            String strValue = String.valueOf(value);
            Pattern skipPattern = entry.getValue();
            if (!skipPattern.matcher(strValue).matches()) continue;
            return false;
        }
        return this.doSample(span);
    }

    public void addSkipTagPattern(String tag, Pattern skipPattern) {
        this.skipTagsPatterns.put(tag, skipPattern);
    }

    protected abstract boolean doSample(DDBaseSpan<?> var1);
}

