/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.sampling;

import com.datadoghq.trace.DDBaseSpan;
import com.datadoghq.trace.sampling.AbstractSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateSampler
extends AbstractSampler {
    private static final Logger log = LoggerFactory.getLogger(RateSampler.class);
    private final double sampleRate;

    public RateSampler(String sampleRate) {
        this(sampleRate == null ? 1.0 : Double.valueOf(sampleRate));
    }

    public RateSampler(double sampleRate) {
        if (sampleRate <= 0.0) {
            sampleRate = 1.0;
            log.error("SampleRate is negative or null, disabling the sampler");
        } else if (sampleRate > 1.0) {
            sampleRate = 1.0;
        }
        this.sampleRate = sampleRate;
        log.debug("Initializing the RateSampler, sampleRate: {} %", (Object)(this.sampleRate * 100.0));
    }

    @Override
    public boolean doSample(DDBaseSpan<?> span) {
        boolean sample = Math.random() <= this.sampleRate;
        log.debug("{} - Span is sampled: {}", span, (Object)sample);
        return sample;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public String toString() {
        return "RateSampler { sampleRate=" + this.sampleRate + " }";
    }
}

