/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.writer;

import com.datadoghq.trace.DDBaseSpan;
import com.datadoghq.trace.DDTracer;
import com.datadoghq.trace.Service;
import com.datadoghq.trace.writer.DDAgentWriter;
import com.datadoghq.trace.writer.DDApi;
import com.datadoghq.trace.writer.LoggingWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public interface Writer {
    public static final String DD_AGENT_WRITER_TYPE = DDAgentWriter.class.getSimpleName();
    public static final String LOGGING_WRITER_TYPE = LoggingWriter.class.getSimpleName();

    public void write(List<DDBaseSpan<?>> var1);

    public void writeServices(Map<String, Service> var1);

    public void start();

    public void close();

    public static final class Builder {
        public static Writer forConfig(Properties config) {
            String configuredType;
            Writer writer = config != null ? (DD_AGENT_WRITER_TYPE.equals(configuredType = config.getProperty("writer.type")) ? new DDAgentWriter(new DDApi(config.getProperty("agent.host"), Integer.parseInt(config.getProperty("agent.port")))) : (LOGGING_WRITER_TYPE.equals(configuredType) ? new LoggingWriter() : DDTracer.UNASSIGNED_WRITER)) : DDTracer.UNASSIGNED_WRITER;
            return writer;
        }

        private Builder() {
        }
    }
}

