/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.trace.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

class WriterQueue<T> {
    private final int capacity;
    private volatile ArrayList<T> list;

    WriterQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity couldn't be 0");
        }
        this.list = this.emptyList(capacity);
        this.capacity = capacity;
    }

    public synchronized List<T> getAll() {
        ArrayList<T> all = this.list;
        this.list = this.emptyList(this.capacity);
        return all;
    }

    public synchronized T add(T element) {
        T removed = null;
        if (this.list.size() < this.capacity) {
            this.list.add(element);
        } else {
            int index = ThreadLocalRandom.current().nextInt(0, this.list.size());
            removed = this.list.set(index, element);
        }
        return removed;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    private ArrayList<T> emptyList(int capacity) {
        return new ArrayList(capacity);
    }
}

