/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.profiler;

import com.datadoghq.profiler.JavaProfiler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ContextSetter {
    private static final int TAGS_STORAGE_LIMIT = 10;
    private final List<String> attributes;
    private final JavaProfiler profiler;
    private final ConcurrentHashMap<String, Integer> jniCache = new ConcurrentHashMap();

    public ContextSetter(JavaProfiler profiler, List<String> attributes) {
        this.profiler = profiler;
        HashSet<String> unique = new HashSet<String>(attributes);
        this.attributes = new ArrayList<String>(unique.size());
        for (int i = 0; i < Math.min(attributes.size(), 10); ++i) {
            String attribute = attributes.get(i);
            if (!unique.remove(attribute)) continue;
            this.attributes.add(attribute);
        }
    }

    public int encode(String key) {
        if (key != null) {
            int e;
            Integer encoding = this.jniCache.get(key);
            if (encoding != null) {
                return encoding;
            }
            if (this.jniCache.size() <= 65536 && (e = this.profiler.registerConstant(key)) > 0 && this.jniCache.putIfAbsent(key, e) == null) {
                return e;
            }
        }
        return 0;
    }

    public int[] snapshotTags() {
        int[] snapshot = new int[this.attributes.size()];
        this.snapshotTags(snapshot);
        return snapshot;
    }

    public void snapshotTags(int[] snapshot) {
        if (snapshot.length <= this.attributes.size()) {
            this.profiler.copyTags(snapshot);
        }
    }

    public int offsetOf(String attribute) {
        return this.attributes.indexOf(attribute);
    }

    public boolean setContextValue(String attribute, String value) {
        return this.setContextValue(this.offsetOf(attribute), value);
    }

    public boolean setContextValue(int offset, String value) {
        int encoding;
        if (offset >= 0 && (encoding = this.encode(value)) >= 0) {
            this.setContextValue(offset, encoding);
            return true;
        }
        return false;
    }

    public boolean setContextValue(int offset, int encoding) {
        if (offset >= 0 && encoding >= 0) {
            this.profiler.setContextValue(offset, encoding);
            return true;
        }
        return false;
    }

    public boolean clearContextValue(String attribute) {
        return this.clearContextValue(this.offsetOf(attribute));
    }

    public boolean clearContextValue(int offset) {
        if (offset >= 0) {
            this.profiler.setContextValue(offset, 0);
            return true;
        }
        return false;
    }
}

