/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.profiler;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

enum OperatingSystem {
    linux("Linux", "linux"),
    macos("Mac OS X", "macOS", "mac"),
    unknown(new String[0]);

    private final Set<String> identifiers;

    private OperatingSystem(String ... identifiers) {
        this.identifiers = new HashSet<String>(Arrays.asList(identifiers));
    }

    public static OperatingSystem of(String identifier) {
        for (OperatingSystem os : EnumSet.allOf(OperatingSystem.class)) {
            if (!os.identifiers.contains(identifier)) continue;
            return os;
        }
        return unknown;
    }

    public static OperatingSystem current() {
        return OperatingSystem.of(System.getProperty("os.name"));
    }
}

